/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.autumn.messages;

import com.juanmuscaria.autumn.messages.MessageSourceResolvable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.jetbrains.annotations.Nullable;

public class DefaultMessageSourceResolvable
implements MessageSourceResolvable,
Serializable {
    @Nullable
    private final String[] codes;
    @Nullable
    private final Object[] arguments;
    @Nullable
    private final String defaultMessage;

    public DefaultMessageSourceResolvable(String code) {
        this(new String[]{code}, null, null);
    }

    public DefaultMessageSourceResolvable(String[] codes) {
        this(codes, null, null);
    }

    public DefaultMessageSourceResolvable(String[] codes, String defaultMessage) {
        this(codes, null, defaultMessage);
    }

    public DefaultMessageSourceResolvable(String[] codes, Object[] arguments) {
        this(codes, arguments, null);
    }

    public DefaultMessageSourceResolvable(@Nullable String[] codes, @Nullable Object[] arguments, @Nullable String defaultMessage) {
        this.codes = codes;
        this.arguments = arguments;
        this.defaultMessage = defaultMessage;
    }

    public DefaultMessageSourceResolvable(MessageSourceResolvable resolvable) {
        this(resolvable.getCodes(), resolvable.getArguments(), resolvable.getDefaultMessage());
    }

    @Nullable
    public String getCode() {
        return this.codes != null && this.codes.length > 0 ? this.codes[this.codes.length - 1] : null;
    }

    @Override
    @Nullable
    public String[] getCodes() {
        return this.codes;
    }

    @Override
    @Nullable
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    @Nullable
    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public boolean shouldRenderDefaultMessage() {
        return true;
    }

    protected final String resolvableToString() {
        StringBuilder result = new StringBuilder(64);
        result.append("codes [").append(DefaultMessageSourceResolvable.arrayToDelimitedString(this.codes, ","));
        result.append("]; arguments [").append(DefaultMessageSourceResolvable.arrayToDelimitedString(this.arguments, ","));
        result.append("]; default message [").append(this.defaultMessage).append(']');
        return result.toString();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.resolvableToString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMessageSourceResolvable that = (DefaultMessageSourceResolvable)o;
        if (!Arrays.equals(this.codes, that.codes)) {
            return false;
        }
        if (!Arrays.equals(this.arguments, that.arguments)) {
            return false;
        }
        return Objects.equals(this.defaultMessage, that.defaultMessage);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.codes);
        result = 31 * result + Arrays.hashCode(this.arguments);
        result = 31 * result + (this.defaultMessage != null ? this.defaultMessage.hashCode() : 0);
        return result;
    }

    static String arrayToDelimitedString(@Nullable Object[] arr, String delim) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        if (arr.length == 1) {
            return Objects.toString(arr[0]);
        }
        StringJoiner sj = new StringJoiner(delim);
        for (Object elem : arr) {
            sj.add(String.valueOf(elem));
        }
        return sj.toString();
    }
}

