/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.autumn.messages;

import com.juanmuscaria.autumn.messages.MessageSource;
import com.juanmuscaria.autumn.messages.NoSuchMessageException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nullable;

public class MessageSourceResourceBundle
extends ResourceBundle {
    private final MessageSource messageSource;
    private final Locale locale;

    public MessageSourceResourceBundle(MessageSource source, Locale locale) {
        this.messageSource = Objects.requireNonNull(source, "MessageSource must not be null");
        this.locale = locale;
    }

    public MessageSourceResourceBundle(MessageSource source, Locale locale, ResourceBundle parent) {
        this(source, locale);
        this.setParent(parent);
    }

    @Override
    @Nullable
    protected Object handleGetObject(String key) {
        try {
            return this.messageSource.getMessage(key, null, this.locale);
        }
        catch (NoSuchMessageException ex) {
            return null;
        }
    }

    @Override
    public boolean containsKey(String key) {
        try {
            this.messageSource.getMessage(key, null, this.locale);
            return true;
        }
        catch (NoSuchMessageException ex) {
            return false;
        }
    }

    @Override
    public Enumeration<String> getKeys() {
        throw new UnsupportedOperationException("MessageSourceResourceBundle does not support enumerating its keys");
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }
}

