/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.autumn.resources;

import com.juanmuscaria.autumn.resources.AbstractFileResolvingResource;
import com.juanmuscaria.autumn.resources.Resource;
import com.juanmuscaria.autumn.resources.ResourceUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ClassPathResource
extends AbstractFileResolvingResource {
    private final String path;
    private final String absolutePath;
    @Nullable
    private final ClassLoader classLoader;
    @Nullable
    private final Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, (ClassLoader)null);
    }

    public ClassPathResource(String path, @Nullable ClassLoader classLoader) {
        Objects.requireNonNull(path, "Path must not be null");
        String pathToUse = ResourceUtils.cleanPath(path);
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        this.path = pathToUse;
        this.absolutePath = pathToUse;
        this.classLoader = classLoader != null ? classLoader : ResourceUtils.getDefaultClassLoader();
        this.clazz = null;
    }

    public ClassPathResource(String path, @Nullable Class<?> clazz) {
        Objects.requireNonNull(path, "Path must not be null");
        String absolutePath = this.path = ResourceUtils.cleanPath(path);
        if (clazz != null && !absolutePath.startsWith("/")) {
            absolutePath = ResourceUtils.classPackageAsResourcePath(clazz) + "/" + absolutePath;
        } else if (absolutePath.startsWith("/")) {
            absolutePath = absolutePath.substring(1);
        }
        this.absolutePath = absolutePath;
        this.classLoader = null;
        this.clazz = clazz;
    }

    public final String getPath() {
        return this.absolutePath;
    }

    @Nullable
    public final ClassLoader getClassLoader() {
        return this.clazz != null ? this.clazz.getClassLoader() : this.classLoader;
    }

    @Override
    public boolean exists() {
        return this.resolveURL() != null;
    }

    @Override
    public boolean isReadable() {
        URL url = this.resolveURL();
        return url != null && this.checkReadable(url);
    }

    @Nullable
    protected URL resolveURL() {
        try {
            if (this.clazz != null) {
                return this.clazz.getResource(this.path);
            }
            if (this.classLoader != null) {
                return this.classLoader.getResource(this.absolutePath);
            }
            return ClassLoader.getSystemResource(this.absolutePath);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.clazz != null ? this.clazz.getResourceAsStream(this.path) : (this.classLoader != null ? this.classLoader.getResourceAsStream(this.absolutePath) : ClassLoader.getSystemResourceAsStream(this.absolutePath));
        if (is == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be opened because it does not exist");
        }
        return is;
    }

    @Override
    public URL getURL() throws IOException {
        URL url = this.resolveURL();
        if (url == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    @Override
    public Resource createRelative(String relativePath) {
        String pathToUse = ResourceUtils.applyRelativePath(this.path, relativePath);
        return this.clazz != null ? new ClassPathResource(pathToUse, this.clazz) : new ClassPathResource(pathToUse, this.classLoader);
    }

    @Override
    @Nullable
    public String getFilename() {
        return ResourceUtils.getFilename(this.absolutePath);
    }

    @Override
    public String getDescription() {
        return "class path resource [" + this.absolutePath + "]";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ClassPathResource && this.absolutePath.equals(((ClassPathResource)other).absolutePath) && Objects.equals(this.getClassLoader(), ((ClassPathResource)other).getClassLoader());
    }

    @Override
    public int hashCode() {
        return this.absolutePath.hashCode();
    }
}

