/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.autumn.resources;

import com.juanmuscaria.autumn.resources.FileCopyUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import org.jetbrains.annotations.Nullable;

public interface Resource {
    public boolean exists();

    default public boolean isReadable() {
        return this.exists();
    }

    default public boolean isOpen() {
        return false;
    }

    default public boolean isFile() {
        return false;
    }

    public URL getURL() throws IOException;

    public URI getURI() throws IOException;

    public File getFile() throws IOException;

    default public ReadableByteChannel readableChannel() throws IOException {
        return Channels.newChannel(this.getInputStream());
    }

    default public byte[] getContentAsByteArray() throws IOException {
        return FileCopyUtils.copyToByteArray(this.getInputStream());
    }

    default public String getContentAsString(Charset charset) throws IOException {
        return new String(FileCopyUtils.copyToByteArray(this.getInputStream()), charset);
    }

    public long contentLength() throws IOException;

    public long lastModified() throws IOException;

    public Resource createRelative(String var1) throws IOException;

    @Nullable
    public String getFilename();

    public String getDescription();

    public InputStream getInputStream() throws IOException;
}

