/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.modpackdirector;

import com.juanmuscaria.autumn.messages.MessageSourceSupport;
import com.juanmuscaria.modpackdirector.UnsafeExit;
import com.juanmuscaria.modpackdirector.i18n.Messages;
import com.juanmuscaria.modpackdirector.logging.LoggerDelegate;
import com.juanmuscaria.modpackdirector.ui.DirectorMainGUI;
import com.juanmuscaria.modpackdirector.ui.page.ConsentPage;
import com.juanmuscaria.modpackdirector.ui.page.MessagePage;
import com.juanmuscaria.modpackdirector.ui.page.ModSelectionPage;
import com.juanmuscaria.modpackdirector.ui.page.ProgressPage;
import com.juanmuscaria.modpackdirector.ui.theme.UITheme;
import com.juanmuscaria.modpackdirector.util.PlatformDelegate;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import net.jan.moddirector.core.configuration.ConfigurationController;
import net.jan.moddirector.core.configuration.ModDirectorRemoteMod;
import net.jan.moddirector.core.configuration.modpack.ModpackConfiguration;
import net.jan.moddirector.core.configuration.modpack.ModpackIconConfiguration;
import net.jan.moddirector.core.exception.ModDirectorException;
import net.jan.moddirector.core.manage.InstallController;
import net.jan.moddirector.core.manage.ModDirectorError;
import net.jan.moddirector.core.manage.NoOpProgressCallback;
import net.jan.moddirector.core.manage.ProgressCallback;
import net.jan.moddirector.core.manage.check.StopModReposts;
import net.jan.moddirector.core.manage.install.InstallableMod;
import net.jan.moddirector.core.manage.install.InstalledMod;
import net.jan.moddirector.core.manage.select.InstallSelector;
import net.jan.moddirector.core.util.ImageLoader;
import net.jan.moddirector.core.util.WebClient;
import net.jan.moddirector.core.util.WebGetResponse;

public class ModpackDirector
implements Callable<Boolean> {
    private static final TimeUnit DEFAULT_UNIT = TimeUnit.DAYS;
    private static final int DEFAULT_TIME = 1;
    private static final AtomicInteger THREAD_NUMBER = new AtomicInteger();
    private static final NoOpProgressCallback NO_OP_PROGRESS_CALLBACK = new NoOpProgressCallback();
    private final ScheduledExecutorService taskExecutor = Executors.newScheduledThreadPool(Math.min(8, Math.max(4, Runtime.getRuntime().availableProcessors())), r -> new Thread(r, "ModpackDirector Worker " + THREAD_NUMBER.incrementAndGet()));
    private final ConcurrentLinkedDeque<ModDirectorError> errors = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<InstalledMod> installedMods = new ConcurrentLinkedDeque();
    private final InstallSelector installSelector = new InstallSelector();
    private final PlatformDelegate platform;
    private final LoggerDelegate logger;
    private final LookAndFeel prevLookAndFeel;
    private final ConfigurationController configurationController;
    private final InstallController installController;
    private final StopModReposts stopModReposts;
    private String modpackRemoteVersion;

    public ModpackDirector(PlatformDelegate platform) {
        this.platform = platform;
        this.logger = platform.logger();
        this.prevLookAndFeel = UIManager.getLookAndFeel();
        this.configurationController = new ConfigurationController(this, platform.configurationDirectory());
        this.installController = new InstallController(this);
        this.stopModReposts = new StopModReposts(this);
    }

    @Override
    public Boolean call() throws Exception {
        ProgressPage installProgressPage;
        Logger log = Logger.getLogger(MessageSourceSupport.class.getName());
        log.setLevel(Level.FINEST);
        this.configurationController.load();
        List<ModDirectorRemoteMod> mods = this.configurationController.getConfigurations();
        ModpackConfiguration modpackConfiguration = this.configurationController.getModpackConfiguration();
        if (modpackConfiguration == null) {
            this.logger.warn("This modpack does not contain a modpack.json, if you are the author, consider adding one!", new Object[0]);
            modpackConfiguration = ModpackConfiguration.createDefault();
        } else if (modpackConfiguration.remoteVersion() != null) {
            try (WebGetResponse response = WebClient.get(modpackConfiguration.remoteVersion());
                 BufferedReader reader = new BufferedReader(new InputStreamReader(response.getInputStream(), StandardCharsets.UTF_8));){
                this.modpackRemoteVersion = reader.readLine();
            }
        }
        UITheme.apply(modpackConfiguration.uiTheme(), this.logger);
        if (this.hasFatalError()) {
            return false;
        }
        Messages messages = new Messages(this.platform, true);
        DirectorMainGUI ui = null;
        if (!this.platform.headless()) {
            ui = new DirectorMainGUI(messages, this.logger);
            ui.getModpackName().setText(modpackConfiguration.packName());
            ModpackIconConfiguration icon = modpackConfiguration.icon();
            Image iconImage = null;
            if (icon != null) {
                try {
                    iconImage = ImageLoader.getImage(icon.path(), icon.width(), icon.height());
                }
                catch (Throwable e) {
                    this.logger.error("Unable to load modpack icon {0}", icon.path(), e);
                }
            }
            ui.setModpackIcon(iconImage, icon == null ? null : new Dimension(icon.width(), icon.height()));
            ui.setLocationRelativeTo(null);
            ui.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ModpackDirector.this.logger.info("User asked to exit", new Object[0]);
                    UnsafeExit.exit(0);
                }
            });
            ui.setTitle(modpackConfiguration.packName());
            ui.pack();
            ui.setVisible(true);
        }
        ProgressPage preInstallationPage = ui == null ? null : ui.progressPage("modpack_director.progress.check_install", new Object[0]);
        ArrayList<ModDirectorRemoteMod> excludedMods = new ArrayList<ModDirectorRemoteMod>();
        ArrayList<InstallableMod> reInstalls = new ArrayList<InstallableMod>();
        ArrayList<InstallableMod> freshInstalls = new ArrayList<InstallableMod>();
        List<Callable<Void>> preInstallTasks = this.installController.createPreInstallTasks(mods, excludedMods, freshInstalls, reInstalls, preInstallationPage != null ? preInstallationPage::createProgressCallback : this::noOpCallback);
        this.awaitAll(this.taskExecutor.invokeAll(preInstallTasks));
        this.installSelector.accept(excludedMods, freshInstalls, reInstalls);
        if (this.hasFatalError()) {
            this.errorExit();
        }
        if (ui != null && this.installSelector.hasSelectableOptions()) {
            ModSelectionPage selection = ui.selectionPage(this.installSelector);
            selection.waitForNext();
        }
        List<InstallableMod> toInstall = this.installSelector.computeModsToInstall();
        if (ui != null && !toInstall.isEmpty()) {
            ConsentPage consent = ui.consent(toInstall);
            consent.waitForNext();
        }
        ProgressPage progressPage = installProgressPage = ui == null ? null : ui.progressPage("modpack_director.progress.install", modpackConfiguration.packName());
        List<Callable<Void>> installTasks = this.installController.createInstallTasks(toInstall, installProgressPage != null ? installProgressPage::createProgressCallback : this::noOpCallback);
        installTasks.add(() -> {
            this.installController.markDisabledMods(this.installSelector.computeDisabledMods());
            return null;
        });
        this.awaitAll(this.taskExecutor.invokeAll(installTasks));
        if (this.hasFatalError()) {
            this.errorExit();
        }
        this.taskExecutor.shutdown();
        if (!this.taskExecutor.awaitTermination(1L, DEFAULT_UNIT)) {
            this.logger.warn("Unable to terminate all tasks.", new Object[0]);
        }
        if (modpackConfiguration.remoteVersion() != null && modpackConfiguration.localVersion() != null && !this.modpackRemoteVersion.contains(modpackConfiguration.localVersion())) {
            this.logger.error("Modpack version mismatch!", new Object[0]);
            if (ui != null) {
                String baseKey = modpackConfiguration.refuseLaunch() ? "modpack_director.modpack_outdated_refuse_launch" : "modpack_director.modpack_outdated";
                MessagePage page = ui.messagePage(baseKey + ".title", baseKey, baseKey + ".button");
                page.waitForButton();
            }
            if (modpackConfiguration.refuseLaunch()) {
                this.logger.error("Please update before continuing!", new Object[0]);
                UnsafeExit.exit(1);
            }
        }
        if (modpackConfiguration.requiresRestart() && !freshInstalls.isEmpty()) {
            this.logger.info("Installation complete, a restart is required to complete initialization.", new Object[0]);
            if (ui != null) {
                ui.messagePage("modpack_director.restart_required.title", "modpack_director.restart_required", "modpack_director.restart_required.button").waitForButton();
            }
            UnsafeExit.exit(0);
        }
        if (ui != null) {
            ui.dispose();
        }
        return !this.hasFatalError();
    }

    public List<InstalledMod> getInstalledMods() {
        return new ArrayList<InstalledMod>(this.installedMods);
    }

    public void addError(ModDirectorError error) {
        this.errors.add(error);
    }

    public boolean hasFatalError() {
        return this.errors.stream().anyMatch(e -> e.getLevel() == Level.SEVERE);
    }

    private ProgressCallback noOpCallback(String title, String info) {
        return NO_OP_PROGRESS_CALLBACK;
    }

    public void errorExit() {
        this.logger.error("============================================================", new Object[0]);
        this.logger.error("Summary of {0} encountered errors:", this.errors.size());
        this.errors.forEach(e -> {
            if (e.getException() != null) {
                this.logger.log(e.getLevel(), e.getMessage(), e.getException());
            } else {
                this.logger.log(e.getLevel(), e.getMessage(), new Object[0]);
            }
        });
        this.logger.error("============================================================", new Object[0]);
        UnsafeExit.exit(1);
    }

    public LoggerDelegate logger() {
        return this.logger;
    }

    public PlatformDelegate platform() {
        return this.platform;
    }

    private void awaitAll(List<Future<Void>> futures) throws InterruptedException {
        for (Future<Void> future : futures) {
            try {
                future.get();
            }
            catch (CancellationException e) {
                this.logger.error("A future task was cancelled unexpectedly", e);
                this.addError(new ModDirectorError(Level.SEVERE, "A future task was cancelled unexpectedly", e));
            }
            catch (ExecutionException e) {
                this.logger.error("An exception occurred while performing asynchronous work", e);
                this.addError(new ModDirectorError(Level.SEVERE, "An exception occurred while performing asynchronous work", e));
            }
        }
    }

    public void checkUrl(URL url) throws ModDirectorException {
        this.stopModReposts.check(url);
    }

    public ScheduledExecutorService getTaskExecutor() {
        return this.taskExecutor;
    }

    public ConcurrentLinkedDeque<ModDirectorError> getErrors() {
        return this.errors;
    }

    public InstallSelector getInstallSelector() {
        return this.installSelector;
    }

    public PlatformDelegate getPlatform() {
        return this.platform;
    }

    public LoggerDelegate getLogger() {
        return this.logger;
    }

    public LookAndFeel getPrevLookAndFeel() {
        return this.prevLookAndFeel;
    }

    public ConfigurationController getConfigurationController() {
        return this.configurationController;
    }

    public InstallController getInstallController() {
        return this.installController;
    }

    public StopModReposts getStopModReposts() {
        return this.stopModReposts;
    }

    public String getModpackRemoteVersion() {
        return this.modpackRemoteVersion;
    }
}

