/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.modpackdirector.i18n;

import com.juanmuscaria.autumn.messages.HierarchicalMessageSource;
import com.juanmuscaria.autumn.messages.NoSuchMessageException;
import com.juanmuscaria.autumn.messages.standard.ReloadableResourceBundleMessageSource;
import com.juanmuscaria.autumn.resources.DefaultResourceLoader;
import com.juanmuscaria.autumn.resources.FileSystemResourceLoader;
import com.juanmuscaria.modpackdirector.util.PlatformDelegate;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Locale;

public class Messages {
    private final HierarchicalMessageSource messages;
    private final PlatformDelegate platform;
    private Locale userLocale = Locale.getDefault();

    public Messages(PlatformDelegate platform, boolean loadUserMessages) {
        this.platform = platform;
        ReloadableResourceBundleMessageSource src = new ReloadableResourceBundleMessageSource();
        src.setBasename("classpath:com/juanmuscaria/modpackdirector/i18n/messages");
        src.setDefaultEncoding("UTF-8");
        src.setResourceLoader(new DefaultResourceLoader(this.getClass().getClassLoader()));
        if (loadUserMessages) {
            ReloadableResourceBundleMessageSource external = new ReloadableResourceBundleMessageSource();
            external.setResourceLoader(new FileSystemResourceLoader());
            external.setBasename(platform.configurationDirectory().toString() + "/messages");
            external.setDefaultEncoding("UTF-8");
            external.setParentMessageSource(src);
            src = external;
        }
        this.messages = src;
    }

    public String get(String key, Object ... params) {
        try {
            return this.messages.getMessage(key, params, this.userLocale);
        }
        catch (IllegalFormatException e) {
            this.platform.logger().warn("Unable to format key {0} due to bad expression", key, e);
        }
        catch (NoSuchMessageException noSuchMessageException) {
            // empty catch block
        }
        if (params.length > 0) {
            return key + ':' + Arrays.toString(params);
        }
        return key;
    }

    public void setUserLocale(Locale userLocale) {
        this.userLocale = userLocale;
    }

    public Locale getUserLocale() {
        return this.userLocale;
    }
}

