/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.modpackdirector.launchwrapper;

import com.juanmuscaria.modpackdirector.ModpackDirector;
import com.juanmuscaria.modpackdirector.launchwrapper.Log4jLogger;
import com.juanmuscaria.modpackdirector.launchwrapper.forge.ForgeLateLoader;
import com.juanmuscaria.modpackdirector.logging.JavaLogger;
import com.juanmuscaria.modpackdirector.logging.LoggerDelegate;
import com.juanmuscaria.modpackdirector.util.PlatformDelegate;
import com.juanmuscaria.modpackdirector.util.Side;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jan.moddirector.core.manage.ModDirectorError;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;

public class ModpackDirectorTweaker
implements ITweaker,
PlatformDelegate {
    private final LoggerDelegate logger = this.makeLogger();
    private final ModpackDirector director = new ModpackDirector(this);
    private List<String> args;
    private File gameDir;
    private File assetsDir;
    private String profile;
    private LaunchClassLoader classLoader;
    private Side side;

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        this.args = args;
        this.gameDir = gameDir;
        if (gameDir == null) {
            this.gameDir = new File(".").getAbsoluteFile();
            this.logger().debug("Fixing null game directory to {0}", this.gameDir.getPath());
        }
        this.assetsDir = assetsDir;
        this.profile = profile;
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        this.classLoader = classLoader;
        URL minecraftMainClass = classLoader.getResource("net/minecraft/client/main/Main.class");
        this.side = minecraftMainClass != null ? Side.CLIENT : Side.SERVER;
        this.logger.info("Detected side: {0}", new Object[]{this.side});
        try {
            if (!this.director.call().booleanValue()) {
                this.director.errorExit();
            }
        }
        catch (Exception e) {
            this.director.addError(new ModDirectorError(Level.SEVERE, "Activation error", e));
            this.director.errorExit();
        }
        if (!this.director.getInstalledMods().isEmpty()) {
            ForgeLateLoader loader = new ForgeLateLoader(this, this.director, classLoader);
            loader.execute();
        }
    }

    public String getLaunchTarget() {
        return "net.minecraft.client.main.Main";
    }

    public String[] getLaunchArguments() {
        return new String[0];
    }

    public void callInjectedTweaker(ITweaker tweaker) {
        tweaker.acceptOptions(this.args, this.gameDir, this.assetsDir, this.profile);
        tweaker.injectIntoClassLoader(this.classLoader);
    }

    @Override
    public String name() {
        return "Launchwrapper";
    }

    @Override
    public Path configurationDirectory() {
        File configDir = new File(this.gameDir, "config/mod-director");
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new UncheckedIOException(new IOException("Failed to create config directory " + configDir.getAbsolutePath()));
        }
        return configDir.toPath();
    }

    @Override
    public Path modFile(String modFileName) {
        return this.gameDir.toPath().resolve("mods").resolve(modFileName);
    }

    @Override
    public Path customFile(String modFileName, String modFolderName) {
        return this.gameDir.toPath().resolve(modFolderName).resolve(modFileName);
    }

    @Override
    public Path rootFile(String modFileName) {
        return this.gameDir.toPath().resolve(modFileName);
    }

    @Override
    public Path installationRoot() {
        return this.gameDir.toPath();
    }

    @Override
    public LoggerDelegate logger() {
        return this.logger;
    }

    @Override
    public Side side() {
        if (this.side == null) {
            throw new IllegalStateException("Too Early!");
        }
        return this.side;
    }

    @Override
    public boolean headless() {
        return GraphicsEnvironment.isHeadless();
    }

    private LoggerDelegate makeLogger() {
        try {
            return new Log4jLogger(LogManager.getLogger((String)"ModpackDirector"));
        }
        catch (Throwable ignored) {
            return new JavaLogger(Logger.getLogger("ModpackDirector"));
        }
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public String getProfile() {
        return this.profile;
    }
}

