/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.modpackdirector.launchwrapper.forge;

import com.juanmuscaria.modpackdirector.ModpackDirector;
import com.juanmuscaria.modpackdirector.launchwrapper.ModpackDirectorTweaker;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import net.jan.moddirector.core.manage.ModDirectorError;
import net.jan.moddirector.core.manage.install.InstalledMod;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class ForgeLateLoader {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private final ModpackDirectorTweaker directorTweaker;
    private final ModpackDirector director;
    private final LaunchClassLoader classLoader;
    private final List<String> loadedCoremods;
    private final List<ITweaker> modTweakers;
    private List<String> reflectiveIgnoredMods;
    private List<String> reflectiveReparsedCoremods;
    private MethodHandle handleCascadingTweakMethodHandle;
    private MethodHandle loadCoreModMethodHandle;
    private MethodHandle addUrlMethodHandle;
    private MethodHandle sortTweakListMethodHandle;
    private MethodHandle addJarMethodHandle;
    private boolean addJarRequiresAtList;

    public ForgeLateLoader(ModpackDirectorTweaker directorTweaker, ModpackDirector director, LaunchClassLoader classLoader) {
        this.directorTweaker = directorTweaker;
        this.director = director;
        this.classLoader = classLoader;
        this.loadedCoremods = new ArrayList<String>();
        this.modTweakers = new ArrayList<ITweaker>();
    }

    public void execute() {
        for (String commandlineCoreMod : System.getProperty("fml.coreMods.load", "").split(",")) {
            if (commandlineCoreMod.isEmpty()) continue;
            this.directorTweaker.logger().debug("Ignoring coremod {0} which has been loaded on the commandline", commandlineCoreMod);
            this.loadedCoremods.add(commandlineCoreMod);
        }
        if (!this.reflectiveSetup()) {
            return;
        }
        this.directorTweaker.logger().info("Trying to late load {0} mods", this.director.getInstalledMods().size());
        this.director.getInstalledMods().forEach(this::handle);
        boolean sortSucceeded = false;
        if (this.sortTweakListMethodHandle != null) {
            List realTweakers = (List)Launch.blackboard.get("Tweaks");
            Launch.blackboard.put("Tweaks", this.modTweakers);
            try {
                this.sortTweakListMethodHandle.invoke();
                sortSucceeded = true;
            }
            catch (Throwable t) {
                this.directorTweaker.logger().error("Error while invoking sortTweakList method", t);
            }
            Launch.blackboard.put("Tweaks", realTweakers);
        }
        if (!sortSucceeded) {
            this.directorTweaker.logger().warn("Mod tweak list could not be sorted, hoping the best...", new Object[0]);
        }
        Launch.blackboard.put("LateTweakers", this.modTweakers);
        List tweakClasses = (List)Launch.blackboard.get("TweakClasses");
        boolean deobfFound = false;
        for (int i = 0; i < tweakClasses.size(); ++i) {
            if (!((String)tweakClasses.get(i)).endsWith(".FMLDeobfTweaker")) continue;
            this.directorTweaker.logger().debug("Found deobf tweaker at index {0}, adding after deobf tweaker after it", i);
            tweakClasses.add(i + 1, "net.jan.moddirector.launchwrapper.forge.AfterDeobfTweaker");
            deobfFound = true;
        }
        if (!deobfFound) {
            this.directorTweaker.logger().warn("Failed to find deobf tweaker, injecting after deobf tweaker at first place", new Object[0]);
            tweakClasses.add(0, "net.jan.moddirector.launchwrapper.forge.AfterDeobfTweaker");
        }
    }

    private boolean reflectiveSetup() {
        Class<?> coreModManagerClass;
        try {
            coreModManagerClass = Class.forName("net.minecraftforge.fml.relauncher.CoreModManager", false, this.getClass().getClassLoader());
            this.directorTweaker.logger().info("Found new CoreModManager at {0}!", "net.minecraftforge.fml.relauncher.CoreModManager");
        }
        catch (ClassNotFoundException e) {
            this.directorTweaker.logger().debug("Unable to find new CoreModManager class, trying old...", new Object[0]);
            try {
                coreModManagerClass = Class.forName("cpw.mods.fml.relauncher.CoreModManager");
                this.directorTweaker.logger().info("Found old CoreModManager at {0}!", "net.minecraftforge.fml.relauncher.CoreModManager");
            }
            catch (ClassNotFoundException ex) {
                this.directorTweaker.logger().info("Unable to find old CoreModManager class, Forge support disabled!", new Object[0]);
                return false;
            }
        }
        try {
            Method sortTweakListMethod = this.getMethod(new String[]{"sortTweakList"}, coreModManagerClass, new Class[0]);
            this.sortTweakListMethodHandle = LOOKUP.unreflect(sortTweakListMethod);
        }
        catch (ReflectiveOperationException e) {
            this.directorTweaker.logger().warn("Failed to get method for sorting tweaks, loading might fail!", e);
        }
        try {
            Method getIgnoredModsMethod = this.getMethod(new String[]{"getIgnoredMods", "getLoadedCoremods"}, coreModManagerClass, new Class[0]);
            this.reflectiveIgnoredMods = (List)getIgnoredModsMethod.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            this.directorTweaker.logger().warn("Failed to get method for retrieving ignored mods, loading might fail!", e);
            this.reflectiveIgnoredMods = new ArrayList<String>();
        }
        try {
            Method getReparseableCoremodsMethod = this.getMethod(new String[]{"getReparseableCoremods"}, coreModManagerClass, new Class[0]);
            this.reflectiveReparsedCoremods = (List)getReparseableCoremodsMethod.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            this.directorTweaker.logger().warn("Failed to get method for retrieving reparseable coremods, loading might fail!", e);
            this.reflectiveReparsedCoremods = new ArrayList<String>();
        }
        try {
            Method handleCascadingTweakMethod = this.getMethod(new String[]{"handleCascadingTweak"}, coreModManagerClass, File.class, JarFile.class, String.class, LaunchClassLoader.class, Integer.class);
            this.handleCascadingTweakMethodHandle = LOOKUP.unreflect(handleCascadingTweakMethod);
        }
        catch (ReflectiveOperationException e) {
            this.directorTweaker.logger().warn("Failed to get method for adding tweakers via FML, loading might fail, but trying to fall back to Launchwrapper directly!", e);
        }
        try {
            Method loadCoreModMethod = this.getMethod(new String[]{"loadCoreMod"}, coreModManagerClass, LaunchClassLoader.class, String.class, File.class);
            this.loadCoreModMethodHandle = LOOKUP.unreflect(loadCoreModMethod);
        }
        catch (ReflectiveOperationException e) {
            this.directorTweaker.logger().warn("Failed to get method for loading core mods via FML, loading might fail!", e);
        }
        Class<?> modAccessTransformerClass = null;
        try {
            modAccessTransformerClass = Class.forName("net.minecraftforge.fml.common.asm.transformers.ModAccessTransformer", false, this.getClass().getClassLoader());
            this.directorTweaker.logger().info("Found new ModAccessTransformer at {0}!", modAccessTransformerClass.getName());
        }
        catch (ClassNotFoundException e) {
            this.directorTweaker.logger().debug("Unable to find new ModAccessTransformer class, trying old...", new Object[0]);
            try {
                modAccessTransformerClass = Class.forName("cpw.mods.fml.common.asm.transformers.ModAccessTransformer", false, this.getClass().getClassLoader());
                this.directorTweaker.logger().info("Found old ModAccessTransformer at {0}!", modAccessTransformerClass.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.directorTweaker.logger().warn("Failed to find ModAccessTransformer class even after trying legacy name. Access transformers for downloaded mods disabled, loading might fail!", e);
            }
        }
        if (modAccessTransformerClass != null) {
            try {
                Method addJarMethod = this.getMethod(new String[]{"addJar"}, modAccessTransformerClass, JarFile.class);
                this.addJarMethodHandle = LOOKUP.unreflect(addJarMethod);
                this.addJarRequiresAtList = false;
            }
            catch (NoSuchMethodException e) {
                ReflectiveOperationException secondException = null;
                try {
                    Method addJarMethod = this.getMethod(new String[]{"addJar"}, modAccessTransformerClass, JarFile.class, String.class);
                    this.addJarMethodHandle = LOOKUP.unreflect(addJarMethod);
                    this.addJarRequiresAtList = true;
                }
                catch (IllegalAccessException | NoSuchMethodException second) {
                    secondException = second;
                }
                if (this.addJarMethodHandle == null) {
                    this.directorTweaker.logger().warn("Failed to find method for injecting access transformers, loading might fail if they are required!", new Object[0]);
                    this.directorTweaker.logger().warn("\tFailure 1:", e);
                    if (secondException != null) {
                        this.directorTweaker.logger().warn("\tFailure 2:", secondException);
                    }
                }
            }
            catch (IllegalAccessException e) {
                this.directorTweaker.logger().warn("Failed to access method for injecting access transformers, loading might fail if they are required!", e);
            }
        }
        try {
            Method addUrlMethod = this.getMethod(new String[]{"addURL"}, URLClassLoader.class, URL.class);
            this.addUrlMethodHandle = LOOKUP.unreflect(addUrlMethod);
        }
        catch (ReflectiveOperationException e) {
            this.directorTweaker.logger().warn("Failed to get addUrl method for URLClassLoader (wtf?), loading might fail!", new Object[0]);
        }
        return true;
    }

    private Method getMethod(String[] possibleNames, Class<?> targetClass, Class<?> ... args) throws NoSuchMethodException {
        Method method = null;
        for (String possibleName : possibleNames) {
            try {
                method = targetClass.getDeclaredMethod(possibleName, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (method == null) {
            throw new NoSuchMethodException("Failed to find method using names [" + String.join((CharSequence)", ", possibleNames) + "] on class " + targetClass.getName());
        }
        method.setAccessible(true);
        return method;
    }

    private void handle(InstalledMod mod) {
        block17: {
            Path injectedFile = mod.getFile();
            if (!mod.shouldInject()) {
                return;
            }
            this.reflectiveIgnoredMods.remove(injectedFile.toFile().getName());
            try (JarFile jar = new JarFile(injectedFile.toFile());){
                Manifest manifest = jar.getManifest();
                if (manifest != null) {
                    Attributes attributes = manifest.getMainAttributes();
                    this.injectAccessTransformers(jar, manifest);
                    String tweakClass = attributes.getValue("TweakClass");
                    if (tweakClass != null) {
                        int tweakOrder = 0;
                        String tweakOrderString = attributes.getValue("TweakOrder");
                        if (tweakOrderString != null) {
                            try {
                                tweakOrder = Integer.parseInt(tweakOrderString);
                            }
                            catch (NumberFormatException e) {
                                this.directorTweaker.logger().warn("Failed to parse tweak order for {0}", injectedFile.toString(), e);
                            }
                        }
                        this.injectTweaker(injectedFile, jar, tweakClass, tweakOrder, mod.getOptionBoolean("launchwrapperTweakerForceNext", false));
                        return;
                    }
                    String corePlugin = attributes.getValue("FMLCorePlugin");
                    if (corePlugin != null) {
                        this.injectCorePlugin(injectedFile, corePlugin);
                        if (attributes.getValue("FMLCorePluginContainsFMLMod") != null) {
                            this.addReparseableJar(injectedFile);
                        } else {
                            this.addLoadedCoreMod(injectedFile);
                        }
                    }
                    break block17;
                }
                this.directorTweaker.logger().warn("Downloaded file {0} has no manifest!", injectedFile.toString());
            }
            catch (IOException e) {
                this.directorTweaker.logger().warn("Failed to open indexed file {0} as jar, ignoring", injectedFile.toString(), e);
            }
        }
    }

    private void addReparseableJar(Path injectedFile) {
        String fileName = injectedFile.toFile().getName();
        if (!this.reflectiveReparsedCoremods.contains(fileName)) {
            this.reflectiveReparsedCoremods.add(fileName);
            this.directorTweaker.logger().debug("Marked {0} as reparseable coremod", injectedFile.toString());
        }
    }

    private void addLoadedCoreMod(Path injectedFile) {
        String filename = injectedFile.toFile().getName();
        if (!this.reflectiveIgnoredMods.contains(filename)) {
            this.reflectiveIgnoredMods.add(filename);
            this.directorTweaker.logger().debug("Marked {0} as loaded coremod", injectedFile.toString());
        }
    }

    private void injectTweaker(Path injectedFile, JarFile jar, String tweakerClass, Integer sortingOrder, boolean forceNext) {
        URL fileUrl = null;
        try {
            fileUrl = injectedFile.toUri().toURL();
        }
        catch (MalformedURLException e) {
            this.directorTweaker.logger().error("Failed to convert path to url, loading might fail!", e);
        }
        if (fileUrl != null) {
            try {
                this.addUrlMethodHandle.invoke(this.classLoader.getClass().getClassLoader(), fileUrl);
                this.classLoader.addURL(fileUrl);
            }
            catch (Throwable e) {
                this.directorTweaker.logger().error("Failed to inject tweaker url into ClassLoader, loading might fail!", e);
            }
        }
        if (forceNext) {
            this.directorTweaker.logger().info("Late injecting tweaker {0} from {1}, forcing it to be called next!", tweakerClass, injectedFile.toString());
            try {
                ITweaker tweaker = (ITweaker)Class.forName(tweakerClass, true, (ClassLoader)this.classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.classLoader.addClassLoaderExclusion(tweakerClass.substring(0, tweakerClass.lastIndexOf(46)));
                this.directorTweaker.callInjectedTweaker(tweaker);
            }
            catch (ReflectiveOperationException e) {
                this.directorTweaker.logger().error("Failed to manually load tweaker so it can be injected next, falling back to Forge!", e);
                forceNext = false;
            }
        }
        if (forceNext) {
            return;
        }
        boolean injectionSucceeded = false;
        if (this.handleCascadingTweakMethodHandle != null) {
            this.directorTweaker.logger().info("Late injecting tweaker {0} from {1} using FML", tweakerClass, injectedFile.toString());
            try {
                this.handleCascadingTweakMethodHandle.invoke(injectedFile.toFile(), jar, tweakerClass, this.classLoader, sortingOrder);
                injectionSucceeded = true;
            }
            catch (Throwable e) {
                this.directorTweaker.logger().error("Error while injecting tweaker via FML, falling back to Launchwrapper's own mechanism!", e);
            }
        }
        if (!injectionSucceeded) {
            this.directorTweaker.logger().info("Late injecting tweaker {0} from {1} using Launchwrapper", tweakerClass, injectedFile.toString());
            ((List)Launch.blackboard.get("TweakClasses")).add(tweakerClass);
        }
    }

    private void injectCorePlugin(Path injectedFile, String coreModClass) {
        if (this.loadedCoremods.contains(coreModClass)) {
            this.directorTweaker.logger().debug("Not injecting core plugin {0} from {1} because it has already been!", coreModClass, injectedFile.toString());
            return;
        }
        this.directorTweaker.logger().info("Now injecting core plugin {0} from {1}", coreModClass, injectedFile.toString());
        try {
            this.classLoader.addURL(injectedFile.toUri().toURL());
            Object ret = this.loadCoreModMethodHandle.invoke(this.classLoader, coreModClass, injectedFile.toFile());
            if (ret instanceof ITweaker) {
                this.modTweakers.add((ITweaker)ret);
            }
        }
        catch (Throwable e) {
            this.directorTweaker.logger().error("Failed to inject core plugin!", e);
            this.director.addError(new ModDirectorError(Level.SEVERE, "Failed to inject core plugin!", e));
        }
    }

    private void injectAccessTransformers(JarFile jar, Manifest manifest) {
        if (this.addJarMethodHandle != null) {
            try {
                this.directorTweaker.logger().debug("Added {-} to possible access transformers", jar.getName());
                if (this.addJarRequiresAtList) {
                    String ats = manifest.getMainAttributes().getValue("FMLAT");
                    if (ats != null && !ats.isEmpty()) {
                        this.addJarMethodHandle.invoke(jar, ats);
                    }
                } else {
                    this.addJarMethodHandle.invoke(jar);
                }
            }
            catch (Throwable t) {
                this.directorTweaker.logger().warn("Failed to add jar to access transformers", t);
            }
        }
    }
}

