/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.modpackdirector.modlauncher;

import com.juanmuscaria.modpackdirector.ModpackDirector;
import com.juanmuscaria.modpackdirector.logging.LoggerDelegate;
import com.juanmuscaria.modpackdirector.modlauncher.Log4jLogger;
import com.juanmuscaria.modpackdirector.util.PlatformDelegate;
import com.juanmuscaria.modpackdirector.util.Side;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import net.jan.moddirector.core.manage.ModDirectorError;
import org.apache.logging.log4j.LogManager;

public class ModpackDirectorService
implements ITransformationService,
PlatformDelegate {
    private final LoggerDelegate logger = new Log4jLogger(LogManager.getLogger((String)"ModpackDirector"));
    private Side side = Side.UNKNOWN;
    private Path gameDir;

    public void initialize(IEnvironment env) {
        this.side = this.figureOutSide(env);
        this.gameDir = (Path)env.getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).get();
        ModpackDirector director = new ModpackDirector(this);
        this.logger.info("Detected side: {0}", new Object[]{this.side});
        try {
            if (!director.call().booleanValue()) {
                director.errorExit();
            }
        }
        catch (Exception e) {
            director.addError(new ModDirectorError(Level.SEVERE, "Activation error", e));
            director.errorExit();
        }
    }

    public void beginScanning(IEnvironment iEnvironment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
    }

    @Override
    public String name() {
        return "ModpackDirectorModlauncher";
    }

    @Override
    public Path configurationDirectory() {
        File configDir = new File(this.gameDir.toFile(), "config/mod-director");
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new UncheckedIOException(new IOException("Failed to create config directory " + configDir.getAbsolutePath()));
        }
        return configDir.toPath();
    }

    @Override
    public Path modFile(String modFileName) {
        return this.gameDir.resolve("mods").resolve(modFileName);
    }

    @Override
    public Path customFile(String modFileName, String modFolderName) {
        return this.gameDir.resolve(modFolderName).resolve(modFileName);
    }

    @Override
    public Path rootFile(String modFileName) {
        return this.gameDir.resolve(modFileName);
    }

    @Override
    public Path installationRoot() {
        return this.gameDir;
    }

    @Override
    public LoggerDelegate logger() {
        return this.logger;
    }

    @Override
    public Side side() {
        return this.side;
    }

    @Override
    public boolean headless() {
        return GraphicsEnvironment.isHeadless();
    }

    public List<ITransformer> transformers() {
        return new ArrayList<ITransformer>();
    }

    private Side figureOutSide(IEnvironment environment) {
        String launchTarget = environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.LAUNCHTARGET.get()).orElse("missing").toLowerCase(Locale.ROOT);
        if (launchTarget.contains("server")) {
            return Side.SERVER;
        }
        if (launchTarget.contains("client")) {
            return Side.CLIENT;
        }
        Optional launchHandler = environment.findLaunchHandler(launchTarget);
        if (launchHandler.isPresent()) {
            ILaunchHandlerService service = (ILaunchHandlerService)launchHandler.get();
            try {
                Method mdGetDist = service.getClass().getDeclaredMethod("getDist", new Class[0]);
                String strDist = mdGetDist.invoke((Object)service, new Object[0]).toString().toLowerCase(Locale.ROOT);
                if (strDist.contains("server")) {
                    return Side.SERVER;
                }
                if (strDist.contains("client")) {
                    return Side.CLIENT;
                }
            }
            catch (Exception e) {
                this.logger.warn("Unable to get side", e);
                return Side.UNKNOWN;
            }
        }
        this.logger.warn("Unable to get side", new Object[0]);
        return Side.UNKNOWN;
    }
}

