/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.modpackdirector.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.juanmuscaria.modpackdirector.i18n.Messages;
import com.juanmuscaria.modpackdirector.logging.LoggerDelegate;
import com.juanmuscaria.modpackdirector.ui.page.ConsentPage;
import com.juanmuscaria.modpackdirector.ui.page.MessagePage;
import com.juanmuscaria.modpackdirector.ui.page.ModSelectionPage;
import com.juanmuscaria.modpackdirector.ui.page.ProgressPage;
import com.juanmuscaria.modpackdirector.ui.theme.UITheme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.jan.moddirector.core.manage.install.InstallableMod;
import net.jan.moddirector.core.manage.select.InstallSelector;

public class DirectorMainGUI
extends JFrame {
    private final Messages messages;
    private final LoggerDelegate logger;
    private JPanel content;
    private JLabel modpackName;
    private JLabel modpackIcon;
    private JPanel page;
    private JPanel root;
    private Component currentPage;

    public DirectorMainGUI(Messages messages, LoggerDelegate logger) {
        this.$$$setupUI$$$();
        this.messages = messages;
        this.logger = logger;
        this.add(this.root);
        this.modpackName.setFont(new Font(this.modpackName.getFont().getName(), 1, 20));
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
    }

    public ProgressPage progressPage(String titleKey, Object ... params) {
        return this.setCurrentPage(new ProgressPage(this.messages.get(titleKey, params)));
    }

    public ConsentPage consent(List<InstallableMod> mods) {
        return this.setCurrentPage(new ConsentPage(mods, this.messages));
    }

    public ModSelectionPage selectionPage(InstallSelector selector) {
        return this.setCurrentPage(new ModSelectionPage(selector, this.messages));
    }

    public MessagePage messagePage(String titleKey, String messageKey, String buttonKey) {
        return this.setCurrentPage(new MessagePage(this.messages, titleKey, messageKey, buttonKey));
    }

    private <T extends Component> T setCurrentPage(T newPage) {
        if (this.currentPage != null) {
            this.page.remove(this.currentPage);
        }
        this.currentPage = newPage;
        this.page.add(this.currentPage);
        this.page.revalidate();
        this.page.repaint();
        return newPage;
    }

    private void $$$setupUI$$$() {
        this.root = new JPanel();
        this.root.setLayout(new GridLayoutManager(1, 1, new Insets(5, 10, 10, 10), -1, -1));
        this.content = new JPanel();
        this.content.setLayout(new BorderLayout(0, 0));
        this.root.add((Component)this.content, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(650, 400), null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 5, 0), -1, -1));
        this.content.add((Component)panel1, "North");
        this.modpackName = new JLabel();
        this.modpackName.setEnabled(true);
        this.modpackName.setHorizontalAlignment(0);
        this.modpackName.setHorizontalTextPosition(0);
        this.modpackName.setOpaque(false);
        this.modpackName.setText("Modpack Director");
        panel1.add((Component)this.modpackName, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.modpackIcon = new JLabel();
        this.modpackIcon.setText("");
        panel1.add((Component)this.modpackIcon, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, new Dimension(64, 64), new Dimension(64, 64), new Dimension(64, 64), 0, false));
        this.page = new JPanel();
        this.page.setLayout(new BorderLayout(0, 0));
        this.content.add((Component)this.page, "Center");
    }

    public JComponent $$$getRootComponent$$$() {
        return this.root;
    }

    public void setModpackIcon(Image icon, Dimension dimension) {
        if (icon == null) {
            Image img = UITheme.getDefaultIcon(this.logger);
            this.setIconImage(img);
            this.modpackIcon.setIcon(new ImageIcon(img.getScaledInstance(64, 64, 4)));
        } else {
            this.modpackIcon.setMinimumSize(dimension);
            this.modpackIcon.setMaximumSize(dimension);
            this.modpackIcon.setPreferredSize(dimension);
            this.setIconImage(icon);
            this.modpackIcon.setIcon(new ImageIcon(icon.getScaledInstance(dimension.width, dimension.height, 4)));
        }
    }

    public Messages getMessages() {
        return this.messages;
    }

    public LoggerDelegate getLogger() {
        return this.logger;
    }

    public JPanel getContent() {
        return this.content;
    }

    public JLabel getModpackName() {
        return this.modpackName;
    }

    public JLabel getModpackIcon() {
        return this.modpackIcon;
    }

    public JPanel getPage() {
        return this.page;
    }

    public JPanel getRoot() {
        return this.root;
    }

    public Component getCurrentPage() {
        return this.currentPage;
    }
}

