/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.modpackdirector.ui.components;

import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class ScrollablePane
extends JPanel
implements Scrollable {
    private boolean scrollableTracksViewportWidth;
    private boolean scrollableTracksViewportHeight;

    public ScrollablePane(LayoutManager layout, boolean isDoubleBuffered, boolean scrollableTracksViewportWidth, boolean scrollableTracksViewportHeight) {
        this(layout, isDoubleBuffered);
        this.scrollableTracksViewportWidth = scrollableTracksViewportWidth;
        this.scrollableTracksViewportHeight = scrollableTracksViewportHeight;
    }

    public ScrollablePane(LayoutManager layout, boolean scrollableTracksViewportWidth, boolean scrollableTracksViewportHeight) {
        this(layout);
        this.scrollableTracksViewportWidth = scrollableTracksViewportWidth;
        this.scrollableTracksViewportHeight = scrollableTracksViewportHeight;
    }

    public ScrollablePane(boolean isDoubleBuffered, boolean scrollableTracksViewportWidth, boolean scrollableTracksViewportHeight) {
        this(isDoubleBuffered);
        this.scrollableTracksViewportWidth = scrollableTracksViewportWidth;
        this.scrollableTracksViewportHeight = scrollableTracksViewportHeight;
    }

    public ScrollablePane(boolean scrollableTracksViewportWidth, boolean scrollableTracksViewportHeight) {
        this();
        this.scrollableTracksViewportWidth = scrollableTracksViewportWidth;
        this.scrollableTracksViewportHeight = scrollableTracksViewportHeight;
    }

    public ScrollablePane(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public ScrollablePane(LayoutManager layout) {
        super(layout);
    }

    public ScrollablePane(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public ScrollablePane() {
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getScrollableBlockIncrement(visibleRect, orientation, direction) / 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height;
        }
        return visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.scrollableTracksViewportWidth || this.getParent().getWidth() + 1 > this.getSize().width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.scrollableTracksViewportHeight || this.getParent().getHeight() + 1 > this.getSize().height;
    }

    public void setScrollableTracksViewportWidth(boolean scrollableTracksViewportWidth) {
        this.scrollableTracksViewportWidth = scrollableTracksViewportWidth;
    }

    public void setScrollableTracksViewportHeight(boolean scrollableTracksViewportHeight) {
        this.scrollableTracksViewportHeight = scrollableTracksViewportHeight;
    }
}

