/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.modpackdirector.ui.page;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.juanmuscaria.modpackdirector.UnsafeExit;
import com.juanmuscaria.modpackdirector.i18n.Messages;
import com.juanmuscaria.modpackdirector.ui.components.ScrollablePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.jan.moddirector.core.manage.install.InstallableMod;

public class ConsentPage
extends JPanel {
    private final Messages messages;
    private final CountDownLatch nextLatch = new CountDownLatch(1);
    private JPanel root;
    private JLabel pageTitle;
    private JPanel content;
    private JButton nextButton;
    private JButton cancelAndExitButton;
    private JLabel info;

    public ConsentPage(List<InstallableMod> toInstall, Messages messages) {
        this.messages = messages;
        this.$$$setupUI$$$();
        this.pageTitle.setText(messages.get("modpack_director.consent.title", new Object[0]));
        this.info.setText(this.asHtml(messages.get("modpack_director.consent.info", new Object[0])));
        this.setLayout(new BorderLayout());
        this.add((Component)this.root, "Center");
        this.nextButton.addActionListener(e -> this.nextLatch.countDown());
        this.nextButton.setText(messages.get("modpack_director.consent.accept_button_label", new Object[0]));
        this.cancelAndExitButton.addActionListener(e -> UnsafeExit.exit(0));
        this.cancelAndExitButton.setText(messages.get("modpack_director.consent.cancel_button_label", new Object[0]));
        toInstall.forEach(this::createEntry);
    }

    private void createUIComponents() {
        this.content = new ScrollablePane(true, false);
        this.content.setLayout(new BoxLayout(this.content, 1));
    }

    private void createEntry(InstallableMod mod) {
        JPanel modPane = new JPanel();
        modPane.setLayout(new BoxLayout(modPane, 1));
        modPane.add(new JLabel(this.asHtml(mod.getRemoteInformation().displayName())));
        modPane.add(new JLabel(this.asHtml(mod.getRemoteMod().remoteUrl())));
        modPane.add(new JLabel(this.asHtml(mod.getTargetFile().toString())));
        String sourceName = this.messages.get("modpack_director.consent.source", mod.getRemoteMod().remoteType());
        modPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), sourceName, 2, 2));
        this.content.add(modPane);
    }

    private String asHtml(String content) {
        return "<html>" + content + "</html>";
    }

    public void waitForNext() throws InterruptedException {
        this.nextLatch.await();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.root = new JPanel();
        this.root.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.pageTitle = new JLabel();
        this.pageTitle.setHorizontalAlignment(0);
        this.pageTitle.setHorizontalTextPosition(0);
        this.pageTitle.setText("PAGE TITLE");
        this.pageTitle.setVerticalAlignment(0);
        this.pageTitle.setVerticalTextPosition(0);
        this.root.add((Component)this.pageTitle, new GridConstraints(0, 0, 1, 1, 0, 0, 1, 3, null, null, null, 0, false));
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setHorizontalScrollBarPolicy(31);
        scrollPane1.setVerticalScrollBarPolicy(20);
        this.root.add((Component)scrollPane1, new GridConstraints(2, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        scrollPane1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null, 0, 0, null, null));
        scrollPane1.setViewportView(this.content);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        this.root.add((Component)panel1, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.nextButton = new JButton();
        this.nextButton.setText("Accept and Install");
        panel1.add((Component)this.nextButton, "East");
        this.cancelAndExitButton = new JButton();
        this.cancelAndExitButton.setText("Cancel and Exit");
        panel1.add((Component)this.cancelAndExitButton, "West");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout(0, 0));
        this.root.add((Component)panel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.info = new JLabel();
        this.info.setHorizontalAlignment(0);
        this.info.setHorizontalTextPosition(2);
        this.info.setText("INFO LABEL");
        panel2.add((Component)this.info, "Center");
    }

    public JComponent $$$getRootComponent$$$() {
        return this.root;
    }
}

