/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.modpackdirector.ui.page;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.juanmuscaria.modpackdirector.i18n.Messages;
import com.juanmuscaria.modpackdirector.ui.components.ScrollablePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import net.jan.moddirector.core.manage.select.InstallSelector;
import net.jan.moddirector.core.manage.select.SelectableInstallOption;

public class ModSelectionPage
extends JPanel {
    private final Messages messages;
    private final CountDownLatch nextLatch = new CountDownLatch(1);
    private JPanel root;
    private JLabel pageTitle;
    private JPanel content;
    private JButton nextButton;

    public ModSelectionPage(InstallSelector selector, Messages messages) {
        this.messages = messages;
        this.$$$setupUI$$$();
        this.pageTitle.setText(messages.get("modpack_director.selection_page.title", new Object[0]));
        this.setLayout(new BorderLayout());
        this.add((Component)this.root, "Center");
        selector.getSingleOptions().forEach(this::setupSingleOption);
        selector.getGroupOptions().forEach(this::setupGroupOption);
        this.nextButton.addActionListener(e -> this.nextLatch.countDown());
        this.nextButton.setText(messages.get("modpack_director.selection_page.next_button_label", new Object[0]));
    }

    private void createUIComponents() {
        this.content = new ScrollablePane(true, false);
        this.content.setLayout(new BoxLayout(this.content, 1));
    }

    private void setupSingleOption(SelectableInstallOption option) {
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new BoxLayout(optionPanel, 1));
        JCheckBox installCheckBox = new JCheckBox(this.messages.get("modpack_director.selection_page.install", new Object[0]));
        installCheckBox.setSelected(option.isSelected());
        installCheckBox.addItemListener(e -> option.setSelected(installCheckBox.isSelected()));
        optionPanel.add(installCheckBox);
        if (option.getDescription() != null) {
            optionPanel.add(new JLabel(this.asHtml(option.getDescription())));
        }
        optionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), option.getName(), 2, 2));
        this.content.add(optionPanel);
    }

    private void setupGroupOption(String groupName, List<SelectableInstallOption> options) {
        JPanel groupPanel = new JPanel();
        groupPanel.setLayout(new BoxLayout(groupPanel, 1));
        ButtonGroup group = new ButtonGroup();
        for (SelectableInstallOption option : options) {
            JPanel optionPanel = new JPanel();
            optionPanel.setLayout(new BoxLayout(optionPanel, 1));
            JRadioButton installRadioButton = new JRadioButton(option.getName());
            installRadioButton.setSelected(option.isSelected());
            installRadioButton.addItemListener(e -> option.setSelected(installRadioButton.isSelected()));
            group.add(installRadioButton);
            optionPanel.add(installRadioButton);
            if (option.getDescription() != null) {
                optionPanel.add(new JLabel(this.asHtml(option.getDescription())));
            }
            groupPanel.add(optionPanel);
        }
        groupPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), groupName, 2, 2));
        this.content.add(groupPanel);
    }

    private String asHtml(String content) {
        return "<html>" + content + "</html>";
    }

    public void waitForNext() throws InterruptedException {
        this.nextLatch.await();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.root = new JPanel();
        this.root.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.pageTitle = new JLabel();
        this.pageTitle.setHorizontalAlignment(0);
        this.pageTitle.setHorizontalTextPosition(0);
        this.pageTitle.setText("");
        this.pageTitle.setVerticalAlignment(0);
        this.pageTitle.setVerticalTextPosition(0);
        this.root.add((Component)this.pageTitle, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setHorizontalScrollBarPolicy(31);
        scrollPane1.setVerticalScrollBarPolicy(20);
        this.root.add((Component)scrollPane1, new GridConstraints(1, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        scrollPane1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null, 0, 0, null, null));
        scrollPane1.setViewportView(this.content);
        this.nextButton = new JButton();
        this.nextButton.setText("Next");
        this.root.add((Component)this.nextButton, new GridConstraints(2, 0, 1, 1, 4, 0, 3, 0, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.root;
    }
}

