/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.modpackdirector.ui.page;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.juanmuscaria.modpackdirector.ui.components.ScrollablePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.jan.moddirector.core.manage.ProgressCallback;

public class ProgressPage
extends JPanel {
    private JLabel pageTitle;
    private JPanel root;
    private JPanel progressArea;

    public ProgressPage(String title) {
        this.$$$setupUI$$$();
        this.setLayout(new BorderLayout());
        this.add((Component)this.root, "Center");
        this.pageTitle.setText(title);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.root = new JPanel();
        this.root.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, true, false));
        this.pageTitle = new JLabel();
        this.pageTitle.setHorizontalAlignment(0);
        this.pageTitle.setHorizontalTextPosition(0);
        this.pageTitle.setText("TITLE");
        this.pageTitle.setVerticalAlignment(0);
        this.pageTitle.setVerticalTextPosition(0);
        this.root.add((Component)this.pageTitle, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setHorizontalScrollBarPolicy(31);
        scrollPane1.setVerticalScrollBarPolicy(20);
        this.root.add((Component)scrollPane1, new GridConstraints(1, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        scrollPane1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null, 0, 0, null, null));
        scrollPane1.setViewportView(this.progressArea);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.root;
    }

    private void createUIComponents() {
        this.progressArea = new ScrollablePane(true, false);
        this.progressArea.setLayout(new BoxLayout(this.progressArea, 1));
    }

    public ProgressCallback createProgressCallback(String title, String initialMessage) {
        return new VisualProgressCallback(title, initialMessage);
    }

    private class VisualProgressCallback
    implements ProgressCallback {
        boolean done;
        private JProgressBar progressBar;
        private int currentStep;

        private VisualProgressCallback(String title, String initialMessage) {
            SwingUtilities.invokeLater(() -> {
                this.progressBar = new JProgressBar();
                this.progressBar.setString(initialMessage);
                this.progressBar.setStringPainted(true);
                this.progressBar.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title, 2, 2));
                ProgressPage.this.progressArea.add(this.progressBar);
                ProgressPage.this.progressArea.revalidate();
                ProgressPage.this.progressArea.repaint();
            });
            this.done = false;
            this.setSteps(1);
        }

        @Override
        public void setSteps(int steps) {
            this.currentStep = 0;
            SwingUtilities.invokeLater(() -> {
                this.progressBar.setMinimum(0);
                this.progressBar.setMaximum(steps * 100);
            });
        }

        @Override
        public void reportProgress(long current, long max) {
            int steppedPercent = (int)(current * 100L / max) + this.currentStep * 100;
            SwingUtilities.invokeLater(() -> this.progressBar.setValue(steppedPercent));
        }

        @Override
        public void message(String message) {
            SwingUtilities.invokeLater(() -> this.progressBar.setString(message));
        }

        @Override
        public void step() {
            ++this.currentStep;
            this.reportProgress(0L, 1L);
        }

        @Override
        public void done() {
            if (this.done) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                ProgressPage.this.progressArea.remove(this.progressBar);
                ProgressPage.this.progressArea.revalidate();
                ProgressPage.this.progressArea.repaint();
            });
            this.done = true;
        }

        @Override
        public void title(String newTitle) {
            SwingUtilities.invokeLater(() -> this.progressBar.setBorder(new TitledBorder(newTitle)));
        }

        @Override
        public void indeterminate(boolean isIndeterminate) {
            SwingUtilities.invokeLater(() -> this.progressBar.setIndeterminate(isIndeterminate));
        }
    }
}

