/*
 * Decompiled with CFR 0.152.
 */
package com.juanmuscaria.modpackdirector.ui.theme;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import com.juanmuscaria.modpackdirector.logging.LoggerDelegate;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Locale;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class UITheme {
    public static FlatLaf forName(String themeName) {
        FlatLaf flatLaf;
        switch (themeName.toLowerCase(Locale.ROOT)) {
            default: {
                flatLaf = new FlatLightLaf();
                break;
            }
            case "material-dark": 
            case "dark": {
                flatLaf = new FlatDarkLaf();
                break;
            }
            case "intellij-light": 
            case "intellij": {
                flatLaf = new FlatIntelliJLaf();
                break;
            }
            case "intellij-dark": 
            case "dracula": {
                flatLaf = new FlatDarculaLaf();
                break;
            }
            case "mac-light": {
                flatLaf = new FlatMacLightLaf();
                break;
            }
            case "mac-dark": {
                flatLaf = new FlatMacDarkLaf();
            }
        }
        return flatLaf;
    }

    public static void apply(String themeName, LoggerDelegate logger) {
        try {
            UIManager.put("ClassLoader", FlatLaf.class.getClassLoader());
            FlatLightLaf.setup();
            UIManager.setLookAndFeel(UITheme.forName(themeName));
        }
        catch (Throwable e) {
            logger.warn("Unable to set UI look and feel", e);
        }
    }

    public static Image getDefaultIcon(LoggerDelegate logger) {
        try {
            FlatLaf materialLookAndFeel;
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            if (lookAndFeel instanceof FlatLaf && !(materialLookAndFeel = (FlatLaf)lookAndFeel).isDark()) {
                return ImageIO.read(Objects.requireNonNull(UITheme.class.getResourceAsStream("/modpackdirector/ModpackDirectorAlt.png")));
            }
            return ImageIO.read(Objects.requireNonNull(UITheme.class.getResourceAsStream("/modpackdirector/ModpackDirector.png")));
        }
        catch (Exception e) {
            logger.warn("Unable to load built-in app icon", e);
            return new BufferedImage(64, 64, 5);
        }
    }
}

