/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.configuration;

import com.juanmuscaria.modpackdirector.ModpackDirector;
import com.juanmuscaria.modpackdirector.shadow.jackson.core.JsonParseException;
import com.juanmuscaria.modpackdirector.shadow.jackson.databind.JsonNode;
import com.juanmuscaria.modpackdirector.shadow.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.jan.moddirector.core.configuration.ModDirectorRemoteMod;
import net.jan.moddirector.core.configuration.modpack.ModpackConfiguration;
import net.jan.moddirector.core.configuration.type.CurseRemoteMod;
import net.jan.moddirector.core.configuration.type.ModifyMod;
import net.jan.moddirector.core.configuration.type.ModrinthRemoteMod;
import net.jan.moddirector.core.configuration.type.RemoteConfig;
import net.jan.moddirector.core.configuration.type.UrlRemoteMod;
import net.jan.moddirector.core.manage.ModDirectorError;
import net.jan.moddirector.core.util.IOOperation;
import net.jan.moddirector.core.util.JacksonProvider;
import net.jan.moddirector.core.util.WebClient;
import net.jan.moddirector.core.util.WebGetResponse;

public class ConfigurationController {
    public static final ObjectMapper OBJECT_MAPPER = JacksonProvider.getObjectMapper();
    private final ModpackDirector director;
    private final Path configurationDirectory;
    private final List<ModDirectorRemoteMod> configurations;
    private ModpackConfiguration modpackConfiguration;

    public ConfigurationController(ModpackDirector director, Path configurationDirectory) {
        this.director = director;
        this.configurationDirectory = configurationDirectory;
        this.configurations = new ArrayList<ModDirectorRemoteMod>();
    }

    public void load() {
        Path modpackConfigPath = this.configurationDirectory.resolve("modpack.json");
        if (Files.exists(modpackConfigPath, new LinkOption[0]) && !this.loadModpackConfiguration(modpackConfigPath)) {
            return;
        }
        try (Stream<Path> paths = Files.walk(this.configurationDirectory, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json")).filter(p -> !p.getFileName().toString().equals("modpack.json")).sorted().forEach(this::addConfig);
        }
        catch (IOException e) {
            this.director.getLogger().error("Failed to iterate configuration directory!", e);
            this.director.addError(new ModDirectorError(Level.SEVERE, "Failed to iterate configuration directory", e));
        }
    }

    private boolean loadModpackConfiguration(Path configurationPath) {
        boolean bl;
        block8: {
            InputStream stream = Files.newInputStream(configurationPath, new OpenOption[0]);
            try {
                this.modpackConfiguration = OBJECT_MAPPER.readValue(stream, ModpackConfiguration.class);
                bl = true;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.director.getLogger().error("Failed to read modpack configuration!", e);
                    this.director.addError(new ModDirectorError(Level.SEVERE, "Failed to read modpack configuration!"));
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    private void addConfig(Path configurationPath) {
        String configString = configurationPath.toString();
        this.director.getLogger().info("Loading config {0}", configString);
        if (configString.endsWith(".remote.json")) {
            this.handleRemoteConfig(configurationPath);
        } else if (configString.endsWith(".bundle.json")) {
            this.handleBundleConfig(configurationPath);
        } else if (configString.endsWith(".modify.json")) {
            this.handleModifyConfig(configurationPath);
        } else {
            this.handleSingleConfig(configurationPath);
        }
    }

    private void handleRemoteConfig(Path configurationPath) {
        try (InputStream stream = Files.newInputStream(configurationPath, new OpenOption[0]);){
            RemoteConfig remoteConfig = OBJECT_MAPPER.readValue(stream, RemoteConfig.class);
            try (WebGetResponse response = WebClient.get(remoteConfig.getUrl());){
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                IOOperation.copy(response.getInputStream(), outputStream);
                String fileName = remoteConfig.getUrl().toString().substring(remoteConfig.getUrl().toString().lastIndexOf(47) + 1);
                Path installationRoot = this.director.getPlatform().installationRoot().toAbsolutePath().normalize();
                Path remoteConfigPath = installationRoot.resolve(this.configurationDirectory).resolve(fileName);
                Files.write(remoteConfigPath, outputStream.toByteArray(), new OpenOption[0]);
                this.addConfig(remoteConfigPath);
                Files.delete(remoteConfigPath);
            }
        }
        catch (IOException e) {
            this.handleConfigException(e);
        }
    }

    private void handleBundleConfig(Path configurationPath) {
        try (InputStream stream = Files.newInputStream(configurationPath, new OpenOption[0]);
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            JsonNode jsonTree = OBJECT_MAPPER.readTree(reader);
            JsonNode jsonArray = jsonTree.get("curse");
            if (jsonArray != null && jsonArray.isArray()) {
                for (JsonNode jsonNode : jsonArray) {
                    this.configurations.add(OBJECT_MAPPER.convertValue((Object)jsonNode, CurseRemoteMod.class));
                }
            }
            if ((jsonArray = jsonTree.get("modrinth")) != null && jsonArray.isArray()) {
                for (JsonNode jsonNode : jsonArray) {
                    this.configurations.add(OBJECT_MAPPER.convertValue((Object)jsonNode, ModrinthRemoteMod.class));
                }
            }
            if ((jsonArray = jsonTree.get("url")) != null && jsonArray.isArray()) {
                for (JsonNode jsonNode : jsonArray) {
                    this.configurations.add(OBJECT_MAPPER.convertValue((Object)jsonNode, UrlRemoteMod.class));
                }
            }
            if ((jsonArray = jsonTree.get("modify")) != null && jsonArray.isArray()) {
                for (JsonNode jsonNode : jsonArray) {
                    this.handleModifyConfig(OBJECT_MAPPER.convertValue((Object)jsonNode, ModifyMod.class));
                }
            }
        }
        catch (IOException e) {
            this.handleConfigException(e);
        }
    }

    private void handleSingleConfig(Path configurationPath) {
        Class<? extends ModDirectorRemoteMod> targetType = this.getTypeForFile(configurationPath);
        if (targetType != null) {
            try (InputStream stream = Files.newInputStream(configurationPath, new OpenOption[0]);){
                this.configurations.add(OBJECT_MAPPER.readValue(stream, targetType));
            }
            catch (IOException e) {
                this.handleConfigException(e);
            }
        }
    }

    private void handleModifyConfig(Path configurationPath) {
        try (InputStream stream = Files.newInputStream(configurationPath, new OpenOption[0]);){
            ModifyMod modifyMod = OBJECT_MAPPER.readValue(stream, ModifyMod.class);
            this.handleModifyConfig(modifyMod);
        }
        catch (IOException e) {
            this.handleConfigException(e);
        }
    }

    private void handleModifyConfig(ModifyMod modifyMod) {
        block19: {
            try {
                Path installationRoot = this.director.getPlatform().installationRoot().toAbsolutePath().normalize();
                Path modifyModFolderPath = installationRoot.resolve(modifyMod.getFolder());
                if (modifyMod.getFileName() == null) {
                    if (!Files.isDirectory(modifyModFolderPath, new LinkOption[0]) || !modifyMod.shouldDelete()) break block19;
                    this.director.getLogger().info("Deleting folder {0}", modifyModFolderPath);
                    try (Stream<Path> paths = Files.walk(modifyModFolderPath, new FileVisitOption[0]);){
                        paths.forEach(path -> {
                            try {
                                Files.deleteIfExists(path);
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        });
                    }
                    Files.deleteIfExists(modifyModFolderPath);
                    break block19;
                }
                Path modifyModFilePath = modifyModFolderPath.resolve(modifyMod.getFileName());
                if (Files.isRegularFile(modifyModFilePath, new LinkOption[0])) {
                    if (modifyMod.shouldDisable()) {
                        this.director.getLogger().info("Disabling file {0}", modifyModFilePath);
                        Files.move(modifyModFilePath, modifyModFilePath.resolveSibling(modifyMod.getFileName() + ".disabled-by-mod-director"), new CopyOption[0]);
                    } else if (modifyMod.shouldDelete()) {
                        this.director.getLogger().info("Deleting file {0}", modifyModFilePath);
                        Files.delete(modifyModFilePath);
                    } else {
                        Path modifyModNewFilePath = null;
                        if (modifyMod.getNewFolder() != null) {
                            this.director.getLogger().info("Moving file {0}", modifyModFilePath);
                            modifyModFolderPath = installationRoot.resolve(modifyMod.getNewFolder());
                            Files.createDirectories(modifyModFolderPath, new FileAttribute[0]);
                            modifyModNewFilePath = modifyModFolderPath.resolve(modifyMod.getFileName());
                        }
                        if (modifyMod.getNewFileName() != null) {
                            this.director.getLogger().info("Renaming file {0}", modifyModFilePath);
                            Path path2 = modifyModNewFilePath = modifyModNewFilePath != null ? modifyModNewFilePath.resolveSibling(modifyMod.getNewFileName()) : modifyModFilePath.resolveSibling(modifyMod.getNewFileName());
                        }
                        if (modifyModNewFilePath != null) {
                            if (Files.exists(modifyModNewFilePath, new LinkOption[0])) {
                                Path disabledFilePath = modifyModNewFilePath.resolveSibling(modifyModNewFilePath.getFileName() + ".disabled-by-mod-director");
                                if (Files.exists(disabledFilePath, new LinkOption[0])) {
                                    Files.delete(disabledFilePath);
                                }
                                Files.move(modifyModNewFilePath, disabledFilePath, new CopyOption[0]);
                            }
                            Files.move(modifyModFilePath, modifyModNewFilePath, new CopyOption[0]);
                        }
                    }
                }
            }
            catch (IOException | UncheckedIOException e) {
                this.handleConfigException(e);
            }
        }
    }

    private void handleConfigException(Exception e) {
        this.director.getLogger().error("Failed to {0} a configuration for reading!", e instanceof JsonParseException ? "parse" : "open", e);
        this.director.addError(new ModDirectorError(Level.SEVERE, "Failed to " + (e instanceof JsonParseException ? "parse" : "open") + " a configuration for reading", e));
    }

    private Class<? extends ModDirectorRemoteMod> getTypeForFile(Path file) {
        String name = file.toString();
        if (name.endsWith(".curse.json")) {
            return CurseRemoteMod.class;
        }
        if (name.endsWith(".modrinth.json")) {
            return ModrinthRemoteMod.class;
        }
        if (name.endsWith(".url.json")) {
            return UrlRemoteMod.class;
        }
        this.director.getLogger().warn("Ignoring unknown json file {}0", name);
        return null;
    }

    public List<ModDirectorRemoteMod> getConfigurations() {
        return this.configurations;
    }

    public ModpackConfiguration getModpackConfiguration() {
        return this.modpackConfiguration;
    }
}

