/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.configuration.type;

import com.juanmuscaria.modpackdirector.ModpackDirector;
import com.juanmuscaria.modpackdirector.shadow.jackson.annotation.JsonCreator;
import com.juanmuscaria.modpackdirector.shadow.jackson.annotation.JsonIgnoreProperties;
import com.juanmuscaria.modpackdirector.shadow.jackson.annotation.JsonProperty;
import com.juanmuscaria.modpackdirector.shadow.jackson.core.JsonParseException;
import com.juanmuscaria.modpackdirector.shadow.jackson.databind.JsonMappingException;
import com.juanmuscaria.modpackdirector.shadow.jackson.databind.JsonNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import net.jan.moddirector.core.configuration.ConfigurationController;
import net.jan.moddirector.core.configuration.InstallationPolicy;
import net.jan.moddirector.core.configuration.ModDirectorRemoteMod;
import net.jan.moddirector.core.configuration.RemoteModInformation;
import net.jan.moddirector.core.configuration.RemoteModMetadata;
import net.jan.moddirector.core.exception.ModDirectorException;
import net.jan.moddirector.core.manage.ProgressCallback;
import net.jan.moddirector.core.util.IOOperation;
import net.jan.moddirector.core.util.WebClient;
import net.jan.moddirector.core.util.WebGetResponse;

public class CurseRemoteMod
extends ModDirectorRemoteMod {
    private final int addonId;
    private final int fileId;
    private final String fileName;
    private CurseAddonFileInformation information;

    @JsonCreator
    public CurseRemoteMod(@JsonProperty(value="addonId", required=true) int addonId, @JsonProperty(value="fileId", required=true) int fileId, @JsonProperty(value="metadata") RemoteModMetadata metadata, @JsonProperty(value="installationPolicy") InstallationPolicy installationPolicy, @JsonProperty(value="options") Map<String, Object> options, @JsonProperty(value="folder") String folder, @JsonProperty(value="inject") Boolean inject, @JsonProperty(value="fileName") String fileName) {
        super(metadata, installationPolicy, options, folder, inject);
        this.addonId = addonId;
        this.fileId = fileId;
        this.fileName = fileName;
    }

    @Override
    public String remoteType() {
        return "CurseForge";
    }

    @Override
    public String offlineName() {
        return this.addonId + ":" + this.fileId;
    }

    @Override
    public String remoteUrl() {
        return this.information.getDownloadUrl().toString();
    }

    @Override
    public void performInstall(Path targetFile, ProgressCallback progressCallback, ModpackDirector director, RemoteModInformation information) throws ModDirectorException {
        try (WebGetResponse response = WebClient.get(this.information.downloadUrl);){
            progressCallback.setSteps(1);
            IOOperation.copy(response.getInputStream(), Files.newOutputStream(targetFile, new OpenOption[0]), progressCallback, response.getStreamSize());
        }
        catch (IOException e) {
            throw new ModDirectorException("Failed to download file", e);
        }
    }

    @Override
    public RemoteModInformation queryInformation() throws ModDirectorException {
        try {
            JsonNode jsonObject;
            URL apiUrl = new URL(String.format("https://api.curse.tools/v1/cf/mods/%s/files/%s", this.addonId, this.fileId));
            WebGetResponse response = WebClient.get(apiUrl);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getInputStream(), StandardCharsets.UTF_8));){
                jsonObject = ConfigurationController.OBJECT_MAPPER.readTree(reader).get("data");
            }
            this.information = ConfigurationController.OBJECT_MAPPER.convertValue((Object)jsonObject, CurseAddonFileInformation.class);
        }
        catch (MalformedURLException e) {
            throw new ModDirectorException("Failed to create curse.tools api url", e);
        }
        catch (JsonParseException e) {
            throw new ModDirectorException("Failed to parse Json response from curse", e);
        }
        catch (JsonMappingException e) {
            throw new ModDirectorException("Failed to map Json response from curse, did they change their api?", e);
        }
        catch (IOException e) {
            throw new ModDirectorException("Failed to open connection to curse", e);
        }
        if (this.fileName != null) {
            return new RemoteModInformation(this.fileName, this.fileName);
        }
        return new RemoteModInformation(this.information.displayName, this.information.fileName);
    }

    public int getAddonId() {
        return this.addonId;
    }

    public int getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public CurseAddonFileInformation getInformation() {
        return this.information;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CurseAddonFileInformation {
        @JsonProperty
        private String displayName;
        @JsonProperty
        private String fileName;
        @JsonProperty
        private URL downloadUrl;
        @JsonProperty
        private String[] gameVersions;

        public String getDisplayName() {
            return this.displayName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public URL getDownloadUrl() {
            return this.downloadUrl;
        }

        public String[] getGameVersions() {
            return this.gameVersions;
        }
    }
}

