/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.manage;

import com.juanmuscaria.modpackdirector.ModpackDirector;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.logging.Level;
import net.jan.moddirector.core.configuration.ModDirectorRemoteMod;
import net.jan.moddirector.core.configuration.RemoteModInformation;
import net.jan.moddirector.core.configuration.modpack.ModpackConfiguration;
import net.jan.moddirector.core.exception.ModDirectorException;
import net.jan.moddirector.core.manage.ModDirectorError;
import net.jan.moddirector.core.manage.ProgressCallback;
import net.jan.moddirector.core.manage.install.InstallableMod;
import net.jan.moddirector.core.manage.install.InstalledMod;
import net.jan.moddirector.core.util.HashResult;

public class InstallController {
    private final ModpackDirector director;

    public InstallController(ModpackDirector director) {
        this.director = director;
    }

    private Level downloadSeverityLevelFor(ModDirectorRemoteMod mod) {
        return mod.getInstallationPolicy().shouldContinueOnFailedDownload() ? Level.WARNING : Level.SEVERE;
    }

    public List<Callable<Void>> createPreInstallTasks(List<ModDirectorRemoteMod> allMods, List<ModDirectorRemoteMod> excludedMods, List<InstallableMod> freshMods, List<InstallableMod> reinstallMods, BiFunction<String, String, ProgressCallback> callbackFactory) {
        ArrayList<Callable<Void>> preInstallTasks = new ArrayList<Callable<Void>>();
        for (ModDirectorRemoteMod mod : allMods) {
            preInstallTasks.add(() -> {
                Path supersededFile;
                RemoteModInformation information;
                ProgressCallback callback = (ProgressCallback)callbackFactory.apply(mod.offlineName(), "Checking installation status");
                callback.indeterminate(true);
                callback.message("Checking installation requirements");
                if (mod.getMetadata() != null && !mod.getMetadata().shouldTryInstall(this.director.platform())) {
                    this.director.logger().debug("Skipping mod {0} because shouldTryInstall() returned false", mod.offlineName());
                    excludedMods.add(mod);
                    callback.done();
                    return null;
                }
                callback.message("Querying mod information");
                try {
                    information = mod.queryInformation();
                }
                catch (ModDirectorException e) {
                    this.director.logger().error("Failed to query information for {0} from {1}}", mod.offlineName(), mod.remoteType(), e);
                    this.director.addError(new ModDirectorError(this.downloadSeverityLevelFor(mod), "Failed to query information for mod " + mod.offlineName() + " from " + mod.remoteType(), e));
                    callback.done();
                    return null;
                }
                callback.title(information.displayName());
                Path targetFile = this.computeInstallationTargetPath(mod, information);
                if (targetFile == null) {
                    callback.done();
                    return null;
                }
                Path disabledFile = this.computeDisabledPath(targetFile);
                if (Files.isRegularFile(disabledFile, new LinkOption[0]) || !this.isVersionCompliant(mod)) {
                    excludedMods.add(mod);
                    callback.done();
                    return null;
                }
                InstallableMod installableMod = new InstallableMod(mod, information, targetFile);
                Path bansoukouPatchedFile = this.computeBansoukouPatchedPath(targetFile);
                Path bansoukouDisabledFile = this.computeBansoukouDisabledPath(targetFile);
                if (mod.getMetadata() != null && (Files.isRegularFile(targetFile, new LinkOption[0]) || Files.isRegularFile(bansoukouPatchedFile, new LinkOption[0]) && Files.isRegularFile(bansoukouDisabledFile, new LinkOption[0]))) {
                    HashResult hashResult = mod.getMetadata().checkHashes(Files.isRegularFile(targetFile, new LinkOption[0]) ? targetFile : bansoukouDisabledFile, this.director.platform());
                    switch (hashResult) {
                        case UNKNOWN: {
                            this.director.logger().info("Skipping download of {0} as hashes can't be determined but file exists", targetFile.toString());
                            callback.done();
                            excludedMods.add(mod);
                            return null;
                        }
                        case MATCHED: {
                            this.director.logger().info("Skipping download of [0] as the hashes match", targetFile.toString());
                            callback.done();
                            excludedMods.add(mod);
                            return null;
                        }
                        case UNMATCHED: {
                            this.director.logger().warn("File {0} exists, but hashes do not match, downloading again!", targetFile.toString());
                        }
                    }
                    Files.deleteIfExists(bansoukouPatchedFile);
                    Files.deleteIfExists(bansoukouDisabledFile);
                    reinstallMods.add(installableMod);
                } else if (mod.getInstallationPolicy().shouldDownloadAlways() && Files.isRegularFile(targetFile, new LinkOption[0])) {
                    this.director.logger().info("Force downloading file {0} as download always option is set.", targetFile.toString());
                    reinstallMods.add(installableMod);
                } else if (Files.isRegularFile(targetFile, new LinkOption[0])) {
                    this.director.logger().debug("File {0} exists and no metadata given, skipping download.", targetFile.toString());
                    excludedMods.add(mod);
                } else {
                    freshMods.add(installableMod);
                }
                if (!excludedMods.contains(mod) && mod.getInstallationPolicy().getSupersededFileName() != null && Files.isRegularFile(supersededFile = targetFile.resolveSibling(mod.getInstallationPolicy().getSupersededFileName()), new LinkOption[0])) {
                    this.director.logger().info("Superseding {0}", targetFile);
                    Files.move(supersededFile, supersededFile.resolveSibling(supersededFile.getFileName() + ".disabled-by-mod-director"), new CopyOption[0]);
                }
                callback.done();
                return null;
            });
        }
        return preInstallTasks;
    }

    private Path computeInstallationTargetPath(ModDirectorRemoteMod mod, RemoteModInformation information) {
        Path installationRoot = this.director.platform().installationRoot().toAbsolutePath().normalize();
        Path targetFile = (mod.getFolder() == null ? this.director.platform().modFile(information.targetFilename()) : (mod.getFolder().equalsIgnoreCase(".") ? this.director.platform().rootFile(information.targetFilename()) : this.director.platform().customFile(information.targetFilename(), mod.getFolder()))).toAbsolutePath().normalize();
        if (!targetFile.startsWith(installationRoot)) {
            this.director.logger().error("Tried to install a file to {0}, which is outside the installation root of {1}!", targetFile.toString(), this.director.platform().installationRoot());
            this.director.addError(new ModDirectorError(Level.SEVERE, "Tried to install a file to " + targetFile + ", which is outside of the installation root " + installationRoot));
            return null;
        }
        return targetFile;
    }

    private Path computeDisabledPath(Path modFile) {
        return modFile.resolveSibling(modFile.getFileName() + ".disabled-by-mod-director");
    }

    private Path computeBansoukouPatchedPath(Path modFile) {
        return modFile.resolveSibling(modFile.getFileName().toString().replace(".jar", "-patched.jar"));
    }

    private Path computeBansoukouDisabledPath(Path modFile) {
        return modFile.resolveSibling(modFile.getFileName().toString().replace(".jar", ".disabled"));
    }

    private boolean isVersionCompliant(ModDirectorRemoteMod mod) {
        String versionMod = mod.getInstallationPolicy().getModpackVersion();
        String versionModpackRemote = this.director.getModpackRemoteVersion();
        ModpackConfiguration modpackConfiguration = this.director.getConfigurationController().getModpackConfiguration();
        String versionModpackLocal = null;
        if (modpackConfiguration != null) {
            versionModpackLocal = modpackConfiguration.localVersion();
        }
        if (versionMod != null) {
            if (versionModpackRemote != null) {
                return Objects.equals(versionMod, versionModpackRemote);
            }
            if (versionModpackLocal != null) {
                return Objects.equals(versionMod, versionModpackLocal);
            }
        }
        return true;
    }

    public void markDisabledMods(List<InstallableMod> mods) {
        for (InstallableMod mod : mods) {
            try {
                Path disabledFile = this.computeDisabledPath(mod.getTargetFile());
                Files.createDirectories(disabledFile.getParent(), new FileAttribute[0]);
                Files.createFile(disabledFile, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.director.logger().warn("Failed to create disabled file, the user might be asked again if he wants to install the mod", e);
                this.director.addError(new ModDirectorError(Level.WARNING, "Failed to create disabled file", e));
            }
        }
    }

    public List<Callable<Void>> createInstallTasks(List<InstallableMod> mods, BiFunction<String, String, ProgressCallback> callbackFactory) {
        ArrayList<Callable<Void>> installTasks = new ArrayList<Callable<Void>>();
        for (InstallableMod mod : mods) {
            installTasks.add(() -> {
                this.handle(mod, (ProgressCallback)callbackFactory.apply(mod.getRemoteInformation().targetFilename(), "Installing"));
                return null;
            });
        }
        return installTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(InstallableMod mod, ProgressCallback callback) {
        try {
            ModDirectorRemoteMod remoteMod = mod.getRemoteMod();
            this.director.logger().debug("Now handling {0} from backend {1}}", remoteMod.offlineName(), remoteMod.remoteType());
            Path targetFile = mod.getTargetFile();
            try {
                Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.director.logger().error("Failed to create directory {0}", targetFile.getParent().toString(), e);
                this.director.addError(new ModDirectorError(Level.SEVERE, "Failed to create directory" + targetFile.getParent().toString(), e));
                callback.done();
                return;
            }
            try {
                mod.performInstall(this.director, callback);
            }
            catch (ModDirectorException e) {
                this.director.logger().log(this.downloadSeverityLevelFor(remoteMod), "Failed to install mod {0}", remoteMod.offlineName(), e);
                this.director.addError(new ModDirectorError(this.downloadSeverityLevelFor(remoteMod), "Failed to install mod " + remoteMod.offlineName(), e));
                callback.done();
                return;
            }
            if (remoteMod.getMetadata() != null && remoteMod.getMetadata().checkHashes(targetFile, this.director.platform()) == HashResult.UNMATCHED) {
                this.director.logger().error("Mod did not match hash after download, aborting!", new Object[0]);
                this.director.addError(new ModDirectorError(Level.SEVERE, "Mod did not match hash after download"));
            } else {
                if (remoteMod.getInstallationPolicy().shouldExtract()) {
                    this.director.logger().info("Extracted mod file {0}", targetFile.toString());
                } else {
                    this.director.logger().info("Installed mod file {0}", targetFile.toString());
                }
                this.director.getInstalledMods().add(new InstalledMod(targetFile, remoteMod.getOptions(), remoteMod.forceInject()));
            }
        }
        finally {
            callback.done();
        }
    }
}

