/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.manage.check;

import com.juanmuscaria.modpackdirector.ModpackDirector;
import com.juanmuscaria.modpackdirector.shadow.jackson.databind.JavaType;
import com.juanmuscaria.modpackdirector.shadow.jackson.databind.type.CollectionType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import net.jan.moddirector.core.configuration.ConfigurationController;
import net.jan.moddirector.core.exception.ModDirectorException;
import net.jan.moddirector.core.manage.ModDirectorError;
import net.jan.moddirector.core.manage.check.StopModRepostsEntry;
import net.jan.moddirector.core.util.WebClient;
import net.jan.moddirector.core.util.WebGetResponse;

public class StopModReposts {
    private final List<StopModRepostsEntry> entries = new ArrayList<StopModRepostsEntry>();
    private final ModpackDirector director;

    public StopModReposts(ModpackDirector director) {
        this.director = director;
        try (WebGetResponse response = WebClient.get(new URL("https://api.stopmodreposts.org/sites.json"));){
            CollectionType targetType = ConfigurationController.OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, StopModRepostsEntry.class);
            this.entries.addAll((Collection)ConfigurationController.OBJECT_MAPPER.readValue(response.getInputStream(), (JavaType)targetType));
        }
        catch (Exception e) {
            director.logger().error("Failed to retrieve StopModReposts database", e);
        }
    }

    public void check(URL url) throws ModDirectorException {
        this.director.logger().debug("Checking {0} against StopModReposts database", url.toExternalForm());
        for (StopModRepostsEntry entry : this.entries) {
            if (!url.toExternalForm().contains(entry.domain())) continue;
            this.director.getLogger().error("STOP! Download URL {0} is flagged in StopModReposts database, ABORTING!", url.toExternalForm());
            this.director.getLogger().error("Domain {0} is flagged", entry.domain());
            this.director.getLogger().error("Reason: {0}", entry.reason());
            if (!entry.notes().isEmpty()) {
                this.director.getLogger().error("Notes: {0}", entry.notes());
            }
            this.director.addError(new ModDirectorError(Level.SEVERE, "Found URL " + url.toExternalForm() + " on domain " + entry.domain() + " flagged in the StopModReposts database! Please use legal download pages, ModDirector has aborted the launch."));
            throw new ModDirectorException("Found flagged URL " + url.toExternalForm() + " in StopModReposts database");
        }
    }
}

