/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.manage.select;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jan.moddirector.core.configuration.InstallationPolicy;
import net.jan.moddirector.core.configuration.ModDirectorRemoteMod;
import net.jan.moddirector.core.manage.install.InstallableMod;
import net.jan.moddirector.core.manage.select.SelectableInstallOption;

public class InstallSelector {
    private final List<InstallableMod> alwaysInstall = new ArrayList<InstallableMod>();
    private final List<SelectableInstallOption> singleOptions = new ArrayList<SelectableInstallOption>();
    private final Map<String, List<SelectableInstallOption>> groupOptions = new HashMap<String, List<SelectableInstallOption>>();
    private final Map<SelectableInstallOption, InstallableMod> optionsToMod = new HashMap<SelectableInstallOption, InstallableMod>();

    public void accept(List<ModDirectorRemoteMod> excludedMods, List<InstallableMod> freshInstalls, List<InstallableMod> reInstall) {
        InstallationPolicy policy;
        ModDirectorRemoteMod remoteMod;
        ArrayList<String> ignoredGroups = new ArrayList<String>();
        for (ModDirectorRemoteMod modDirectorRemoteMod : excludedMods) {
            String group;
            InstallationPolicy policy2 = modDirectorRemoteMod.getInstallationPolicy();
            if (policy2 == null || (group = policy2.getOptionalKey()) == null || group.equals("$")) continue;
            ignoredGroups.add(group);
        }
        for (InstallableMod installableMod : reInstall) {
            String group;
            remoteMod = installableMod.getRemoteMod();
            if (remoteMod == null) continue;
            policy = remoteMod.getInstallationPolicy();
            if (policy != null && (group = policy.getOptionalKey()) != null && !group.equals("$")) {
                ignoredGroups.add(group);
            }
            this.alwaysInstall.add(installableMod);
        }
        for (InstallableMod installableMod : freshInstalls) {
            remoteMod = installableMod.getRemoteMod();
            if (remoteMod == null || (policy = remoteMod.getInstallationPolicy()) == null) continue;
            String optionalKey = policy.getOptionalKey();
            if (optionalKey == null) {
                this.alwaysInstall.add(installableMod);
                continue;
            }
            if (ignoredGroups.contains(optionalKey)) continue;
            SelectableInstallOption installOption = new SelectableInstallOption(policy.isSelectedByDefault(), policy.getName() == null ? remoteMod.offlineName() : policy.getName(), policy.getDescription());
            if (optionalKey.equals("$")) {
                this.singleOptions.add(installOption);
            } else {
                this.groupOptions.computeIfAbsent(optionalKey, k -> new ArrayList()).add(installOption);
            }
            this.optionsToMod.put(installOption, installableMod);
        }
    }

    public boolean hasSelectableOptions() {
        return !this.getSingleOptions().isEmpty() || !this.getGroupOptions().isEmpty();
    }

    public List<SelectableInstallOption> getSingleOptions() {
        return this.singleOptions;
    }

    public Map<String, List<SelectableInstallOption>> getGroupOptions() {
        return this.groupOptions;
    }

    public List<InstallableMod> computeModsToInstall() {
        ArrayList<InstallableMod> mods = new ArrayList<InstallableMod>(this.alwaysInstall);
        this.optionsToMod.forEach((option, mod) -> {
            if (option.isSelected()) {
                mods.add((InstallableMod)mod);
            }
        });
        return mods;
    }

    public List<InstallableMod> computeDisabledMods() {
        ArrayList<InstallableMod> mods = new ArrayList<InstallableMod>();
        this.optionsToMod.forEach((option, mod) -> {
            if (!option.isSelected()) {
                mods.add((InstallableMod)mod);
            }
        });
        return mods;
    }
}

