/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.eplt;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.epicpix.eplt.LanguageData;
import dev.epicpix.eplt.LanguageDataStore;
import dev.epicpix.eplt.TranslationInfo;
import dev.epicpix.eplt.TranslationSource;
import dev.epicpix.eplt.TranslationStatus;
import dev.epicpix.eplt.TranslationsDataStore;
import dev.epicpix.eplt.gui.LanguagesScreen;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1078;
import net.minecraft.class_1297;
import net.minecraft.class_2625;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_7065;
import net.minecraft.class_7367;
import net.minecraft.class_8113;

public class LanguageTranslatorMod
implements ClientModInitializer {
    public static final String MOD_VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("ep-language-translator").get()).getMetadata().getVersion().getFriendlyString();
    public static class_1078 languageStaticStorage = null;
    public static LanguageData languageOverlay = null;
    public static class_304 languagesKeyBinding;
    public static class_304 disableTranslationsKeyBinding;
    public static class_304 captureTranslationsKeyBinding;
    public static TranslationStatus translationStatus;
    public static boolean queueTranslationCapture;
    public static boolean capturingTranslations;
    public static final HashSet<String> capturedTranslationKeys;
    public static final TranslationsDataStore translations;

    public static void updateOverlay(LanguageData data) {
        if (languageOverlay != null && languageOverlay.id().equals(data.id())) {
            LanguageDataStore.useLanguageOverlay(data);
        }
    }

    public static void toggleTranslationsStatus() {
        translationStatus = translationStatus.next();
        LanguageTranslatorMod.refreshTranslations();
    }

    public static void refreshTranslations() {
        class_310 client = class_310.method_1551();
        if (client.field_1705 != null) {
            client.field_1705.method_1743().method_44813();
        }
        if (client.field_1687 != null) {
            for (class_1297 entity : client.field_1687.method_18112()) {
                if (!(entity instanceof class_8113.class_8123)) continue;
                class_8113.class_8123 textDisplay = (class_8113.class_8123)entity;
                textDisplay.field_42442 = null;
            }
            AtomicReferenceArray chunks = client.field_1687.method_2935().field_16246.field_16251;
            for (int i = 0; i < chunks.length(); ++i) {
                class_2818 chunk = (class_2818)chunks.get(i);
                if (chunk == null) continue;
                chunk.method_12214().values().forEach(x -> {
                    if (x instanceof class_2625) {
                        class_2625 sign = (class_2625)x;
                        sign.method_49853().field_43305 = null;
                        sign.method_49854().field_43305 = null;
                    }
                });
            }
        }
        if (client.field_1755 != null && client.field_1755 instanceof class_7065) {
            client.field_1755.method_41843();
        }
    }

    public void onInitializeClient() {
        languagesKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.eplt.languages", class_3675.class_307.field_1668, 78, "key.categories.eplt"));
        disableTranslationsKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.eplt.disable_translations", class_3675.class_307.field_1668, 77, "key.categories.eplt"));
        captureTranslationsKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.eplt.capture_translations", class_3675.class_307.field_1668, 75, "key.categories.eplt"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (languagesKeyBinding.method_1436()) {
                if (client.field_1755 != null) continue;
                client.method_1507((class_437)new LanguagesScreen(null));
            }
            while (disableTranslationsKeyBinding.method_1436()) {
                if (client.field_1755 != null) continue;
                LanguageTranslatorMod.toggleTranslationsStatus();
            }
            while (captureTranslationsKeyBinding.method_1436()) {
                if (client.field_1755 != null) continue;
                queueTranslationCapture = true;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadTranslations(class_3288 resourcePackProfile) {
        Class<?> groupResourcePackClass = null;
        try {
            groupResourcePackClass = Class.forName("net.fabricmc.fabric.impl.resource.loader.GroupResourcePack");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try (class_3262 resourcePack = resourcePackProfile.method_14458();){
            Record source;
            if (resourcePack instanceof ModResourcePack) {
                ModResourcePack modResourcePack = (ModResourcePack)resourcePack;
                String modId = modResourcePack.getFabricModMetadata().getId();
                Optional modOptional = FabricLoader.getInstance().getModContainer(modId);
                if (!modOptional.isPresent()) {
                    return;
                }
                source = new TranslationSource.ModSource((ModContainer)modOptional.get());
            } else {
                if (groupResourcePackClass != null && groupResourcePackClass.isInstance(resourcePack)) {
                    List packs;
                    try {
                        Field packsField = groupResourcePackClass.getDeclaredField("packs");
                        packsField.setAccessible(true);
                        packs = (List)packsField.get(resourcePack);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                    for (class_3262 pack : packs) {
                        if (!(pack instanceof ModResourcePack)) continue;
                        ModResourcePack modResourcePack = (ModResourcePack)pack;
                        String modId = modResourcePack.getFabricModMetadata().getId();
                        Optional modOptional = FabricLoader.getInstance().getModContainer(modId);
                        if (!modOptional.isPresent()) return;
                        source = new TranslationSource.ModSource((ModContainer)modOptional.get());
                        for (String namespace : pack.method_14406(class_3264.field_14188)) {
                            try {
                                class_7367 inputStreamSupplier = pack.method_14405(class_3264.field_14188, class_2960.method_43902((String)namespace, (String)"lang/en_us.json"));
                                if (inputStreamSupplier == null) continue;
                                InputStream is = (InputStream)inputStreamSupplier.get();
                                JsonObject x = (JsonObject)new Gson().fromJson(new String(is.readAllBytes()), JsonObject.class);
                                LanguageTranslatorMod.loadJsonTranslations(namespace, x, source);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    return;
                }
                if (resourcePack.method_14409().equals("vanilla")) {
                    Optional modOptional = FabricLoader.getInstance().getModContainer("minecraft");
                    if (!modOptional.isPresent()) throw new RuntimeException("'Minecraft' mod not found in mod list");
                    source = new TranslationSource.ModSource((ModContainer)modOptional.get());
                } else {
                    source = new TranslationSource.ResourcePackSource(resourcePackProfile);
                }
            }
            for (String namespace : resourcePack.method_14406(class_3264.field_14188)) {
                try {
                    class_7367 inputStreamSupplier = resourcePack.method_14405(class_3264.field_14188, class_2960.method_43902((String)namespace, (String)"lang/en_us.json"));
                    if (inputStreamSupplier == null) continue;
                    InputStream is = (InputStream)inputStreamSupplier.get();
                    JsonObject x = (JsonObject)new Gson().fromJson(new String(is.readAllBytes()), JsonObject.class);
                    LanguageTranslatorMod.loadJsonTranslations(namespace, x, source);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
    }

    public static void loadJsonTranslations(String namespace, JsonObject object, TranslationSource source) {
        for (Map.Entry entry : object.asMap().entrySet()) {
            JsonPrimitive primitive;
            String k = (String)entry.getKey();
            JsonElement v = (JsonElement)entry.getValue();
            if (!v.isJsonPrimitive() || !(primitive = v.getAsJsonPrimitive()).isString()) continue;
            translations.addTranslation(new TranslationInfo(namespace, k, v.getAsString(), source));
        }
    }

    static {
        translationStatus = TranslationStatus.ON;
        queueTranslationCapture = false;
        capturingTranslations = false;
        capturedTranslationKeys = new HashSet();
        translations = new TranslationsDataStore();
    }
}

