/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.eplt;

import dev.epicpix.eplt.LanguageTranslatorMod;
import dev.epicpix.eplt.TranslationSource;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2561;

public abstract class ModSourceSelector {
    private static final ModSourceSelector ALL_SELECTOR = new ModSourceSelector(){

        @Override
        public boolean shouldShow(String key) {
            return true;
        }

        @Override
        public class_2561 getText() {
            return class_2561.method_43471((String)"eplt.selectors.all");
        }

        @Override
        public SourceSelectorType getType() {
            return SourceSelectorType.ALL;
        }
    };

    public abstract boolean shouldShow(String var1);

    public abstract class_2561 getText();

    public abstract SourceSelectorType getType();

    public HashSet<String> includedKeys() {
        return new HashSet<String>();
    }

    public TranslationSource getSource() {
        return null;
    }

    public static ModSourceSelector fromSource(final TranslationSource source) {
        return new ModSourceSelector(){

            @Override
            public boolean shouldShow(String key) {
                List<TranslationSource> mapping = LanguageTranslatorMod.translations.getTranslationDefinitionSources().get(key);
                if (mapping == null) {
                    return false;
                }
                for (TranslationSource mSource : mapping) {
                    if (!mSource.equals(source)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public class_2561 getText() {
                if (source instanceof TranslationSource.ModSource) {
                    TranslationSource.ModSource modSource = (TranslationSource.ModSource)source;
                    return class_2561.method_43469((String)"eplt.selectors.mod", (Object[])new Object[]{modSource.mod().getMetadata().getName()});
                }
                if (source instanceof TranslationSource.ResourcePackSource) {
                    TranslationSource.ResourcePackSource resourcePackSource = (TranslationSource.ResourcePackSource)source;
                    return class_2561.method_43469((String)"eplt.selectors.resource_pack", (Object[])new Object[]{resourcePackSource.pack().method_14457()});
                }
                throw new IllegalStateException("Unknown translation source: " + String.valueOf(source));
            }

            @Override
            public SourceSelectorType getType() {
                return SourceSelectorType.SOURCED;
            }

            @Override
            public TranslationSource getSource() {
                return source;
            }
        };
    }

    public static ModSourceSelector all() {
        return ALL_SELECTOR;
    }

    public static ModSourceSelector fromKeys(final class_2561 name, final Set<String> keys) {
        return new ModSourceSelector(){

            @Override
            public boolean shouldShow(String key) {
                return keys.contains(key);
            }

            @Override
            public class_2561 getText() {
                return name;
            }

            @Override
            public SourceSelectorType getType() {
                return SourceSelectorType.ONLY_SOME;
            }
        };
    }

    public static ModSourceSelector exceptKeys(final class_2561 name, final Set<String> keys) {
        return new ModSourceSelector(){

            @Override
            public boolean shouldShow(String key) {
                return !keys.contains(key);
            }

            @Override
            public class_2561 getText() {
                return name;
            }

            @Override
            public SourceSelectorType getType() {
                return SourceSelectorType.EXCEPT_SOME;
            }
        };
    }

    public static ModSourceSelector onlyUnknownKeys(final class_2561 name) {
        return new ModSourceSelector(){

            @Override
            public boolean shouldShow(String key) {
                List<TranslationSource> mapping = LanguageTranslatorMod.translations.getTranslationDefinitionSources().get(key);
                return mapping == null || mapping.isEmpty();
            }

            @Override
            public class_2561 getText() {
                return name;
            }

            @Override
            public SourceSelectorType getType() {
                return SourceSelectorType.ONLY_UNKNOWN;
            }
        };
    }

    public static ModSourceSelector onlyCapturedKeys(final class_2561 name) {
        return new ModSourceSelector(){

            @Override
            public boolean shouldShow(String key) {
                return LanguageTranslatorMod.capturedTranslationKeys.contains(key);
            }

            @Override
            public class_2561 getText() {
                return name;
            }

            @Override
            public SourceSelectorType getType() {
                return SourceSelectorType.ONLY_CAPTURED;
            }

            @Override
            public HashSet<String> includedKeys() {
                return LanguageTranslatorMod.capturedTranslationKeys;
            }
        };
    }

    public static enum SourceSelectorType {
        ALL,
        ONLY_SOME,
        EXCEPT_SOME,
        ONLY_UNKNOWN,
        ONLY_CAPTURED,
        SOURCED;

    }
}

