/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.eplt;

import dev.epicpix.eplt.TranslationInfo;
import dev.epicpix.eplt.TranslationSource;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TranslationsDataStore {
    private final ArrayList<TranslationInfo> knownTranslations = new ArrayList();
    private List<ObjectIntImmutablePair<TranslationSource>> computedTranslationSourceUseCounts;
    private Map<String, List<TranslationSource>> computedTranslationDefinitionSources;
    private Map<String, List<String>> computedTranslationDefinitionNamespaces;
    private Map<String, String> computedTranslationMap;
    private Map<ObjectObjectImmutablePair<TranslationSource, String>, String> computedSourceTranslationMap;

    public List<ObjectIntImmutablePair<TranslationSource>> getTranslationSourceUseCounts() {
        if (this.computedTranslationSourceUseCounts != null) {
            return this.computedTranslationSourceUseCounts;
        }
        Object2IntOpenHashMap compute = new Object2IntOpenHashMap();
        for (TranslationInfo translation : this.knownTranslations) {
            compute.addTo((Object)translation.source(), 1);
        }
        ArrayList<ObjectIntImmutablePair<TranslationSource>> computedList = new ArrayList<ObjectIntImmutablePair<TranslationSource>>();
        for (Object2IntMap.Entry entry : compute.object2IntEntrySet()) {
            computedList.add((ObjectIntImmutablePair<TranslationSource>)new ObjectIntImmutablePair((Object)((TranslationSource)entry.getKey()), entry.getIntValue()));
        }
        computedList.sort(Comparator.comparingInt(a -> -a.rightInt()));
        this.computedTranslationSourceUseCounts = computedList;
        return this.computedTranslationSourceUseCounts;
    }

    public Map<String, List<TranslationSource>> getTranslationDefinitionSources() {
        if (this.computedTranslationDefinitionSources != null) {
            return this.computedTranslationDefinitionSources;
        }
        HashMap<String, List<TranslationSource>> sources = new HashMap<String, List<TranslationSource>>();
        for (TranslationInfo translation : this.knownTranslations) {
            List<TranslationSource> content = sources.get(translation.key());
            if (content == null) {
                content = List.of(translation.source());
            } else if (content.size() == 1) {
                content = List.of(content.get(0), translation.source());
            } else {
                if (content.size() == 2) {
                    content = new ArrayList<TranslationSource>(content);
                }
                content.add(translation.source());
            }
            sources.put(translation.key(), content);
        }
        this.computedTranslationDefinitionSources = sources;
        return this.computedTranslationDefinitionSources;
    }

    public Map<String, List<String>> getTranslationDefinitionNamespaces() {
        if (this.computedTranslationDefinitionNamespaces != null) {
            return this.computedTranslationDefinitionNamespaces;
        }
        HashMap<String, List<String>> sources = new HashMap<String, List<String>>();
        for (TranslationInfo translation : this.knownTranslations) {
            List<String> content = sources.get(translation.key());
            if (content == null) {
                content = List.of(translation.namespace());
            } else if (content.size() == 1) {
                content = List.of(content.get(0), translation.namespace());
            } else {
                if (content.size() == 2) {
                    content = new ArrayList<String>(content);
                }
                content.add(translation.namespace());
            }
            sources.put(translation.key(), content);
        }
        this.computedTranslationDefinitionNamespaces = sources;
        return this.computedTranslationDefinitionNamespaces;
    }

    public Map<String, String> getTranslationMap() {
        if (this.computedTranslationMap != null) {
            return this.computedTranslationMap;
        }
        HashMap<String, String> sources = new HashMap<String, String>();
        for (TranslationInfo translation : this.knownTranslations) {
            sources.put(translation.key(), translation.value());
        }
        this.computedTranslationMap = sources;
        return this.computedTranslationMap;
    }

    public Map<ObjectObjectImmutablePair<TranslationSource, String>, String> getSourceTranslationMap() {
        if (this.computedSourceTranslationMap != null) {
            return this.computedSourceTranslationMap;
        }
        HashMap<ObjectObjectImmutablePair<TranslationSource, String>, String> sources = new HashMap<ObjectObjectImmutablePair<TranslationSource, String>, String>();
        for (TranslationInfo translation : this.knownTranslations) {
            sources.put((ObjectObjectImmutablePair<TranslationSource, String>)new ObjectObjectImmutablePair((Object)translation.source(), (Object)translation.key()), translation.value());
        }
        this.computedSourceTranslationMap = sources;
        return this.computedSourceTranslationMap;
    }

    public String getTranslation(String key, String defaultValue) {
        return this.getTranslationMap().getOrDefault(key, defaultValue);
    }

    public String getTranslation(TranslationSource source, String key, String defaultValue) {
        if (source == null) {
            return this.getTranslation(key, defaultValue);
        }
        return this.getSourceTranslationMap().getOrDefault(new ObjectObjectImmutablePair((Object)source, (Object)key), defaultValue);
    }

    private void markTranslationsDirty() {
        this.computedTranslationSourceUseCounts = null;
        this.computedTranslationDefinitionSources = null;
        this.computedTranslationDefinitionNamespaces = null;
        this.computedTranslationMap = null;
    }

    public void addTranslation(TranslationInfo info) {
        this.knownTranslations.add(info);
        this.markTranslationsDirty();
    }

    public void reset() {
        this.knownTranslations.clear();
        this.markTranslationsDirty();
    }
}

