/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.eplt;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.epicpix.eplt.LanguageData;
import dev.epicpix.eplt.LanguageTranslatorMod;
import dev.epicpix.eplt.gui.LanguageEditorScreen;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class LanguageDataStore {
    private static Thread overlayWatchService;

    private static Path getLanguagesDir() {
        Path dir = FabricLoader.getInstance().getGameDir().resolve("languages-eplt");
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return dir;
    }

    private static Path getLanguagePath(String id) {
        return LanguageDataStore.getLanguagesDir().resolve(id + ".json");
    }

    public static boolean languageExists(String id) {
        return Files.exists(LanguageDataStore.getLanguagePath(id), new LinkOption[0]);
    }

    public static LanguageData createLanguage(String id, String name, String region, String description) {
        LanguageData data = new LanguageData(id, name, region, description, new HashMap<String, String>());
        LanguageDataStore.saveLanguageData(data);
        return data;
    }

    public static ArrayList<LanguageData> listLanguages() {
        ArrayList<LanguageData> langs = new ArrayList<LanguageData>();
        try (Stream<Path> list = Files.list(LanguageDataStore.getLanguagesDir());){
            list.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.getFileName().toString().endsWith(".json")).forEach(f -> langs.add(LanguageDataStore.readLanguageData(f.getFileName().toString().replaceAll("\\.json$", ""))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return langs;
    }

    public static void deleteLanguage(LanguageData language) {
        try {
            Files.deleteIfExists(LanguageDataStore.getLanguagePath(language.id()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean exportLanguage(LanguageData language, String resultPath) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:file:" + resultPath);
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
            JsonObject packFileData = new JsonObject();
            JsonObject packData = new JsonObject();
            packData.addProperty("pack_format", (Number)15);
            packData.addProperty("description", language.description());
            packFileData.add("pack", (JsonElement)packData);
            JsonObject languagesData = new JsonObject();
            JsonObject languageData = new JsonObject();
            languageData.addProperty("name", language.name());
            languageData.addProperty("region", language.region());
            languageData.addProperty("bidirection", Boolean.valueOf(false));
            languagesData.add(language.id(), (JsonElement)languageData);
            packFileData.add("language", (JsonElement)languagesData);
            Files.writeString(zipfs.getPath("/pack.mcmeta", new String[0]), (CharSequence)new Gson().toJson((JsonElement)packFileData), new OpenOption[0]);
            HashMap<String, HashMap> namespaceLanguageMap = new HashMap<String, HashMap>();
            for (Map.Entry<String, String> entry : language.translations().entrySet()) {
                String namespace = LanguageTranslatorMod.translationNamespaceMappings.getOrDefault(entry.getKey(), "miscellaneous");
                HashMap v = namespaceLanguageMap.computeIfAbsent(namespace, k -> new HashMap());
                v.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : namespaceLanguageMap.entrySet()) {
                Files.createDirectories(zipfs.getPath("/assets/" + entry.getKey() + "/lang/", new String[0]), new FileAttribute[0]);
                Files.writeString(zipfs.getPath("/assets/" + entry.getKey() + "/lang/" + language.id() + ".json", new String[0]), (CharSequence)new Gson().toJson((Object)entry.getValue()), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static synchronized void useLanguageOverlay(LanguageData language) {
        if (overlayWatchService != null) {
            overlayWatchService.interrupt();
            overlayWatchService = null;
        }
        LanguageTranslatorMod.languageOverlay = language;
        LanguageTranslatorMod.refreshTranslations();
        class_310.method_1551().method_1526().method_14491(class_310.method_1551().method_1478());
        if (language != null) {
            overlayWatchService = new Thread(() -> {
                Path path = LanguageDataStore.getLanguagesDir();
                FileSystem fs = path.getFileSystem();
                try (WatchService service = fs.newWatchService();){
                    WatchKey key;
                    path.register(service, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
                    do {
                        key = service.take();
                        for (WatchEvent<?> watchEvent : key.pollEvents()) {
                            WatchEvent.Kind<?> kind = watchEvent.kind();
                            Path updated = ((Path)watchEvent.context()).toAbsolutePath();
                            if (!updated.getFileName().toString().equals(language.id() + ".json") || !Files.exists(LanguageDataStore.getLanguagePath(language.id()), new LinkOption[0])) continue;
                            try {
                                LanguageData data = LanguageDataStore.readLanguageData(language.id());
                                if (!data.id().equals(language.id())) continue;
                                RenderSystem.recordRenderCall(() -> {
                                    LanguageTranslatorMod.languageOverlay = data;
                                    class_310.method_1551().method_1526().method_14491(class_310.method_1551().method_1478());
                                    class_437 patt6170$temp = class_310.method_1551().field_1755;
                                    if (patt6170$temp instanceof LanguageEditorScreen) {
                                        LanguageEditorScreen s = (LanguageEditorScreen)patt6170$temp;
                                        if (s.data.id().equals(language.id())) {
                                            s.data = data;
                                            s.updateTooltip();
                                            s.generateTranslationList();
                                        }
                                    }
                                    LanguageTranslatorMod.refreshTranslations();
                                });
                            }
                            catch (JsonSyntaxException jsonSyntaxException) {}
                        }
                    } while (key.reset());
                }
                catch (IOException | InterruptedException | ThreadDeath throwable) {
                    // empty catch block
                }
            });
            overlayWatchService.start();
        }
    }

    public static void saveLanguageData(LanguageData data) {
        JsonObject json = new JsonObject();
        json.addProperty("id", data.id());
        json.addProperty("name", data.name());
        json.addProperty("region", data.region());
        json.addProperty("description", data.description());
        json.addProperty("data_version", (Number)1);
        JsonObject translations = new JsonObject();
        for (Map.Entry<String, String> entry : data.translations().entrySet()) {
            translations.addProperty(entry.getKey(), entry.getValue());
        }
        json.add("translations", (JsonElement)translations);
        try {
            Files.write(LanguageDataStore.getLanguagePath(data.id()), new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static LanguageData readLanguageData(String id) {
        String data;
        try {
            data = new String(Files.readAllBytes(LanguageDataStore.getLanguagePath(id)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonObject json = (JsonObject)new Gson().fromJson(data, JsonObject.class);
        HashMap<String, String> translations = new HashMap<String, String>();
        for (Map.Entry t : json.getAsJsonObject("translations").asMap().entrySet()) {
            translations.put((String)t.getKey(), ((JsonElement)t.getValue()).getAsString());
        }
        return new LanguageData(id, json.get("name").getAsString(), json.get("region").getAsString(), json.get("description").getAsString(), translations);
    }
}

