/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.eplt;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.epicpix.eplt.LanguageData;
import dev.epicpix.eplt.LanguageDataStore;
import dev.epicpix.eplt.TranslationStatus;
import dev.epicpix.eplt.gui.LanguagesScreen;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1078;
import net.minecraft.class_1297;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_7065;
import net.minecraft.class_8113;

public class LanguageTranslatorMod
implements ClientModInitializer {
    public static final String MOD_VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("ep-language-translator").get()).getMetadata().getVersion().getFriendlyString();
    public static class_1078 languageStaticStorage = null;
    public static LanguageData languageOverlay = null;
    public static class_304 languagesKeyBinding;
    public static class_304 disableTranslationsKeyBinding;
    public static TranslationStatus translationStatus;
    public static final HashMap<String, String> translationMappings;
    public static final HashMap<String, ModContainer> translationModMappings;
    public static final HashMap<String, String> translationNamespaceMappings;
    public static final HashMap<ModContainer, Integer> modTranslationCount;
    public static final ArrayList<class_3545<ModContainer, Integer>> modTranslationCountSorted;

    public static void updateOverlay(LanguageData data) {
        if (languageOverlay != null && languageOverlay.id().equals(data.id())) {
            LanguageDataStore.useLanguageOverlay(data);
        }
    }

    public static void toggleTranslationsEnabled() {
        translationStatus = translationStatus.next();
        LanguageTranslatorMod.refreshTranslations();
    }

    public static void refreshTranslations() {
        class_310 client = class_310.method_1551();
        if (client.field_1705 != null) {
            client.field_1705.method_1743().method_44813();
        }
        if (client.field_1687 != null) {
            for (class_1297 entity : client.field_1687.method_18112()) {
                if (!(entity instanceof class_8113.class_8123)) continue;
                class_8113.class_8123 textDisplay = (class_8113.class_8123)entity;
                textDisplay.field_42442 = null;
            }
        }
        if (client.field_1755 != null && client.field_1755 instanceof class_7065) {
            client.field_1755.method_41843();
        }
    }

    public void onInitializeClient() {
        languagesKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.eplt.languages", class_3675.class_307.field_1668, 78, "key.categories.eplt"));
        disableTranslationsKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.eplt.disable_translations", class_3675.class_307.field_1668, 77, "key.categories.eplt"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (languagesKeyBinding.method_1436()) {
                if (client.field_1755 != null) continue;
                client.method_1507((class_437)new LanguagesScreen(null));
            }
            while (disableTranslationsKeyBinding.method_1436()) {
                if (client.field_1755 != null) continue;
                LanguageTranslatorMod.toggleTranslationsEnabled();
            }
        });
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            Optional assets = mod.findPath("assets/");
            if (assets.isEmpty()) continue;
            try {
                Stream<Path> list = Files.list((Path)assets.get());
                try {
                    list.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(namespace -> {
                        Optional a = mod.findPath("assets/" + String.valueOf(namespace.getFileName()) + "/lang/en_us.json");
                        if (a.isEmpty()) {
                            return;
                        }
                        try {
                            JsonObject x = (JsonObject)new Gson().fromJson(new String(Files.readAllBytes((Path)a.get())), JsonObject.class);
                            x.asMap().forEach((k, v) -> {
                                if (!v.isJsonPrimitive()) {
                                    return;
                                }
                                JsonPrimitive primitive = v.getAsJsonPrimitive();
                                if (!primitive.isString()) {
                                    return;
                                }
                                translationModMappings.put((String)k, mod);
                                translationMappings.put((String)k, v.getAsString());
                                translationNamespaceMappings.put((String)k, namespace.getFileName().toString());
                            });
                            modTranslationCount.put(mod, modTranslationCount.getOrDefault(mod, 0) + x.size());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                finally {
                    if (list == null) continue;
                    list.close();
                }
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        modTranslationCount.entrySet().stream().sorted(Comparator.comparingInt(a -> -((Integer)a.getValue()).intValue())).forEach(e -> modTranslationCountSorted.add((class_3545<ModContainer, Integer>)new class_3545((Object)((ModContainer)e.getKey()), (Object)((Integer)e.getValue()))));
    }

    static {
        translationStatus = TranslationStatus.ON;
        translationMappings = new HashMap();
        translationModMappings = new HashMap();
        translationNamespaceMappings = new HashMap();
        modTranslationCount = new HashMap();
        modTranslationCountSorted = new ArrayList();
    }
}

