/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.eplt;

import dev.epicpix.eplt.LanguageTranslatorMod;
import java.util.Set;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;

public abstract class ModSourceSelector {
    private static final ModSourceSelector ALL_SELECTOR = new ModSourceSelector(){

        @Override
        public boolean shouldShow(String key) {
            return true;
        }

        @Override
        public class_2561 getText() {
            return class_2561.method_43471((String)"eplt.selectors.all");
        }

        @Override
        public SourceSelectorType getType() {
            return SourceSelectorType.ALL;
        }
    };

    public abstract boolean shouldShow(String var1);

    public abstract class_2561 getText();

    public abstract SourceSelectorType getType();

    public ModContainer getMod() {
        return null;
    }

    public static ModSourceSelector fromMod(final ModContainer mod) {
        return new ModSourceSelector(){

            @Override
            public boolean shouldShow(String key) {
                ModContainer mapping = LanguageTranslatorMod.translationModMappings.get(key);
                if (mapping == null) {
                    return false;
                }
                return mapping.getMetadata().getId().equals(mod.getMetadata().getId());
            }

            @Override
            public class_2561 getText() {
                return class_2561.method_43469((String)"eplt.selectors.mod", (Object[])new Object[]{mod.getMetadata().getName()});
            }

            @Override
            public SourceSelectorType getType() {
                return SourceSelectorType.MOD;
            }

            @Override
            public ModContainer getMod() {
                return mod;
            }
        };
    }

    public static ModSourceSelector all() {
        return ALL_SELECTOR;
    }

    public static ModSourceSelector fromKeys(final class_2561 name, final Set<String> keys) {
        return new ModSourceSelector(){

            @Override
            public boolean shouldShow(String key) {
                return keys.contains(key);
            }

            @Override
            public class_2561 getText() {
                return name;
            }

            @Override
            public SourceSelectorType getType() {
                return SourceSelectorType.ONLY_SOME;
            }
        };
    }

    public static ModSourceSelector exceptKeys(final class_2561 name, final Set<String> keys) {
        return new ModSourceSelector(){

            @Override
            public boolean shouldShow(String key) {
                return !keys.contains(key);
            }

            @Override
            public class_2561 getText() {
                return name;
            }

            @Override
            public SourceSelectorType getType() {
                return SourceSelectorType.EXCEPT_SOME;
            }
        };
    }

    public static ModSourceSelector onlyUnknownKeys(final class_2561 name) {
        return new ModSourceSelector(){

            @Override
            public boolean shouldShow(String key) {
                ModContainer mapping = LanguageTranslatorMod.translationModMappings.get(key);
                return mapping == null;
            }

            @Override
            public class_2561 getText() {
                return name;
            }

            @Override
            public SourceSelectorType getType() {
                return SourceSelectorType.ONLY_UNKNOWN;
            }
        };
    }

    public static enum SourceSelectorType {
        ALL,
        ONLY_SOME,
        EXCEPT_SOME,
        ONLY_UNKNOWN,
        MOD;

    }
}

