/*
 * Decompiled with CFR 0.152.
 */
package dev.epicpix.eplt.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.epicpix.eplt.LanguageData;
import dev.epicpix.eplt.LanguageDataStore;
import dev.epicpix.eplt.LanguageTranslatorMod;
import dev.epicpix.eplt.ModSourceSelector;
import dev.epicpix.eplt.SearchThread;
import dev.epicpix.eplt.gui.LanguageEditorWidget;
import dev.epicpix.eplt.gui.LanguageExportScreen;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1078;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5676;
import net.minecraft.class_7919;

public class LanguageEditorScreen
extends class_437 {
    private final class_437 parent;
    private LanguageEditorWidget languageEditorWidget;
    public LanguageData data;
    private class_342 searchKey;
    private class_342 searchValue;
    public class_342 translationKey;
    public class_342 translationValue;
    private class_4185 translationAdd;
    private class_4185 doneButton;
    private class_4185 exportButton;
    private class_5676<ModSourceSelector> selectorButton;
    private class_5676<Boolean> languageEnabledButton;
    private boolean shouldUpdateTooltip = true;
    private boolean holdingShift = false;

    public LanguageEditorScreen(class_437 parent, LanguageData data) {
        super((class_2561)class_2561.method_43469((String)"eplt.editor.title", (Object[])new Object[]{data.name()}));
        this.parent = parent;
        this.data = data;
    }

    public void generateTranslationList(String key, String value, ModSourceSelector selector) {
        SearchThread.executeSearch(this.data, this.languageEditorWidget, key, value, selector, result -> RenderSystem.recordRenderCall(() -> {
            this.updateTooltip();
            this.languageEditorWidget.method_25396().clear();
            this.languageEditorWidget.method_25396().addAll(result);
            this.languageEditorWidget.method_25307(this.languageEditorWidget.method_25341());
        }));
    }

    public void generateTranslationList() {
        this.generateTranslationList(this.searchKey.method_1882(), this.searchValue.method_1882(), (ModSourceSelector)this.selectorButton.method_32603());
    }

    protected void method_25426() {
        this.languageEditorWidget = new LanguageEditorWidget(this, class_310.method_1551(), 0, 0, 28);
        this.languageEditorWidget.method_25323(559, this.field_22790, 130, this.field_22790 - 45 + 4);
        this.languageEditorWidget.method_25333(this.field_22789 / 2 - 288);
        this.method_25429((class_364)this.languageEditorWidget);
        this.searchKey = new class_342(class_310.method_1551().field_1772, this.field_22789 / 2 - 150, 105, 150, 20, (class_2561)class_2561.method_43470((String)""));
        this.method_25429((class_364)this.searchKey);
        this.searchKey.method_47404((class_2561)class_2561.method_43471((String)"eplt.editor.search.key").method_27692(class_124.field_1080));
        this.searchKey.method_1863(text -> this.generateTranslationList());
        this.searchKey.method_1880(Integer.MAX_VALUE);
        this.searchValue = new class_342(class_310.method_1551().field_1772, this.field_22789 / 2, 105, 150, 20, (class_2561)class_2561.method_43470((String)""));
        this.method_25429((class_364)this.searchValue);
        this.searchValue.method_47404((class_2561)class_2561.method_43471((String)"eplt.editor.search.value").method_27692(class_124.field_1080));
        this.searchValue.method_1863(text -> this.generateTranslationList());
        this.searchValue.method_1880(Integer.MAX_VALUE);
        this.translationKey = new class_342(class_310.method_1551().field_1772, this.field_22789 / 2 - 200, 60, 150, 20, (class_2561)class_2561.method_43470((String)""));
        this.method_25429((class_364)this.translationKey);
        this.translationKey.method_47404((class_2561)class_2561.method_43471((String)"eplt.editor.input.key").method_27692(class_124.field_1080));
        this.translationKey.method_1880(Integer.MAX_VALUE);
        this.translationValue = new class_342(class_310.method_1551().field_1772, this.field_22789 / 2 + 50, 60, 150, 20, (class_2561)class_2561.method_43470((String)""));
        this.method_25429((class_364)this.translationValue);
        this.translationValue.method_47404((class_2561)class_2561.method_43471((String)"eplt.editor.input.value").method_27692(class_124.field_1080));
        this.translationValue.method_1880(Integer.MAX_VALUE);
        this.translationAdd = class_4185.method_46430((class_2561)class_2561.method_43471((String)"eplt.editor.translation.add"), button -> {
            this.data.translations().put(this.translationKey.method_1882(), this.translationValue.method_1882());
            LanguageDataStore.saveLanguageData(this.data);
            this.generateTranslationList();
            LanguageTranslatorMod.updateOverlay(this.data);
        }).method_46433(this.field_22789 / 2 - 45, 60).method_46437(90, 20).method_46431();
        this.method_25429((class_364)this.translationAdd);
        this.exportButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"eplt.editor.export"), button -> this.field_22787.method_1507((class_437)new LanguageExportScreen(this, this.data))).method_46433(this.field_22789 / 2 - 100, this.field_22790 - 35).method_46437(100, 20).method_46431();
        this.method_25429((class_364)this.exportButton);
        this.doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.field_22787.method_1507(this.parent)).method_46433(this.field_22789 / 2, this.field_22790 - 35).method_46437(100, 20).method_46431();
        this.method_25429((class_364)this.doneButton);
        ArrayList<ModSourceSelector> sources = new ArrayList<ModSourceSelector>();
        sources.add(ModSourceSelector.all());
        sources.add(ModSourceSelector.fromKeys((class_2561)class_2561.method_43471((String)"eplt.selectors.finished"), this.data.translations().keySet()));
        sources.add(ModSourceSelector.exceptKeys((class_2561)class_2561.method_43471((String)"eplt.selectors.unfinished"), this.data.translations().keySet()));
        sources.add(ModSourceSelector.onlyUnknownKeys((class_2561)class_2561.method_43471((String)"eplt.selectors.other")));
        for (class_3545<ModContainer, Integer> modPair : LanguageTranslatorMod.modTranslationCountSorted) {
            sources.add(ModSourceSelector.fromMod((ModContainer)modPair.method_15442()));
        }
        this.selectorButton = class_5676.method_32606(ModSourceSelector::getText).method_32620(sources).method_32617(0, this.field_22790 - 22, 200, 20, (class_2561)class_2561.method_43471((String)"eplt.selectors.showing"), (button, option) -> {
            this.shouldUpdateTooltip = true;
            this.generateTranslationList(this.searchKey.method_1882(), this.searchValue.method_1882(), (ModSourceSelector)option);
        });
        this.method_25429((class_364)this.selectorButton);
        this.generateTranslationList();
        this.languageEnabledButton = class_5676.method_32606(v -> class_2561.method_43471((String)(v != false ? "eplt.editor.overlay.enabled" : "eplt.editor.overlay.disabled"))).method_32624((Object[])new Boolean[]{false, true}).method_32617(this.field_22789 - 200, this.field_22790 - 22, 200, 20, (class_2561)class_2561.method_43471((String)"eplt.editor.overlay.text"), (button, option) -> {
            if (option.booleanValue()) {
                LanguageDataStore.useLanguageOverlay(this.data);
            } else {
                LanguageDataStore.useLanguageOverlay(null);
            }
        });
        this.method_25429((class_364)this.languageEnabledButton);
        this.languageEnabledButton.method_32605((Object)false);
        if (LanguageTranslatorMod.languageOverlay != null && LanguageTranslatorMod.languageOverlay.id().equals(this.data.id())) {
            this.languageEnabledButton.method_32605((Object)true);
        }
        this.languageEnabledButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"eplt.editor.overlay.tooltip")));
    }

    public void updateTooltip() {
        final class_2561 tooltipText = this.regenerateText();
        this.selectorButton.method_47400(new class_7919(tooltipText, (class_2561)class_2561.method_43473()){
            private List<class_5481> lines;

            public List<class_5481> method_47405(class_310 client) {
                if (this.lines == null) {
                    this.lines = client.field_1772.method_1728((class_5348)tooltipText, 400);
                }
                return this.lines;
            }
        });
    }

    private class_2561 regenerateText() {
        Map mcTranslations = ((class_1078)class_2477.method_10517()).field_5330;
        ArrayList<ResultData> resultData = new ArrayList<ResultData>();
        int createdTranslations = 0;
        HashSet otherTranslations = new HashSet(mcTranslations.keySet());
        for (class_3545<ModContainer, Integer> class_35452 : LanguageTranslatorMod.modTranslationCountSorted) {
            int translationCount = 0;
            for (Map.Entry<String, ModContainer> entry : LanguageTranslatorMod.translationModMappings.entrySet()) {
                if (!entry.getValue().getMetadata().getId().equals(((ModContainer)class_35452.method_15442()).getMetadata().getId())) continue;
                otherTranslations.remove(entry.getKey());
                if (!this.data.translations().containsKey(entry.getKey())) continue;
                ++translationCount;
            }
            resultData.add(new ResultData((class_2561)class_2561.method_43469((String)"eplt.editor.finished.mod", (Object[])new Object[]{((ModContainer)class_35452.method_15442()).getMetadata().getName()}), translationCount, (Integer)class_35452.method_15441(), ((ModSourceSelector)this.selectorButton.method_32603()).getMod() == class_35452.method_15442()));
            createdTranslations += translationCount;
        }
        int otherCreatedTranslations = 0;
        for (String key : otherTranslations) {
            if (this.data.translations().get(key) == null) continue;
            ++otherCreatedTranslations;
        }
        resultData.add(0, new ResultData((class_2561)class_2561.method_43471((String)"eplt.editor.finished.total"), createdTranslations, mcTranslations.size(), ((ModSourceSelector)this.selectorButton.method_32603()).getType() == ModSourceSelector.SourceSelectorType.ALL));
        resultData.add(1, new ResultData((class_2561)class_2561.method_43471((String)"eplt.editor.finished.only"), createdTranslations, mcTranslations.size(), ((ModSourceSelector)this.selectorButton.method_32603()).getType() == ModSourceSelector.SourceSelectorType.ONLY_SOME));
        resultData.add(2, new ResultData((class_2561)class_2561.method_43471((String)"eplt.editor.finished.except"), mcTranslations.size() - createdTranslations, mcTranslations.size(), ((ModSourceSelector)this.selectorButton.method_32603()).getType() == ModSourceSelector.SourceSelectorType.EXCEPT_SOME));
        resultData.add(3, new ResultData((class_2561)class_2561.method_43471((String)"eplt.editor.finished.other"), otherCreatedTranslations, otherTranslations.size(), ((ModSourceSelector)this.selectorButton.method_32603()).getType() == ModSourceSelector.SourceSelectorType.ONLY_UNKNOWN));
        class_5250 class_52502 = class_2561.method_43470((String)"");
        for (int i = 0; i < resultData.size(); ++i) {
            ResultData r = (ResultData)resultData.get(i);
            if (!r.selected) continue;
            for (int j = -4; j <= 4; ++j) {
                int indx;
                for (indx = i + j; indx < 0; indx += resultData.size()) {
                }
                while (indx >= resultData.size()) {
                    indx -= resultData.size();
                }
                ResultData x = (ResultData)resultData.get(indx);
                String percent = x.totalTranslations == 0 ? "100.00" : "%.2f".formatted(Float.valueOf((float)x.completedTranslations / (float)x.totalTranslations * 100.0f));
                class_52502.method_10852((class_2561)class_2561.method_43469((String)"eplt.editor.finished.format", (Object[])new Object[]{class_2561.method_43471((String)(!class_437.method_25442() ? "eplt.editor.down" : "eplt.editor.up")), x.name, x.completedTranslations, x.totalTranslations, percent}).method_27692(x.selected ? class_124.field_1068 : class_124.field_1080));
                if (j == 4) continue;
                class_52502.method_27693("\n");
            }
        }
        return class_52502;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float tickDelta) {
        if (this.holdingShift != class_437.method_25442()) {
            this.shouldUpdateTooltip = true;
        }
        this.holdingShift = class_437.method_25442();
        this.method_25420(context);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"eplt.editor.search.text"), this.field_22789 / 2, 92, 0xFFFFFF);
        this.searchKey.method_25394(context, mouseX, mouseY, tickDelta);
        this.searchValue.method_25394(context, mouseX, mouseY, tickDelta);
        this.translationKey.method_25394(context, mouseX, mouseY, tickDelta);
        this.translationValue.method_25394(context, mouseX, mouseY, tickDelta);
        this.translationAdd.method_25394(context, mouseX, mouseY, tickDelta);
        this.languageEditorWidget.method_25394(context, mouseX, mouseY, tickDelta);
        this.doneButton.method_25394(context, mouseX, mouseY, tickDelta);
        this.exportButton.method_25394(context, mouseX, mouseY, tickDelta);
        if (this.selectorButton.method_25405((double)mouseX, (double)mouseY) && this.shouldUpdateTooltip) {
            this.updateTooltip();
            this.shouldUpdateTooltip = false;
        }
        this.selectorButton.method_25394(context, mouseX, mouseY, tickDelta);
        this.languageEnabledButton.method_25394(context, mouseX, mouseY, tickDelta);
        super.method_25394(context, mouseX, mouseY, tickDelta);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private record ResultData(class_2561 name, int completedTranslations, int totalTranslations, boolean selected) {
    }
}

