/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.config;

import info.u_team.overworld_mirror.config.CommonConfig;
import info.u_team.u_team_core.util.ConfigValueHolder;
import java.util.function.Supplier;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeoForgeCommonConfig {
    public static final ModConfigSpec CONFIG;
    private static final NeoForgeCommonConfig INSTANCE;
    public final ConfigValueHolder<Double> portalSearchDistanceOverworld;
    public final ConfigValueHolder<Double> portalSearchDistanceOverworldMirror;
    public final ConfigValueHolder<Boolean> seedAddition;
    public final ConfigValueHolder<Long> seed;

    public static NeoForgeCommonConfig getInstance() {
        return INSTANCE;
    }

    private NeoForgeCommonConfig(ModConfigSpec.Builder builder) {
        builder.comment("To configure the dimension and dimension type please create a data pack and add a dimension type in this resource location: data/overworldmirror/dimension_type/overworld_mirror.json and a dimension in this resource location: data/overworldmirror/dimension/overworld.json").push("information");
        builder.define("information", (Object)"");
        builder.pop();
        builder.comment("Portal settings").push("portal");
        ModConfigSpec.DoubleValue portalSearchDistanceOverworldValue = builder.comment("How many blocks the portal can be from the normal spawn location to not create a new one.").defineInRange("portalSearchDistanceOverworld", 30.0, 1.0, 1.0E10);
        this.portalSearchDistanceOverworld = new ConfigValueHolder((Supplier)portalSearchDistanceOverworldValue, arg_0 -> ((ModConfigSpec.DoubleValue)portalSearchDistanceOverworldValue).set(arg_0));
        ModConfigSpec.DoubleValue portalSearchDistanceOverworldMirrorValue = builder.comment("How many blocks the portal can be from the normal spawn location to not create a new one.").defineInRange("portalSearchDistanceOverworldMirror", 30.0, 1.0, 1.0E10);
        this.portalSearchDistanceOverworldMirror = new ConfigValueHolder((Supplier)portalSearchDistanceOverworldMirrorValue, arg_0 -> ((ModConfigSpec.DoubleValue)portalSearchDistanceOverworldMirrorValue).set(arg_0));
        builder.pop();
        builder.comment("Seed settings").push("seed");
        ModConfigSpec.BooleanValue seedAdditionValue = builder.comment("If you have set this false then the seedValue value will be treated as new seed, else the value will be added to the main world seed.").define("seedAddition", true);
        this.seedAddition = new ConfigValueHolder((Supplier)seedAdditionValue, arg_0 -> ((ModConfigSpec.BooleanValue)seedAdditionValue).set(arg_0));
        ModConfigSpec.LongValue seedValue = builder.comment("The seed value. See seedAddition for more information.").defineInRange("seedValue", 100000L, Long.MIN_VALUE, Long.MAX_VALUE);
        this.seed = new ConfigValueHolder((Supplier)seedValue, arg_0 -> ((ModConfigSpec.LongValue)seedValue).set(arg_0));
        builder.pop();
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(NeoForgeCommonConfig::new);
        CONFIG = (ModConfigSpec)pair.getRight();
        INSTANCE = (NeoForgeCommonConfig)pair.getLeft();
    }

    public static class Impl
    extends CommonConfig {
        @Override
        public ConfigValueHolder<Double> portalSearchDistanceOverworld() {
            return NeoForgeCommonConfig.INSTANCE.portalSearchDistanceOverworld;
        }

        @Override
        public ConfigValueHolder<Double> portalSearchDistanceOverworldMirror() {
            return NeoForgeCommonConfig.INSTANCE.portalSearchDistanceOverworldMirror;
        }

        @Override
        public ConfigValueHolder<Boolean> seedAddition() {
            return NeoForgeCommonConfig.INSTANCE.seedAddition;
        }

        @Override
        public ConfigValueHolder<Long> seed() {
            return NeoForgeCommonConfig.INSTANCE.seed;
        }
    }
}

