/*
 * Decompiled with CFR 0.152.
 */
package cinematic.snowstorm.config;

import cinematic.snowstorm.config.SnowfallConfig;
import cinematic.snowstorm.config.SnowfallConfigData;
import cinematic.snowstorm.utils.SnowSpawnManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class SnowfallConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("snowstorm.json");
    private static SnowfallConfigData configData = new SnowfallConfigData();

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                configData = (SnowfallConfigData)GSON.fromJson(json, SnowfallConfigData.class);
                SnowfallConfigManager.applyToRuntime();
                System.out.println("[Snowstorm] Config loaded from " + String.valueOf(CONFIG_PATH));
            }
            catch (IOException e) {
                System.err.println("[Snowstorm] Failed to load config: " + e.getMessage());
                configData = new SnowfallConfigData();
                SnowfallConfigManager.save();
            }
        } else {
            configData = new SnowfallConfigData();
            SnowfallConfigManager.save();
            System.out.println("[Snowstorm] Created default config at " + String.valueOf(CONFIG_PATH));
        }
    }

    public static void save() {
        try {
            SnowfallConfigManager.captureFromRuntime();
            String json = GSON.toJson((Object)configData);
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
            System.out.println("[Snowstorm] Config saved");
        }
        catch (IOException e) {
            System.err.println("[Snowstorm] Failed to save config: " + e.getMessage());
        }
    }

    private static void applyToRuntime() {
        SnowfallConfig.SPAWN_HEIGHT = SnowfallConfigManager.configData.spawnHeight;
        SnowfallConfig.SPAWN_RADIUS = SnowfallConfigManager.configData.spawnRadius;
        SnowfallConfig.FAR_SPAWN_RADIUS = SnowfallConfigManager.configData.farSpawnRadius;
        SnowfallConfig.FAR_SPAWN_CHANCE = SnowfallConfigManager.configData.farSpawnChance;
        SnowfallConfig.PARTICLES_PER_TICK = SnowfallConfigManager.configData.particlesPerTick;
        SnowfallConfig.SPAWN_INTERVAL = SnowfallConfigManager.configData.spawnInterval;
        SnowfallConfig.PLAYER_FOLLOW_STRENGTH = SnowfallConfigManager.configData.playerFollowStrength;
        SnowfallConfig.AIR_DRAG = SnowfallConfigManager.configData.airDrag;
        SnowfallConfig.FALL_SPEED_MIN = SnowfallConfigManager.configData.fallSpeedMin;
        SnowfallConfig.FALL_SPEED_MAX = SnowfallConfigManager.configData.fallSpeedMax;
        SnowfallConfig.SIZE_MIN = SnowfallConfigManager.configData.sizeMin;
        SnowfallConfig.SIZE_MAX = SnowfallConfigManager.configData.sizeMax;
        SnowfallConfig.ALPHA_MIN = SnowfallConfigManager.configData.alphaMin;
        SnowfallConfig.ALPHA_MAX = SnowfallConfigManager.configData.alphaMax;
        SnowfallConfig.SWAY_AMOUNT_MIN = SnowfallConfigManager.configData.swayAmountMin;
        SnowfallConfig.SWAY_AMOUNT_MAX = SnowfallConfigManager.configData.swayAmountMax;
        SnowfallConfig.SWAY_SPEED = SnowfallConfigManager.configData.swaySpeed;
        SnowfallConfig.WIND_MIN = SnowfallConfigManager.configData.windMin;
        SnowfallConfig.WIND_MAX = SnowfallConfigManager.configData.windMax;
        SnowfallConfig.ROTATION_SPEED = SnowfallConfigManager.configData.rotationSpeed;
        SnowfallConfig.ENABLE_WEATHER_SOUND = SnowfallConfigManager.configData.enableWeatherSound;
        SnowfallConfig.MAX_PARTICLE_COUNT = SnowfallConfigManager.configData.maxParticleCount;
    }

    public static void captureFromRuntime() {
        SnowfallConfigManager.configData.spawnHeight = SnowfallConfig.SPAWN_HEIGHT;
        SnowfallConfigManager.configData.spawnRadius = SnowfallConfig.SPAWN_RADIUS;
        SnowfallConfigManager.configData.farSpawnRadius = SnowfallConfig.FAR_SPAWN_RADIUS;
        SnowfallConfigManager.configData.farSpawnChance = SnowfallConfig.FAR_SPAWN_CHANCE;
        SnowfallConfigManager.configData.particlesPerTick = SnowfallConfig.PARTICLES_PER_TICK;
        SnowfallConfigManager.configData.spawnInterval = SnowfallConfig.SPAWN_INTERVAL;
        SnowfallConfigManager.configData.playerFollowStrength = SnowfallConfig.PLAYER_FOLLOW_STRENGTH;
        SnowfallConfigManager.configData.airDrag = SnowfallConfig.AIR_DRAG;
        SnowfallConfigManager.configData.fallSpeedMin = SnowfallConfig.FALL_SPEED_MIN;
        SnowfallConfigManager.configData.fallSpeedMax = SnowfallConfig.FALL_SPEED_MAX;
        SnowfallConfigManager.configData.sizeMin = SnowfallConfig.SIZE_MIN;
        SnowfallConfigManager.configData.sizeMax = SnowfallConfig.SIZE_MAX;
        SnowfallConfigManager.configData.alphaMin = SnowfallConfig.ALPHA_MIN;
        SnowfallConfigManager.configData.alphaMax = SnowfallConfig.ALPHA_MAX;
        SnowfallConfigManager.configData.swayAmountMin = SnowfallConfig.SWAY_AMOUNT_MIN;
        SnowfallConfigManager.configData.swayAmountMax = SnowfallConfig.SWAY_AMOUNT_MAX;
        SnowfallConfigManager.configData.swaySpeed = SnowfallConfig.SWAY_SPEED;
        SnowfallConfigManager.configData.windMin = SnowfallConfig.WIND_MIN;
        SnowfallConfigManager.configData.windMax = SnowfallConfig.WIND_MAX;
        SnowfallConfigManager.configData.rotationSpeed = SnowfallConfig.ROTATION_SPEED;
        SnowfallConfigManager.configData.enableWeatherSound = SnowfallConfig.ENABLE_WEATHER_SOUND;
        SnowfallConfigManager.configData.maxParticleCount = SnowfallConfig.MAX_PARTICLE_COUNT;
    }

    public static void applyAndSave() {
        SnowfallConfigManager.captureFromRuntime();
        SnowfallConfigManager.save();
        SnowSpawnManager.reload();
    }

    public static void applyPreset(Preset preset) {
        switch (preset.ordinal()) {
            case 0: {
                SnowfallConfig.applyLightSnowPreset();
                break;
            }
            case 1: {
                SnowfallConfig.applyBlizzardPreset();
                break;
            }
            case 2: {
                SnowfallConfig.applyMagicalPreset();
                break;
            }
            case 3: {
                SnowfallConfig.applyCinematicPreset();
            }
        }
        SnowfallConfigManager.applyAndSave();
    }

    public static SnowfallConfigData getConfig() {
        SnowfallConfigManager.captureFromRuntime();
        return configData;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Preset {
        LIGHT_SNOW,
        BLIZZARD,
        MAGICAL,
        CINEMATIC;

    }
}

