/*
 * Decompiled with CFR 0.152.
 */
package cinematic.snowstorm.fog;

import cinematic.snowstorm.config.FogConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class WeatherFogHandler {
    private static float currentFogStart = 1.0f;
    private static float currentFogEnd = 1.0f;
    private static float currentSkyFogStart = 1.0f;
    private static float currentSkyFogEnd = 1.0f;
    private static float targetFogStart = 1.0f;
    private static float targetFogEnd = 1.0f;
    private static float targetSkyFogStart = 1.0f;
    private static float targetSkyFogEnd = 1.0f;
    private static final float TRANSITION_SPEED = 0.05f;

    public static void updateFog() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            targetFogStart = 1.0f;
            targetFogEnd = 1.0f;
            targetSkyFogStart = 1.0f;
            targetSkyFogEnd = 1.0f;
            return;
        }
        boolean isRaining = world.method_8419();
        boolean isThundering = world.method_8546();
        if (isThundering && FogConfig.ENABLE_THUNDER_FOG) {
            targetFogStart = FogConfig.THUNDER_FOG_START;
            targetFogEnd = FogConfig.THUNDER_FOG_END;
            targetSkyFogStart = FogConfig.THUNDER_SKY_FOG_START;
            targetSkyFogEnd = FogConfig.THUNDER_SKY_FOG_END;
        } else if (isRaining && FogConfig.ENABLE_RAIN_FOG) {
            targetFogStart = FogConfig.RAIN_FOG_START;
            targetFogEnd = FogConfig.RAIN_FOG_END;
            targetSkyFogStart = FogConfig.RAIN_SKY_FOG_START;
            targetSkyFogEnd = FogConfig.RAIN_SKY_FOG_END;
        } else {
            targetFogStart = 1.0f;
            targetFogEnd = 1.0f;
            targetSkyFogStart = 1.0f;
            targetSkyFogEnd = 1.0f;
        }
        currentFogStart = WeatherFogHandler.lerp(currentFogStart, targetFogStart, 0.05f);
        currentFogEnd = WeatherFogHandler.lerp(currentFogEnd, targetFogEnd, 0.05f);
        currentSkyFogStart = WeatherFogHandler.lerp(currentSkyFogStart, targetSkyFogStart, 0.05f);
        currentSkyFogEnd = WeatherFogHandler.lerp(currentSkyFogEnd, targetSkyFogEnd, 0.05f);
    }

    private static float lerp(float start, float end, float t) {
        return start + (end - start) * t;
    }

    public static float getFogStart() {
        return currentFogStart;
    }

    public static float getFogEnd() {
        return currentFogEnd;
    }

    public static float getSkyFogStart() {
        return currentSkyFogStart;
    }

    public static float getSkyFogEnd() {
        return currentSkyFogEnd;
    }

    public static boolean shouldApplyWeatherFog() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            return false;
        }
        boolean isRaining = world.method_8419();
        boolean isThundering = world.method_8546();
        return isRaining && FogConfig.ENABLE_RAIN_FOG || isThundering && FogConfig.ENABLE_THUNDER_FOG;
    }

    public static float[] getFogColor(boolean isSky) {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        if (world.method_8546() && FogConfig.ENABLE_THUNDER_FOG) {
            if (isSky) {
                return new float[]{FogConfig.THUNDER_SKY_RED, FogConfig.THUNDER_SKY_GREEN, FogConfig.THUNDER_SKY_BLUE};
            }
            return new float[]{FogConfig.THUNDER_FOG_RED, FogConfig.THUNDER_FOG_GREEN, FogConfig.THUNDER_FOG_BLUE};
        }
        if (world.method_8419() && FogConfig.ENABLE_RAIN_FOG) {
            if (isSky) {
                return new float[]{FogConfig.RAIN_SKY_RED, FogConfig.RAIN_SKY_GREEN, FogConfig.RAIN_SKY_BLUE};
            }
            return new float[]{FogConfig.RAIN_FOG_RED, FogConfig.RAIN_FOG_GREEN, FogConfig.RAIN_FOG_BLUE};
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }
}

