/*
 * Decompiled with CFR 0.152.
 */
package cinematic.snowstorm.mixin.client;

import cinematic.snowstorm.fog.WeatherFogHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_758;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_758.class})
public class FogRendererMixin {
    @Inject(method={"method_62185(Lnet/minecraft/class_4184;FLnet/minecraft/class_638;IFZ)Lorg/joml/Vector4f;"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetFogColor(class_4184 camera, float tickProgress, class_638 world, int viewDistance, float skyDarkness, boolean thick, CallbackInfoReturnable<Vector4f> cir) {
        WeatherFogHandler.updateFog();
        if (!WeatherFogHandler.shouldApplyWeatherFog()) {
            return;
        }
        Vector4f currentColor = (Vector4f)cir.getReturnValue();
        float[] fogColor = WeatherFogHandler.getFogColor(false);
        Vector4f newColor = new Vector4f(currentColor.x * fogColor[0], currentColor.y * fogColor[1], currentColor.z * fogColor[2], currentColor.w);
        cir.setReturnValue((Object)newColor);
    }

    @ModifyVariable(method={"method_71110(Ljava/nio/ByteBuffer;ILorg/joml/Vector4f;FFFFFF)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float modifyEnvironmentalStart(float environmentalStart) {
        if (!WeatherFogHandler.shouldApplyWeatherFog()) {
            return environmentalStart;
        }
        return environmentalStart * WeatherFogHandler.getFogStart();
    }

    @ModifyVariable(method={"method_71110(Ljava/nio/ByteBuffer;ILorg/joml/Vector4f;FFFFFF)V"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    private float modifyEnvironmentalEnd(float environmentalEnd) {
        if (!WeatherFogHandler.shouldApplyWeatherFog()) {
            return environmentalEnd;
        }
        return environmentalEnd * WeatherFogHandler.getFogEnd();
    }

    @ModifyVariable(method={"method_71110(Ljava/nio/ByteBuffer;ILorg/joml/Vector4f;FFFFFF)V"}, at=@At(value="HEAD"), ordinal=2, argsOnly=true)
    private float modifyRenderDistanceStart(float renderDistanceStart) {
        if (!WeatherFogHandler.shouldApplyWeatherFog()) {
            return renderDistanceStart;
        }
        return renderDistanceStart * WeatherFogHandler.getFogStart();
    }

    @ModifyVariable(method={"method_71110(Ljava/nio/ByteBuffer;ILorg/joml/Vector4f;FFFFFF)V"}, at=@At(value="HEAD"), ordinal=3, argsOnly=true)
    private float modifyRenderDistanceEnd(float renderDistanceEnd) {
        if (!WeatherFogHandler.shouldApplyWeatherFog()) {
            return renderDistanceEnd;
        }
        return renderDistanceEnd * WeatherFogHandler.getFogEnd();
    }

    @ModifyVariable(method={"method_71110(Ljava/nio/ByteBuffer;ILorg/joml/Vector4f;FFFFFF)V"}, at=@At(value="HEAD"), ordinal=4, argsOnly=true)
    private float modifySkyEnd(float skyEnd) {
        if (!WeatherFogHandler.shouldApplyWeatherFog()) {
            return skyEnd;
        }
        return skyEnd * WeatherFogHandler.getSkyFogEnd();
    }

    @ModifyVariable(method={"method_71110(Ljava/nio/ByteBuffer;ILorg/joml/Vector4f;FFFFFF)V"}, at=@At(value="HEAD"), ordinal=5, argsOnly=true)
    private float modifyCloudEnd(float cloudEnd) {
        if (!WeatherFogHandler.shouldApplyWeatherFog()) {
            return cloudEnd;
        }
        return cloudEnd * WeatherFogHandler.getSkyFogEnd();
    }
}

