/*
 * Decompiled with CFR 0.152.
 */
package cinematic.snowstorm.particle;

import cinematic.snowstorm.config.SnowfallConfig;
import cinematic.snowstorm.utils.SnowSpawnManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class MySnowflakeParticle
extends class_3940 {
    private static final float GRAVITY_MULTIPLIER = 0.008f;
    private static final float FADE_START_RATIO = 0.9f;
    private static float GLOBAL_WIND_ANGLE = 0.0f;
    private final float amplitudeX;
    private final float amplitudeZ;
    private final float seedX;
    private final float seedZ;
    private final float rotationSpeed;
    private float windStrength;
    private final float initialAlpha;

    protected MySnowflakeParticle(class_638 world, double x, double y, double z, double vx, double vy, double vz, class_1058 sprite) {
        super(world, x, y, z, vx, vy, vz, sprite);
        this.amplitudeX = SnowfallConfig.SWAY_AMOUNT_MIN + world.field_9229.method_43057() * (SnowfallConfig.SWAY_AMOUNT_MAX - SnowfallConfig.SWAY_AMOUNT_MIN);
        this.amplitudeZ = SnowfallConfig.SWAY_AMOUNT_MIN + world.field_9229.method_43057() * (SnowfallConfig.SWAY_AMOUNT_MAX - SnowfallConfig.SWAY_AMOUNT_MIN) * 0.7f;
        this.seedX = (float)(world.field_9229.method_43058() * Math.PI * 2.0);
        this.seedZ = (float)(world.field_9229.method_43058() * Math.PI * 2.0);
        this.rotationSpeed = (float)(world.field_9229.method_43058() - (double)0.1f) * SnowfallConfig.ROTATION_SPEED;
        this.windStrength = SnowfallConfig.WIND_MIN + world.field_9229.method_43057() * (SnowfallConfig.WIND_MAX - SnowfallConfig.WIND_MIN);
        this.field_3844 = 0.4f + world.field_9229.method_43057() * 0.15f;
        this.field_17867 = SnowfallConfig.SIZE_MIN + world.field_9229.method_43057() * (SnowfallConfig.SIZE_MAX - SnowfallConfig.SIZE_MIN);
        this.field_3852 = vx + (world.field_9229.method_43058() - 0.5) * 0.015;
        this.field_3850 = vz + (world.field_9229.method_43058() - 0.5) * 0.015;
        this.field_3869 = -((double)SnowfallConfig.FALL_SPEED_MIN + world.field_9229.method_43058() * (double)(SnowfallConfig.FALL_SPEED_MAX - SnowfallConfig.FALL_SPEED_MIN));
        this.field_62636 = this.initialAlpha = SnowfallConfig.ALPHA_MIN + world.field_9229.method_43057() * (SnowfallConfig.ALPHA_MAX - SnowfallConfig.ALPHA_MIN);
        this.field_62633 = 1.0f;
        this.field_62634 = 1.0f;
        this.field_62635 = 1.0f;
        this.field_3847 = 300;
        this.field_3862 = true;
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.field_62638 = this.field_62637;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
            return;
        }
        if ((float)this.field_3866 > (float)this.field_3847 * 0.9f) {
            float fadeProgress = ((float)this.field_3866 - (float)this.field_3847 * 0.9f) / ((float)this.field_3847 * 0.100000024f);
            this.field_62636 = this.initialAlpha * (1.0f - fadeProgress);
        }
        this.field_3869 -= (double)(0.008f * this.field_3844);
        class_243 playerVel = SnowSpawnManager.getPlayerVelocity();
        this.field_3852 += playerVel.field_1352 * (double)SnowfallConfig.PLAYER_FOLLOW_STRENGTH;
        this.field_3850 += playerVel.field_1350 * (double)SnowfallConfig.PLAYER_FOLLOW_STRENGTH;
        float windForceX = (float)Math.cos(GLOBAL_WIND_ANGLE) * this.windStrength * 0.002f;
        float windForceZ = (float)Math.sin(GLOBAL_WIND_ANGLE) * this.windStrength * 0.002f;
        this.field_3852 += (double)windForceX;
        this.field_3850 += (double)windForceZ;
        this.field_3852 *= (double)SnowfallConfig.AIR_DRAG;
        this.field_3850 *= (double)SnowfallConfig.AIR_DRAG;
        float t = (float)this.field_3866 * SnowfallConfig.SWAY_SPEED;
        float sinX = (float)Math.sin(t + this.seedX);
        float cosZ = (float)Math.cos(t * 1.2f + this.seedZ);
        float swayOffsetX = sinX * this.amplitudeX * 0.01f;
        float swayOffsetZ = cosZ * this.amplitudeZ * 0.01f;
        this.method_3069(this.field_3852 + (double)swayOffsetX, this.field_3869, this.field_3850 + (double)swayOffsetZ);
        if (this.field_3845) {
            this.method_3085();
            return;
        }
        this.field_62637 += this.rotationSpeed;
    }

    protected class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62641;
    }

    protected int method_3068(float tint) {
        return 0xF000F0;
    }

    public static void setWindDirection(float angleInRadians) {
        GLOBAL_WIND_ANGLE = angleInRadians;
    }

    public static float getWindDirection() {
        return GLOBAL_WIND_ANGLE;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<class_2400> {
        private final class_4002 sprites;

        public Factory(class_4002 spriteProvider) {
            this.sprites = spriteProvider;
        }

        @Nullable
        public class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double vx, double vy, double vz, class_5819 random) {
            class_1058 sprite = this.sprites.method_18139(random);
            return new MySnowflakeParticle(world, x, y, z, vx, vy, vz, sprite);
        }
    }
}

