/*
 * Decompiled with CFR 0.152.
 */
package cinematic.snowstorm.sounds;

import cinematic.snowstorm.config.SnowfallConfig;
import cinematic.snowstorm.sounds.ModSounds;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

@Environment(value=EnvType.CLIENT)
public class AdvancedWeatherSoundManager {
    private static WeatherSound currentSound = null;
    private static boolean wasRaining = false;
    private static boolean wasThundering = false;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!SnowfallConfig.ENABLE_WEATHER_SOUND || client.field_1687 == null || client.field_1724 == null) {
                AdvancedWeatherSoundManager.stopSound(client);
                return;
            }
            boolean isRaining = client.field_1687.method_8419();
            boolean isThundering = client.field_1687.method_8546();
            if (isRaining && (!wasRaining || isThundering != wasThundering)) {
                AdvancedWeatherSoundManager.stopSound(client);
                AdvancedWeatherSoundManager.startSound(client, isThundering);
            } else if (!isRaining && wasRaining) {
                AdvancedWeatherSoundManager.stopSound(client);
            }
            wasRaining = isRaining;
            wasThundering = isThundering;
        });
    }

    private static void startSound(class_310 client, boolean isThundering) {
        if (currentSound != null) {
            return;
        }
        class_3414 sound = isThundering ? ModSounds.BLIZZARD_HEAVY : ModSounds.BLIZZARD_LIGHT;
        currentSound = new WeatherSound(sound, client);
        client.method_1483().method_4873((class_1113)currentSound);
    }

    private static void stopSound(class_310 client) {
        if (currentSound != null && client.method_1483() != null) {
            currentSound.stopSound();
            client.method_1483().method_4870((class_1113)currentSound);
            currentSound = null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class WeatherSound
    extends class_1101 {
        private final class_310 client;
        private boolean shouldStop = false;
        private float targetVolume = 1.0f;
        private static final float SMOOTHING_FACTOR = 0.1f;

        public WeatherSound(class_3414 sound, class_310 client) {
            super(sound, class_3419.field_15252, class_5819.method_43047());
            this.client = client;
            this.field_5446 = true;
            this.field_5451 = 0;
            this.field_5442 = 1.0f;
            this.field_5441 = 1.0f;
            this.field_5439 = 0.0;
            this.field_5450 = 0.0;
            this.field_5449 = 0.0;
            this.field_18936 = true;
            this.field_5440 = class_1113.class_1114.field_5478;
        }

        public void method_16896() {
            boolean disableSound;
            if (this.shouldStop || this.client.field_1724 == null || this.client.field_1687 == null) {
                this.method_24876();
                return;
            }
            boolean canSeeSky = this.client.field_1687.method_8311(this.client.field_1724.method_24515());
            boolean bl = disableSound = this.client.field_1724.method_24515().method_10264() < 60 && !this.client.field_1687.method_8311(this.client.field_1724.method_24515());
            this.targetVolume = disableSound ? 0.0f : (canSeeSky ? 1.0f : 0.15f);
            this.field_5442 += (this.targetVolume - this.field_5442) * 0.1f;
        }

        public void stopSound() {
            this.shouldStop = true;
        }
    }
}

