/*
 * Decompiled with CFR 0.152.
 */
package cinematic.snowstorm.utils;

import cinematic.snowstorm.config.SnowfallConfig;
import cinematic.snowstorm.particle.ParticleTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class SnowSpawnManager {
    private static int SPAWN_HEIGHT_ABOVE = SnowfallConfig.SPAWN_HEIGHT;
    private static int SPAWN_RADIUS_HORIZONTAL = SnowfallConfig.SPAWN_RADIUS;
    private static int SPAWN_COUNT_PER_TICK = SnowfallConfig.PARTICLES_PER_TICK;
    private static int TICKS_BETWEEN_SPAWN = SnowfallConfig.SPAWN_INTERVAL;
    private static int FAR_SPAWN_RADIUS = SnowfallConfig.FAR_SPAWN_RADIUS;
    private static float FAR_SPAWN_CHANCE = SnowfallConfig.FAR_SPAWN_CHANCE;
    private static class_243 lastPlayerPos = class_243.field_1353;
    private static class_243 playerVelocity = class_243.field_1353;
    private static final float VELOCITY_SMOOTHING = 0.3f;
    private static int tickCounter = 0;
    private static boolean isSnowWeatherActive = false;

    public static void init() {
        ClientTickEvents.END_WORLD_TICK.register(world -> {
            boolean shouldSnow;
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null) {
                return;
            }
            if (!(world instanceof class_638)) {
                return;
            }
            class_243 currentPos = mc.field_1724.method_73189();
            class_243 currentVelocity = currentPos.method_1020(lastPlayerPos);
            playerVelocity = playerVelocity.method_1021((double)0.7f).method_1019(currentVelocity.method_1021((double)0.3f));
            lastPlayerPos = currentPos;
            isSnowWeatherActive = shouldSnow = world.method_8419() || world.method_8546();
            if (shouldSnow) {
                if (++tickCounter < TICKS_BETWEEN_SPAWN) {
                    return;
                }
                tickCounter = 0;
                double px = mc.field_1724.method_23317() + SnowSpawnManager.playerVelocity.field_1352 * 5.0;
                double py = mc.field_1724.method_23318();
                double pz = mc.field_1724.method_23321() + SnowSpawnManager.playerVelocity.field_1350 * 5.0;
                for (int i = 0; i < SPAWN_COUNT_PER_TICK; ++i) {
                    boolean spawnFar = world.field_9229.method_43057() < FAR_SPAWN_CHANCE;
                    int maxRadius = spawnFar ? FAR_SPAWN_RADIUS : SPAWN_RADIUS_HORIZONTAL;
                    double angle = world.field_9229.method_43058() * Math.PI * 2.0;
                    double distance = Math.sqrt(world.field_9229.method_43058()) * (double)maxRadius;
                    double dx = px + Math.cos(angle) * distance;
                    double dz = pz + Math.sin(angle) * distance;
                    int heightVariation = spawnFar ? 25 : 15;
                    double dy = py + (double)SPAWN_HEIGHT_ABOVE + (double)world.field_9229.method_43048(heightVariation);
                    double vx = SnowSpawnManager.playerVelocity.field_1352 * 0.5;
                    double vz = SnowSpawnManager.playerVelocity.field_1350 * 0.5;
                    world.method_17452((class_2394)ParticleTypes.MY_SNOWFLAKE, true, dx, dy, dz, vx, 0.0, vz);
                }
            }
        });
    }

    public static void reload() {
        SnowSpawnManager.loadConfigValues();
        tickCounter = 0;
        lastPlayerPos = class_243.field_1353;
        playerVelocity = class_243.field_1353;
    }

    private static void loadConfigValues() {
        SPAWN_HEIGHT_ABOVE = SnowfallConfig.SPAWN_HEIGHT;
        SPAWN_RADIUS_HORIZONTAL = SnowfallConfig.SPAWN_RADIUS;
        SPAWN_COUNT_PER_TICK = SnowfallConfig.PARTICLES_PER_TICK;
        TICKS_BETWEEN_SPAWN = SnowfallConfig.SPAWN_INTERVAL;
        FAR_SPAWN_RADIUS = SnowfallConfig.FAR_SPAWN_RADIUS;
        FAR_SPAWN_CHANCE = SnowfallConfig.FAR_SPAWN_CHANCE;
    }

    public static boolean isSnowWeatherActive() {
        return isSnowWeatherActive;
    }

    public static class_243 getPlayerVelocity() {
        return playerVelocity;
    }
}

