/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.app.json;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;

public class JsonArray
extends JsonValue<List<JsonValue<?>>> {
    public JsonArray() {
        this.value = new ArrayList();
    }

    public JsonArray(int size) {
        this.value = new ArrayList(size);
    }

    public JsonArray(Object ... elms) {
        this();
        for (Object elm : elms) {
            this.add(new JsonValue<Object>(elm));
        }
    }

    public boolean add(JsonValue<?> elm) {
        return ((List)this.value).add(elm);
    }

    public boolean rem(JsonValue<?> elm) {
        return ((List)this.value).remove(elm);
    }

    public JsonValue<?> get(int index) {
        return (JsonValue)((List)this.value).get(index);
    }

    public JsonArray getArray(int index) {
        return ((JsonValue)((List)this.value).get(index)).asArray();
    }

    public JsonMap getMap(int index) {
        return ((JsonValue)((List)this.value).get(index)).asMap();
    }

    public JsonValue<?> rem(int index) {
        return (JsonValue)((List)this.value).remove(index);
    }

    public JsonValue<?> set(int index, JsonValue<?> elm) {
        return ((List)this.value).set(index, elm);
    }

    public boolean contains(JsonValue<?> val) {
        return ((List)this.value).contains(val);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isValue() {
        return false;
    }

    public boolean add(String val) {
        return this.add(new JsonValue<String>(val));
    }

    public boolean add(byte val) {
        return this.add(new JsonValue<Byte>(val));
    }

    public boolean add(char val) {
        return this.add(new JsonValue<Character>(Character.valueOf(val)));
    }

    public boolean add(short val) {
        return this.add(new JsonValue<Short>(val));
    }

    public boolean add(int val) {
        return this.add(new JsonValue<Integer>(val));
    }

    public boolean add(long val) {
        return this.add(new JsonValue<Long>(val));
    }

    public boolean add(float val) {
        if (val == 0.0f) {
            val = 0.0f;
        }
        return this.add(new JsonValue<Float>(Float.valueOf(val)));
    }

    public boolean add(double val) {
        return this.add(new JsonValue<Double>(val));
    }

    public boolean add(boolean val) {
        return this.add(new JsonValue<Boolean>(val));
    }

    public boolean addArray() {
        return this.add(new JsonArray());
    }

    public boolean addMap() {
        return this.add(new JsonMap());
    }

    public int size() {
        return ((List)this.value).size();
    }

    public boolean empty() {
        return ((List)this.value).size() == 0;
    }

    public boolean not_empty() {
        return ((List)this.value).size() > 0;
    }

    public List<JsonValue<?>> elements() {
        return (List)this.value;
    }

    @Override
    public String toString() {
        return JsonHandler.toString(this);
    }

    public JsonArray copy() {
        JsonArray arr = new JsonArray();
        for (JsonValue<?> elm : this.elements()) {
            arr.add(elm.copy());
        }
        return arr;
    }

    public String[] toStringArray() {
        String[] str = new String[((List)this.value).size()];
        for (int i = 0; i < str.length; ++i) {
            str[i] = ((JsonValue)((List)this.value).get(i)).string_value();
        }
        return str;
    }

    public int[] toIntegerArray() {
        int[] arr = new int[((List)this.value).size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = ((JsonValue)((List)this.value).get(i)).integer_value();
        }
        return arr;
    }

    public float[] toFloatArray() {
        float[] arr = new float[((List)this.value).size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = ((JsonValue)((List)this.value).get(i)).float_value();
        }
        return arr;
    }

    public ArrayList<String> toStringList() {
        ArrayList<String> list = new ArrayList<String>();
        for (JsonValue val : (List)this.value) {
            list.add(val.string_value());
        }
        return list;
    }

    public ArrayList<Integer> toIntegerList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (JsonValue val : (List)this.value) {
            list.add(val.integer_value());
        }
        return list;
    }

    public ArrayList<Float> toFloatList() {
        ArrayList<Float> list = new ArrayList<Float>();
        for (JsonValue val : (List)this.value) {
            list.add(Float.valueOf(val.float_value()));
        }
        return list;
    }

    public static class Flat
    extends JsonArray {
        public Flat() {
        }

        public Flat(int size) {
            super(size);
        }

        public Flat(Object ... elms) {
            super(elms);
        }
    }
}

