/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.math;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.common.math.Vec3f;

public class MV3D
extends V3D {
    public MV3D() {
    }

    public MV3D(double v) {
        super(v, v, v);
    }

    public MV3D(double dx, double dy, double dz) {
        super(dx, dy, dz);
    }

    public MV3D(V3I vector) {
        super(vector.x, vector.y, vector.z);
    }

    public MV3D(V3D vector) {
        super(vector.x, vector.y, vector.z);
    }

    public MV3D(Vec3f vector) {
        super(vector.x, vector.y, vector.z);
    }

    public MV3D(String[] array, int index) {
        super(array, index);
    }

    public MV3D(float[] array, int index) {
        super(array, index);
    }

    @Override
    public V3D sub(V3D vec) {
        return this.sub(vec.x, vec.y, vec.z);
    }

    @Override
    public V3D sub(double x, double y, double z) {
        return this.add(-x, -y, -z);
    }

    @Override
    public V3D add(V3D vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    @Override
    public V3D add(double dx, double dy, double dz) {
        return this.set(this.x + dx, this.y + dy, this.z + dz);
    }

    @Override
    public V3D scale(double scale) {
        return this.set(this.x * scale, this.y * scale, this.z * scale);
    }

    @Override
    public V3D multiply(double by) {
        return this.set(this.x * by, this.y * by, this.z * by);
    }

    @Override
    public V3D divide(double div) {
        return div == 0.0 ? this : this.set(this.x / div, this.y / div, this.z / div);
    }

    @Override
    public String toString() {
        return String.format("MV3D[ %s, %s, %s ]", this.x, this.y, this.z);
    }

    @Override
    public V3D middle(V3D target) {
        return this.set((this.x + target.x) * 0.5, (this.y + target.y) * 0.5, (this.z + target.z) * 0.5);
    }

    @Override
    public V3D cross(V3D vec) {
        return this.set(this.y * vec.z - this.z * vec.y, this.z * vec.x - this.x * vec.z, this.x * vec.y - this.y * vec.x);
    }

    @Override
    public V3D norm() {
        double len = this.length();
        return len < 1.0E-5 ? this.set(0.0, 0.0, 0.0) : this.set(this.x / len, this.y / len, this.z / len);
    }

    @Override
    public MV3D copy() {
        return new MV3D(this.x, this.y, this.z);
    }
}

