/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.network;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.network.Network;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.lib.mc.utils.Static;
import net.fexcraft.mod.uni.EnvInfo;
import net.minecraft.command.ICommandSender;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Deprecated
public class SimpleUpdateHandler {
    private static JsonObject obj = new JsonObject();
    private static HashSet<String> modids = new HashSet();
    private static HashMap<String, String> update_message_queue = new HashMap();
    private static HashMap<String, String> versions = new HashMap();
    private static HashSet<String> mods_to_update = new HashSet();
    private static boolean loaded = false;

    private static void checkForMissingModData() {
        for (String string : modids) {
            JsonObject data;
            if (obj.has(string) || (data = Network.getModData(string)) == null) continue;
            obj.add(string, (JsonElement)data);
        }
    }

    public static void register(String modid, int userid, String current_version) {
        if (Network.isModRegistered(modid)) {
            obj.add(modid, (JsonElement)Network.getModData(modid));
            modids.add(modid);
            versions.put(modid, current_version);
            return;
        }
        Print.log("Tried to register an SimpleUpdateHandler for '" + modid + "', but mod seems not to be registered in the FCL database.");
    }

    public static void postInit() {
        new Thread("FCL-SUH"){

            @Override
            public void run() {
                SimpleUpdateHandler.checkForMissingModData();
                SimpleUpdateHandler.checkIfUpdateAvaible();
                loaded = true;
            }
        }.start();
    }

    private static void checkIfUpdateAvaible() {
        Print.log("Checking for available updates.");
        for (String modid : modids) {
            String latest_version;
            if (!obj.has(modid) || (latest_version = SimpleUpdateHandler.getLatestVersionOf(modid)).equals(versions.get(modid))) continue;
            Print.log("Found update for '" + modid + "'!");
            mods_to_update.add(modid);
        }
        Print.log("Done checking for updates.");
    }

    public static void setUpdateMessage(String modid, String string) {
        update_message_queue.put(modid, string);
    }

    public static boolean loaded() {
        return loaded;
    }

    public static String getLatestVersionOf(String modid) {
        block6: {
            if (obj.has(modid)) {
                try {
                    if (obj.get(modid).getAsJsonObject().has("versions")) {
                        for (JsonElement elm : obj.get(modid).getAsJsonObject().get("versions").getAsJsonArray()) {
                            if (!elm.getAsJsonObject().get("version").getAsString().equals("1.12.2")) continue;
                            return elm.getAsJsonObject().get("latest_version").getAsString();
                        }
                        break block6;
                    }
                    if (obj.get(modid).getAsJsonObject().has("latest_version")) {
                        return obj.get(modid).getAsJsonObject().get("latest_version").getAsString();
                    }
                    return "<< NO VERSION DATA IN OBJ --- CHECK MOD JSON >>";
                }
                catch (Exception ex) {
                    Print.log("-----------------------");
                    Print.log("Malformed Moddata JSON for modid '" + modid + "'!");
                    Print.log(obj.get(modid).toString());
                    Print.log("-----------------------");
                    Static.stop();
                    return "error";
                }
            }
        }
        return "null";
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onJoin(final PlayerEvent.PlayerLoggedInEvent event) {
            new Thread("FCL-SUH"){

                @Override
                public void run() {
                    for (String modid : mods_to_update) {
                        String string = (String)update_message_queue.get(modid);
                        if (string == null || string.length() < 4) continue;
                        if (EnvInfo.DEV) {
                            Print.log(Formatter.format((String)update_message_queue.get(modid)));
                            continue;
                        }
                        Print.chat((ICommandSender)event.player, Formatter.format((String)update_message_queue.get(modid)));
                    }
                }
            }.start();
        }
    }
}

