/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.render;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import net.fexcraft.lib.mc.utils.Print;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ExternalTextureHelper {
    private static final Map<String, ResourceLocation> map = new HashMap<String, ResourceLocation>();

    public static ResourceLocation get(String s) {
        if (map.containsKey(s)) {
            return map.get(s);
        }
        ResourceLocation texture = new ResourceLocation("fcl-url", s);
        Object object = Minecraft.func_71410_x().field_71446_o.func_110581_b(texture);
        if (object == null) {
            SimplerThreadImageDownloader thid = new SimplerThreadImageDownloader(s, texture);
            object = thid;
            Minecraft.func_71410_x().field_71446_o.func_110579_a(texture, object);
        }
        map.put(s, texture);
        return texture;
    }

    public static ResourceLocation get(String s, byte[] arr) {
        if (map.containsKey(s)) {
            if (arr != null) {
                map.remove(s);
            } else {
                return map.get(s);
            }
        }
        if (arr == null) {
            return new ResourceLocation(s);
        }
        ResourceLocation tex = new ResourceLocation(s);
        Minecraft.func_71410_x().field_71446_o.func_147645_c(tex);
        Minecraft.func_71410_x().field_71446_o.func_110579_a(tex, (ITextureObject)new BufferedTextureLoader(tex, arr));
        map.put(s, tex);
        return tex;
    }

    @SideOnly(value=Side.CLIENT)
    public static class BufferedTextureLoader
    extends SimpleTexture {
        private BufferedImage image;
        private byte[] array;
        private boolean uploaded;

        public BufferedTextureLoader(ResourceLocation resloc, byte[] arr) {
            super(resloc);
            this.array = arr;
        }

        private void checkIfUploaded() {
            if (this.uploaded || this.image == null) {
                return;
            }
            if (this.field_110568_b != null) {
                this.func_147631_c();
            }
            TextureUtil.func_110987_a((int)super.func_110552_b(), (BufferedImage)this.image);
            this.uploaded = true;
        }

        public int func_110552_b() {
            this.checkIfUploaded();
            return super.func_110552_b();
        }

        public void func_110551_a(IResourceManager resman) throws IOException {
            this.image = ImageIO.read(new ByteArrayInputStream(this.array));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class SimplerThreadImageDownloader
    extends SimpleTexture {
        private static final AtomicInteger THRID = new AtomicInteger(0);
        private final String url;
        private BufferedImage image;
        private Thread thread;
        private boolean uploaded;

        public SimplerThreadImageDownloader(String imgurl, ResourceLocation resloc) {
            super(resloc);
            this.url = imgurl;
        }

        private void checkIfUploaded() {
            if (this.uploaded || this.image == null) {
                return;
            }
            if (this.field_110568_b != null) {
                this.func_147631_c();
            }
            TextureUtil.func_110987_a((int)super.func_110552_b(), (BufferedImage)this.image);
            this.uploaded = true;
        }

        public int func_110552_b() {
            this.checkIfUploaded();
            return super.func_110552_b();
        }

        public void func_110551_a(IResourceManager resman) throws IOException {
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread(() -> {
                HttpURLConnection conn = null;
                Print.log("Attempting download of texture '" + this.url + "'.");
                try {
                    conn = (HttpURLConnection)new URL(this.url).openConnection(Minecraft.func_71410_x().func_110437_J());
                    conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                    conn.setDoInput(true);
                    conn.setDoOutput(false);
                    conn.connect();
                    if (conn.getResponseCode() == 200) {
                        this.image = TextureUtil.func_177053_a((InputStream)conn.getInputStream());
                        return;
                    }
                    Print.log("Received response code '" + conn.getResponseCode() + "'.");
                }
                catch (Exception e) {
                    Print.log("Errors during download of texture.");
                    e.printStackTrace();
                    return;
                }
                finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            });
            this.thread.setName("FCL TexDL #" + THRID.incrementAndGet());
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }
}

