/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.fexcraft.app.json.FJson;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.Vec3f;
import org.lwjgl.opengl.GL11;

public class Pos {
    public static final Pos NULL = new Pos(0.0f, 0.0f, 0.0f);
    public final float x;
    public final float y;
    public final float z;
    public final float x16;
    public final float y16;
    public final float z16;

    public Pos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.x16 = x * 0.0625f;
        this.y16 = y * 0.0625f;
        this.z16 = z * 0.0625f;
    }

    public Pos(float[] pos) {
        this(pos.length >= 1 ? pos[0] : 0.0f, pos.length >= 2 ? pos[1] : 0.0f, pos.length >= 3 ? pos[2] : 0.0f);
    }

    public Pos(V3D vec) {
        this((float)vec.x / 16.0f, (float)vec.y / 16.0f, (float)vec.z / 16.0f);
    }

    public Pos copy() {
        return new Pos(this.x, this.y, this.z);
    }

    public Pos clone() {
        return this.copy();
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public float to16FloatX() {
        return this.x16;
    }

    public float to16FloatY() {
        return this.y16;
    }

    public float to16FloatZ() {
        return this.z16;
    }

    public JsonElement toJson(boolean asarray) {
        if (asarray) {
            JsonArray array = new JsonArray();
            array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(this.x)));
            array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(this.y)));
            array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(this.z)));
            return array;
        }
        JsonObject obj = new JsonObject();
        obj.addProperty("x", (Number)Float.valueOf(this.x));
        obj.addProperty("y", (Number)Float.valueOf(this.y));
        obj.addProperty("z", (Number)Float.valueOf(this.z));
        return obj;
    }

    public static Pos fromJson(JsonElement elm, boolean wasarray) {
        float z;
        float y;
        float x;
        if (wasarray) {
            JsonArray array = elm.getAsJsonArray();
            x = array.size() > 0 ? array.get(0).getAsFloat() : 0.0f;
            y = array.size() > 1 ? array.get(1).getAsFloat() : 0.0f;
            z = array.size() > 2 ? array.get(2).getAsFloat() : 0.0f;
        } else {
            JsonObject obj = elm.getAsJsonObject();
            x = obj.has("x") ? obj.get("x").getAsFloat() : 0.0f;
            y = obj.has("y") ? obj.get("y").getAsFloat() : 0.0f;
            z = obj.has("z") ? obj.get("z").getAsFloat() : 0.0f;
        }
        return new Pos(x, y, z);
    }

    public FJson asJson(boolean asarray) {
        return asarray ? new net.fexcraft.app.json.JsonArray(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z)) : new JsonMap("x", Float.valueOf(this.x), "y", Float.valueOf(this.y), "z", Float.valueOf(this.z));
    }

    public static Pos frJson(FJson json, boolean wasarray) {
        float z;
        float y;
        float x;
        if (wasarray) {
            net.fexcraft.app.json.JsonArray array = json.asArray();
            x = array.size() > 0 ? array.get(0).float_value() : 0.0f;
            y = array.size() > 1 ? array.get(1).float_value() : 0.0f;
            z = array.size() > 2 ? array.get(2).float_value() : 0.0f;
        } else {
            JsonMap map = json.asMap();
            x = map.getFloat("x", 0.0f);
            y = map.getFloat("y", 0.0f);
            z = map.getFloat("z", 0.0f);
        }
        return new Pos(x, y, z);
    }

    private static String prefix(String prefix) {
        return prefix == null ? "" : prefix + "_";
    }

    public void translate() {
        GL11.glTranslatef((float)this.x16, (float)this.y16, (float)this.z16);
    }

    public void translateR() {
        GL11.glTranslatef((float)(-this.x16), (float)(-this.y16), (float)(-this.z16));
    }

    public Vec3f to16Float() {
        return new Vec3f(this.x16, this.y16, this.z16);
    }

    public Pos add(Pos pos) {
        return new Pos(this.x + pos.x, this.y + pos.y, this.z + pos.z);
    }

    public Pos sub(Pos pos) {
        return new Pos(this.x - pos.x, this.y - pos.y, this.z - pos.z);
    }

    public V3D toV3D() {
        return new V3D(this.x16, this.y16, this.z16);
    }
}

