/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.impl;

import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniFluidTank;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.lang3.tuple.Pair;

public class UniFluidTank12
extends UniFluidTank {
    private FluidTank tank;

    public UniFluidTank12(int capacity) {
        this.tank = new FluidTank(capacity);
    }

    @Override
    public int capacity() {
        return this.tank.getCapacity();
    }

    @Override
    public TagCW save() {
        TagCW tag = TagCW.create();
        this.tank.writeToNBT((NBTTagCompound)tag.local());
        return tag;
    }

    @Override
    public void load(TagCW com) {
        this.tank.readFromNBT((NBTTagCompound)com.local());
    }

    @Override
    public <T> T local() {
        return (T)this.tank;
    }

    @Override
    public int amount() {
        return this.tank.getFluidAmount();
    }

    @Override
    public void amount(String type, int am) {
        this.clear();
        Fluid fluid = FluidRegistry.getFluid((String)type);
        if (fluid == null) {
            return;
        }
        this.tank.fill(new FluidStack(fluid, am), true);
    }

    @Override
    public void drain(int am, boolean con) {
        this.tank.drain(am, con);
    }

    @Override
    public void fill(int am, boolean con) {
        FluidStack stack = this.tank.getFluid().copy();
        stack.amount = am;
        this.tank.fill(stack, con);
    }

    @Override
    public String getFluid() {
        if (this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null) {
            return "null";
        }
        return this.tank.getFluid().getFluid().getName();
    }

    @Override
    public String getFluidFromStack(StackWrapper sw) {
        ItemStack stack = (ItemStack)sw.local();
        if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return null;
        }
        IFluidHandlerItem item = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (item.getTankProperties().length > 0 && item.getTankProperties()[0].getContents() != null) {
            return item.getTankProperties()[0].getContents().getFluid().getName();
        }
        return null;
    }

    @Override
    public Pair<StackWrapper, Boolean> drainFrom(StackWrapper stack, int amount) {
        if (stack.empty() || !((ItemStack)stack.direct()).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return Pair.of((Object)stack, (Object)false);
        }
        IFluidHandlerItem item = (IFluidHandlerItem)((ItemStack)stack.direct()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (item.getTankProperties().length > 0 && item.getTankProperties()[0].getContents() != null && item.getTankProperties()[0].getContents().amount > 0) {
            FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)((ItemStack)stack.local()), (IFluidHandler)this.tank, (int)amount, null, (boolean)true);
            return Pair.of((Object)(result.getResult() == null ? StackWrapper.EMPTY : UniStack.getStack(result.getResult())), (Object)result.success);
        }
        return Pair.of((Object)stack, (Object)false);
    }

    @Override
    public void clear() {
        if (this.tank.getFluidAmount() > 0) {
            this.tank.drain(this.tank.getFluidAmount(), true);
        }
    }
}

