/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.inv;

import java.util.ArrayList;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import org.apache.commons.lang3.tuple.Pair;

public abstract class UniFluidTank {
    public static Class<? extends UniFluidTank> IMPL = null;
    protected ArrayList<UniFluidValidator> validators = new ArrayList();
    protected String name = "Universal Tank";

    public static UniFluidTank create(int capacity) {
        try {
            return IMPL.getConstructor(Integer.TYPE).newInstance(capacity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public UniFluidTank name(String str) {
        this.name = str;
        return this;
    }

    public void addValidator(UniFluidValidator val) {
        this.validators.add(val);
    }

    public String name() {
        return this.name;
    }

    public abstract int capacity();

    public abstract TagCW save();

    public abstract void load(TagCW var1);

    public abstract <T> T local();

    public boolean isValid(StackWrapper stack) {
        boolean result = true;
        for (UniFluidValidator validator : this.validators) {
            if (validator.isValid(stack)) continue;
            result = false;
        }
        return result;
    }

    public abstract int amount();

    public abstract void amount(String var1, int var2);

    public abstract void drain(int var1, boolean var2);

    public abstract void fill(int var1, boolean var2);

    public abstract String getFluid();

    public abstract String getFluidFromStack(StackWrapper var1);

    public abstract Pair<StackWrapper, Boolean> drainFrom(StackWrapper var1, int var2);

    public abstract void clear();

    public String toString() {
        return "UniFluidTank[" + this.name + "]";
    }

    public static interface UniFluidValidator {
        public boolean isValid(StackWrapper var1);
    }
}

