/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.render.ExternalTextureHelper;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.impl.ResLoc;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIElement;
import net.fexcraft.mod.uni.ui.UIField;
import net.fexcraft.mod.uni.ui.UIKey;
import net.fexcraft.mod.uni.ui.UITab;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UUIField;
import net.fexcraft.mod.uni.ui.UniCon;
import net.fexcraft.mod.uni.ui.UserInterface;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class UniUI
extends GuiContainer {
    protected ArrayList<String> tooltip = new ArrayList();
    protected ArrayList<UITab> tabs = new ArrayList();
    protected UniCon container;
    protected UserInterface ui;

    public UniUI(UserInterface ui, UIKey key, UniCon con, EntityPlayer player) {
        super((Container)(con == null ? (con = new UniCon(ui.container, key, player)) : con));
        this.ui = ui;
        ui.root = this;
        this.container = con;
        this.container.setup(this);
        this.field_146999_f = ui.width;
        this.field_147000_g = ui.height;
        ui.drawer = new UserInterface.Drawer(){

            @Override
            public void draw(float x, float y, int u, int v, int w, int h) {
                UniUI.this.func_73729_b((int)x, (int)y, u, v, w, h);
            }

            @Override
            public void drawFull(float x, float y, int w, int h) {
                Gui.func_146110_a((int)((int)x), (int)((int)y), (float)0.0f, (float)0.0f, (int)w, (int)h, (float)w, (float)h);
            }

            @Override
            public void draw(int x, int y, StackWrapper stack, boolean text) {
                RenderHelper.func_74520_c();
                UniUI.this.field_146296_j.func_180450_b((ItemStack)stack.local(), x, y);
                if (text) {
                    UniUI.this.field_146296_j.func_180453_a(UniUI.this.field_146289_q, (ItemStack)stack.local(), x, y, null);
                }
            }

            @Override
            public void bind(IDL texture) {
                if (texture.local() == null) {
                    return;
                }
                UniUI.this.field_146297_k.func_110434_K().func_110577_a((ResourceLocation)texture.local());
            }

            @Override
            public void apply(RGB color) {
                color.glColorApply();
            }

            @Override
            public String translate(String str, Object ... args) {
                return Formatter.format(I18n.func_135052_a((String)str, (Object[])args));
            }

            @Override
            public IDL loadExternal(String urltex) {
                return new ResLoc(ExternalTextureHelper.get(urltex).toString());
            }

            @Override
            public void drawLine(double sx, double sy, double ex, double ey, float[] color) {
                Tessellator.func_178181_a().func_178180_c().func_181668_a(3, DefaultVertexFormats.field_181706_f);
                Tessellator.func_178181_a().func_178180_c().func_181662_b(sx, sy, (double)(UniUI.this.field_73735_i + 1.0f)).func_181666_a(color[0], color[1], color[2], 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_178180_c().func_181662_b(ex, ey, (double)(UniUI.this.field_73735_i + 1.0f)).func_181666_a(color[0], color[1], color[2], 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
            }
        };
    }

    public UniUI(UserInterface ui, UIKey key, EntityPlayer player) {
        this(ui, key, null, player);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.ui.screen_width = this.field_146294_l;
        this.ui.screen_height = this.field_146295_m;
        this.ui.gLeft = this.field_147003_i;
        this.ui.gTop = this.field_147009_r;
        this.ui.init();
    }

    protected void func_146976_a(float ticks, int mx, int my) {
        if (this.ui.background) {
            super.func_146276_q_();
        }
        this.predraw(ticks, mx, my);
        this.drawbackground(ticks, mx, my);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (UITab tab : this.ui.tabs.values()) {
            if (!tab.visible()) continue;
            this.bindTexture(tab.texture);
            tab.buttons.forEach((key, button) -> {
                button.hovered(this.field_147003_i, this.field_147009_r, mx, my);
                button.draw((Object)this, null, ticks, this.field_147003_i, this.field_147009_r, mx, my);
            });
            tab.buttons.forEach((key, button) -> {
                if (button.text != null) {
                    button.text.draw((Object)this, (UIElement)button, ticks, this.field_147003_i, this.field_147009_r, mx, my);
                }
            });
            tab.texts.forEach((key, text) -> text.draw((Object)this, null, ticks, this.field_147003_i, this.field_147009_r, mx, my));
            tab.fields.forEach((key, field) -> field.draw((Object)this, null, ticks, this.field_147003_i, this.field_147009_r, mx, my));
        }
        this.postdraw(ticks, mx, my);
    }

    protected void predraw(float ticks, int mx, int my) {
        this.ui.predraw(ticks, mx, my);
    }

    public void drawbackground(float ticks, int mx, int my) {
        for (UITab tab : this.ui.tabs.values()) {
            int tx;
            if (!tab.visible()) continue;
            int n = tab.enabled() ? (tab.hovered() ? tab.htx : tab.tx) : (tx = tab.dtx);
            int ty = tab.enabled() ? (tab.hovered() ? tab.hty : tab.ty) : tab.dty;
            this.bindTexture(tab.texture);
            if (tab.absolute) {
                this.func_73729_b(tab.x < 0 ? this.field_146294_l + tab.x : tab.x, tab.y < 0 ? this.field_146295_m + tab.y : tab.y, tx, ty, tab.width, tab.height);
                continue;
            }
            this.func_73729_b(this.field_147003_i + tab.x, this.field_147009_r + tab.y, tx, ty, tab.width, tab.height);
        }
        this.ui.drawbackground(ticks, mx, my);
    }

    protected void postdraw(float ticks, int mx, int my) {
        this.ui.postdraw(ticks, mx, my);
        this.tooltip.clear();
        this.ui.getTooltip(mx, my, this.tooltip);
        for (UITab tab : this.ui.tabs.values()) {
            if (!tab.visible()) continue;
            for (UIButton button : tab.buttons.values()) {
                if (!button.visible() || button.tooltip == null || !button.hovered()) continue;
                this.tooltip.add(button.tooltip);
            }
        }
        if (this.tooltip.size() > 0) {
            this.func_146283_a(this.tooltip, mx, my);
        }
    }

    protected void func_73864_a(int mx, int my, int mb) throws IOException {
        if (this.ui.onClick(mx, my, mb)) {
            return;
        }
        super.func_73864_a(mx, my, mb);
    }

    protected void func_73869_a(char c, int code) throws IOException {
        boolean invbutton = this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(code);
        boolean keytyped = false;
        for (UITab tab : this.ui.tabs.values()) {
            if (!tab.visible() || tab.fields.isEmpty()) continue;
            boolean bool = false;
            for (UIField field : tab.fields.values()) {
                if (bool) break;
                if (!field.visible() || !field.keytyped(c, code)) continue;
                bool = true;
            }
            if (!bool && !invbutton) {
                super.func_73869_a(c, code);
                continue;
            }
            keytyped = true;
        }
        if (!keytyped) {
            keytyped = this.ui.keytyped(c, code);
        }
        if (!keytyped && code == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int e = Mouse.getEventDWheel();
        if (e == 0) {
            return;
        }
        int am = e > 0 ? -1 : 1;
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        boolean exit = false;
        this.tabs.clear();
        this.tabs.addAll(this.ui.tabs.values());
        block0: for (UITab tab : this.tabs) {
            if (!tab.visible()) continue;
            for (Map.Entry<String, UIButton> entry : tab.buttons.entrySet()) {
                if (exit) break;
                if (!entry.getValue().hovered(this.field_147003_i, this.field_147009_r, x, y)) continue;
                exit = entry.getValue().onscroll(this.field_147003_i, this.field_147009_r, x, y, am) || this.ui.onScroll(entry.getValue(), entry.getKey(), x, y, am);
            }
            for (UIText text : tab.texts.values()) {
                if (exit) continue block0;
                if (!text.hovered(this.field_147003_i, this.field_147009_r, x, y)) continue;
                exit = text.onscroll(this.field_147003_i, this.field_147009_r, x, y, am);
            }
        }
        if (!exit) {
            this.scrollwheel(am, x, y);
        }
    }

    public void scrollwheel(int am, int x, int y) {
        this.ui.scrollwheel(am, x, y);
    }

    public void bindTexture(IDL texture) {
        this.field_146297_k.field_71446_o.func_110577_a((ResourceLocation)texture);
    }

    public void initField(UIField field) {
        GuiTextField gfield = ((UUIField)field).field;
        gfield.field_146218_h = field.width;
        gfield.field_146219_i = field.height;
        gfield.field_146209_f = field.x;
        gfield.field_146210_g = field.y;
        gfield.func_146185_a(field.background);
    }

    public String getClipboard() {
        try {
            Clipboard cp = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable data = cp.getContents(null);
            if (!data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return "";
            }
            return data.getTransferData(DataFlavor.stringFlavor).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setClipboard(String str) {
        try {
            Clipboard cp = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection sel = new StringSelection(str);
            cp.setContents(sel, new StringSelection("fvtm:sign"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

