/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.world;

import net.fexcraft.mod.uni.world.WrapperHolder;

public enum CubeSide {
    UP,
    DOWN,
    NORTH,
    EAST,
    SOUTH,
    WEST;


    public static CubeSide fromIndex(int idx, CubeSide def) {
        switch (idx) {
            case 0: {
                return DOWN;
            }
            case 1: {
                return UP;
            }
            case 2: {
                return NORTH;
            }
            case 3: {
                return SOUTH;
            }
            case 4: {
                return WEST;
            }
            case 5: {
                return EAST;
            }
        }
        return def == null ? NORTH : def;
    }

    public static CubeSide fromIndex(int idx) {
        return CubeSide.fromIndex(idx, null);
    }

    public boolean negative() {
        return this.ordinal() % 2 == 0;
    }

    public boolean positive() {
        return this.ordinal() % 2 == 1;
    }

    public Axe axe() {
        return this.ordinal() < 2 ? Axe.Y : (this.ordinal() < 4 ? Axe.Z : Axe.X);
    }

    public CubeSide rotate() {
        if (this.ordinal() < 2) {
            return this;
        }
        int ord = this.ordinal() + 1;
        if (ord >= 6) {
            ord = 2;
        }
        return CubeSide.values()[ord];
    }

    public CubeSide rotateCC() {
        if (this.ordinal() < 2) {
            return this;
        }
        int ord = this.ordinal() - 1;
        if (ord <= 1) {
            ord = 5;
        }
        return CubeSide.values()[ord];
    }

    public <L> L local() {
        return (L)WrapperHolder.getLocalSide(this);
    }

    public static enum Axe {
        X,
        Y,
        Z;

    }
}

