/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.UniReg;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.ui.UIKey;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class EntityWI
implements EntityW {
    protected Entity entity;
    protected WorldW world;
    protected V3D pos = new V3D();
    protected V3D prev = new V3D();

    public EntityWI(Entity ent) {
        this.entity = ent;
        this.world = WrapperHolder.getWorld(ent.field_70170_p);
    }

    @Override
    public boolean isOnClient() {
        return this.entity.field_70170_p.field_72995_K;
    }

    @Override
    public int getId() {
        return this.entity.func_145782_y();
    }

    @Override
    public WorldW getWorld() {
        if (this.entity.field_70170_p != this.world.direct()) {
            this.world = WrapperHolder.getWorld(this.entity.field_70170_p);
        }
        return this.world;
    }

    @Override
    public boolean isPlayer() {
        return this.entity instanceof EntityPlayer;
    }

    @Override
    public boolean isAnimal() {
        return this.entity instanceof EntityAnimal;
    }

    @Override
    public boolean isHostile() {
        return this.entity instanceof EntityMob;
    }

    @Override
    public boolean isLiving() {
        return this.entity instanceof EntityLiving;
    }

    @Override
    public boolean isRiding() {
        return this.entity.func_184218_aH();
    }

    @Override
    public String getRegName() {
        EntityEntry entry = EntityRegistry.getEntry(this.entity.getClass());
        return entry == null ? "minecraft:null" : entry.getRegistryName().toString();
    }

    @Override
    public void decreaseXZMotion(double x) {
        this.entity.field_70159_w *= x;
        this.entity.field_70179_y *= x;
    }

    @Override
    public void setYawPitch(float oyaw, float opitch, float yaw, float pitch) {
        this.entity.field_70126_B = oyaw;
        this.entity.field_70127_C = opitch;
        this.entity.field_70177_z = yaw;
        this.entity.field_70125_A = pitch;
    }

    @Override
    public void openUI(String id, V3I pos) {
        this.openUI(UIKey.find(id), pos);
    }

    @Override
    public void openUI(UIKey key, V3I pos) {
        if (key == null || !(this.entity instanceof EntityPlayer)) {
            return;
        }
        ((EntityPlayer)this.entity).openGui(UniReg.getInst(key), key.id, (World)this.world.local(), pos.x, pos.y, pos.z);
    }

    @Override
    public String getName() {
        return this.entity instanceof EntityPlayer ? ((EntityPlayer)this.entity).func_146103_bH().getName() : this.entity.func_70005_c_();
    }

    @Override
    public void drop(StackWrapper stack, float height) {
        this.entity.func_70099_a((ItemStack)stack.local(), height);
    }

    @Override
    public boolean isCreative() {
        return this.entity instanceof EntityPlayer && ((EntityPlayer)this.entity).field_71075_bZ.field_75098_d;
    }

    @Override
    public UUID getUUID() {
        return this.entity instanceof EntityPlayer ? ((EntityPlayer)this.entity).func_146103_bH().getId() : this.entity.func_110124_au();
    }

    @Override
    public StackWrapper getHeldItem(boolean main) {
        return this.entity instanceof EntityPlayer ? UniStack.getStack(((EntityPlayer)this.entity).func_184586_b(main ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND)) : StackWrapper.EMPTY;
    }

    @Override
    public void closeUI() {
        ((EntityPlayer)this.entity).func_71053_j();
    }

    @Override
    public int getInventorySize() {
        if (!this.isPlayer()) {
            return 0;
        }
        return ((EntityPlayer)this.entity).field_71071_by.field_70462_a.size();
    }

    @Override
    public StackWrapper getStackAt(int idx) {
        return UniStack.getStack(((EntityPlayer)this.entity).field_71071_by.field_70462_a.get(idx));
    }

    @Override
    public void addStack(StackWrapper stack) {
        ((EntityPlayer)this.entity).func_191521_c((ItemStack)stack.local());
    }

    @Override
    public <E> E local() {
        return (E)this.entity;
    }

    @Override
    public Object direct() {
        return this.entity;
    }

    @Override
    public V3D getPos() {
        this.pos.x = this.entity.field_70165_t;
        this.pos.y = this.entity.field_70163_u;
        this.pos.z = this.entity.field_70161_v;
        return this.pos;
    }

    @Override
    public void setPos(V3D pos) {
        this.entity.func_70107_b(pos.x, pos.y, pos.z);
    }

    @Override
    public V3D getPrevPos() {
        this.prev.x = this.entity.field_70169_q;
        this.prev.y = this.entity.field_70167_r;
        this.prev.z = this.entity.field_70166_s;
        return this.prev;
    }

    @Override
    public void setPrevPos(V3D pos) {
        this.entity.field_70169_q = pos.x;
        this.entity.field_70167_r = pos.y;
        this.entity.field_70166_s = pos.z;
    }

    @Override
    public V3I getV3I() {
        return new V3I((int)this.entity.field_70165_t, (int)this.entity.field_70163_u, (int)this.entity.field_70161_v);
    }

    @Override
    public void send(String s) {
        this.entity.func_145747_a((ITextComponent)new TextComponentString(Formatter.format(I18n.func_74838_a((String)s))));
    }

    @Override
    public void send(String str, Object ... args) {
        this.entity.func_145747_a((ITextComponent)new TextComponentString(Formatter.format(I18n.func_74837_a((String)str, (Object[])args))));
    }

    @Override
    public void sendLink(String url) {
        TextComponentString text = new TextComponentString(url);
        text.func_150255_a(new Style().func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url)));
        this.entity.func_145747_a((ITextComponent)text);
    }

    @Override
    public void bar(String s) {
        if (this.entity instanceof EntityPlayer) {
            ((EntityPlayer)this.entity.func_174793_f()).func_146105_b((ITextComponent)new TextComponentString(Formatter.format(I18n.func_74838_a((String)s))), true);
        } else {
            this.entity.func_145747_a((ITextComponent)new TextComponentString(Formatter.format(s)));
        }
    }

    @Override
    public void bar(String s, Object ... objs) {
        if (this.entity instanceof EntityPlayer) {
            ((EntityPlayer)this.entity.func_174793_f()).func_146105_b((ITextComponent)new TextComponentString(Formatter.format(I18n.func_74837_a((String)s, (Object[])objs))), true);
        } else {
            this.entity.func_145747_a((ITextComponent)new TextComponentTranslation(s, new Object[0]));
        }
    }

    @Override
    public void mount(EntityW veh) {
        this.entity.func_184205_a((Entity)veh.local(), true);
    }

    @Override
    public void dismount(V3D pos) {
        this.entity.func_184210_p();
        this.entity.func_70634_a(pos.x, pos.y, pos.z);
    }

    @Override
    public boolean inSimRange() {
        return true;
    }

    @Override
    public int getTicks() {
        return this.entity.field_70173_aa;
    }

    @Override
    public int pushTicks() {
        return this.entity.field_70173_aa++;
    }

    @Override
    public EntityW getVehicle() {
        return UniEntity.getEntityN(this.entity.func_184187_bx());
    }

    @Override
    public Object getVehicleDirect() {
        return this.entity.func_184187_bx();
    }

    @Override
    public void setLeash(EntityW player, boolean attach) {
        if (!this.isLiving()) {
            return;
        }
        EntityLiving ent = (EntityLiving)this.entity;
        if (attach) {
            ent.func_110162_b((Entity)player.local(), true);
        } else {
            ent.func_110160_i(true, !player.isCreative());
        }
    }

    @Override
    public EntityW getLeash() {
        if (!this.isLiving()) {
            return null;
        }
        EntityLiving ent = (EntityLiving)this.entity;
        return UniEntity.getEntityN(ent.func_110166_bE());
    }

    @Override
    public void move(V3D move) {
        this.entity.func_70091_d(MoverType.SELF, move.x, move.y, move.z);
    }

    @Override
    public void breakBlockAt(V3D pos) {
        if (this.entity.field_70170_p.field_72995_K || !this.isPlayer()) {
            return;
        }
        ((EntityPlayerMP)this.entity).field_71134_c.func_180237_b(new BlockPos(pos.x, pos.y, pos.z));
    }

    @Override
    public V3D getEyeVec() {
        Vec3d vec = Minecraft.func_71410_x().func_175606_aa().func_174824_e(Minecraft.func_71410_x().func_184121_ak());
        return new V3D(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    @Override
    public V3D getLookVec() {
        Vec3d vec = Minecraft.func_71410_x().func_175606_aa().func_70676_i(Minecraft.func_71410_x().func_184121_ak());
        return new V3D(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    @Override
    public boolean isShiftDown() {
        return this.entity.func_70093_af();
    }

    @Override
    public void playSound(Object event, float volume, float pitch) {
        this.entity.func_184185_a((SoundEvent)event, volume, pitch);
    }

    @Override
    public void remove() {
        this.entity.func_70106_y();
    }

    @Override
    public boolean isRemoved() {
        return this.entity.field_70128_L;
    }

    @Override
    public void setOnGround(boolean bool) {
        this.entity.field_70122_E = bool;
    }

    @Override
    public List<StackWrapper> copyInventory() {
        if (!this.isPlayer()) {
            return Collections.emptyList();
        }
        ArrayList<StackWrapper> stacks = new ArrayList<StackWrapper>();
        for (ItemStack stack : ((EntityPlayer)this.entity).field_71071_by.field_70462_a) {
            if (stack.func_190926_b()) continue;
            stacks.add(UniStack.createStack(stack.func_77946_l()));
        }
        return stacks;
    }
}

