/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.world;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.StateWrapper;
import net.fexcraft.mod.uni.world.WorldType;
import net.fexcraft.mod.uni.world.WorldW;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldWI
extends WorldW {
    protected BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
    protected WorldType type;
    protected World world;

    public WorldWI(World level) {
        this.world = level;
        this.type = new WorldType(this.world.field_73011_w.getDimension(), level.field_72995_K);
    }

    @Override
    public boolean isClient() {
        return this.world.field_72995_K;
    }

    @Override
    public boolean isTilePresent(V3I pos) {
        return this.world.func_175625_s(new BlockPos(pos.x, pos.y, pos.z)) != null;
    }

    @Override
    public Object getBlockEntity(V3I pos) {
        return this.world.func_175625_s(new BlockPos(pos.x, pos.y, pos.z));
    }

    @Override
    public <W> W local() {
        return (W)this.world;
    }

    @Override
    public Object direct() {
        return this.world;
    }

    @Override
    public WorldType type() {
        return this.type;
    }

    @Override
    public void setBlockState(V3I pos, StateWrapper state, int flag) {
        this.world.func_180501_a(new BlockPos(pos.x, pos.y, pos.z), (IBlockState)state.local(), flag);
    }

    @Override
    public void spawnBlockSeat(V3D vec, EntityW player) {
    }

    @Override
    public void drop(StackWrapper stack, V3D vec) {
        EntityItem item = new EntityItem(this.world);
        item.func_70107_b(vec.x, vec.y, vec.z);
        item.func_92058_a((ItemStack)stack.local());
        this.world.func_72838_d((Entity)item);
    }

    @Override
    public StateWrapper getStateAt(V3I pos) {
        return StateWrapper.of(this.world.func_180495_p(new BlockPos(pos.x, pos.y, pos.z)));
    }

    @Override
    public List<EntityW> getPlayers() {
        ArrayList<EntityW> list = new ArrayList<EntityW>();
        for (EntityPlayer ent : this.world.field_73010_i) {
            list.add(UniEntity.getEntity(ent));
        }
        return list;
    }

    @Override
    public boolean isPositionLoaded(V3I pos) {
        return this.world.func_175667_e((BlockPos)this.mpos.func_181079_c(pos.x, pos.y, pos.z));
    }

    @Override
    public EntityW getEntity(int id) {
        Entity ent = this.world.func_73045_a(id);
        return ent == null ? null : UniEntity.getEntityN(ent);
    }

    @Override
    public UniEntity getUniEntity(int id) {
        Entity ent = this.world.func_73045_a(id);
        return ent == null ? null : UniEntity.get(ent);
    }

    @Override
    public long getDayTime() {
        return this.world.func_72820_D();
    }

    @Override
    public List<EntityW> getEntities(V3D pos, double range) {
        ArrayList<EntityW> list = new ArrayList<EntityW>();
        AxisAlignedBB aabb = new AxisAlignedBB(pos.x - range, pos.y - range, pos.z - range, pos.x + range, pos.y + range, pos.z + range);
        for (Entity entity : this.world.field_72996_f) {
            if (!entity.func_174813_aQ().func_72326_a(aabb)) continue;
            list.add(UniEntity.getEntityN(entity));
        }
        return list;
    }

    @Override
    public boolean isRainingAt(double x, double y, double z) {
        return this.world.func_175727_C((BlockPos)this.mpos.func_189532_c(x, y, z));
    }
}

