/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.UUID;
import net.fexcraft.lib.common.utils.Print;

@Deprecated
public class JsonUtil {
    private static final JsonUtil instance = new JsonUtil();
    private static final JsonParser parser = new JsonParser();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static JsonParser getParser() {
        return parser;
    }

    public static Gson getGson() {
        return gson;
    }

    public static JsonObject getObjectFromString(String string) {
        JsonElement elm = JsonUtil.getFromString(string);
        if (elm == null) {
            return new JsonObject();
        }
        return elm.getAsJsonObject();
    }

    public static JsonElement getFromString(String string, boolean b) {
        if (string == null) {
            return null;
        }
        try {
            return parser.parse(string);
        }
        catch (Exception e) {
            if (b) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static JsonElement getFromString(String string) {
        return JsonUtil.getFromString(string, true);
    }

    public static void addToArrayIfNotContains(JsonArray array, String string) {
        boolean contains = false;
        for (JsonElement elm : array) {
            if (!elm.getAsString().equals(string)) continue;
            contains = true;
            break;
        }
        if (!contains) {
            array.add((JsonElement)new JsonPrimitive(string));
        }
    }

    public static JsonObject getJsonForPacket(String target) {
        JsonObject obj = new JsonObject();
        obj.addProperty("target_listener", target);
        return obj;
    }

    public static JsonElement read(File file, boolean print_err) {
        return JsonUtil.read(file, print_err, null);
    }

    public static JsonElement read(File file, boolean print_err, JsonElement def) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileReader fr = new FileReader(file);
            JsonElement obj = parser.parse((Reader)fr);
            fr.close();
            return obj;
        }
        catch (Exception e) {
            if (print_err) {
                e.printStackTrace();
            }
            Print.console("File '" + String.valueOf(file) + "' seems to be missing, or has invalid format.");
            return def;
        }
    }

    public static JsonObject get(File file) {
        JsonElement e = JsonUtil.read(file, false);
        if (e == null || !e.isJsonObject()) {
            return new JsonObject();
        }
        return e.getAsJsonObject();
    }

    public static void write(File file, JsonElement obj, boolean check) {
        try {
            if (check && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileWriter fw = new FileWriter(file);
            fw.write(gson.toJson(obj));
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void write(File file, JsonElement obj) {
        JsonUtil.write(file, obj, false);
    }

    public static void update(File file, String string, String value) {
        JsonObject obj = JsonUtil.get(file);
        obj.addProperty(string, value);
        JsonUtil.write(file, (JsonElement)obj);
    }

    public static void update(File file, String string, boolean value) {
        JsonObject obj = JsonUtil.get(file);
        obj.addProperty(string, Boolean.valueOf(value));
        JsonUtil.write(file, (JsonElement)obj);
    }

    public static void update(File file, String string, Number value) {
        JsonObject obj = JsonUtil.get(file);
        obj.addProperty(string, value);
        JsonUtil.write(file, (JsonElement)obj);
    }

    public static void update(File file, String string, JsonElement element) {
        JsonObject obj = JsonUtil.get(file);
        obj.add(string, element);
        JsonUtil.write(file, (JsonElement)obj);
    }

    public static String getIfExists(JsonObject obj, String target, Object default_value) {
        if (!obj.has(target)) {
            obj.addProperty(target, default_value.toString());
            return default_value.toString();
        }
        return obj.get(target).getAsString();
    }

    public static Number getIfExists(JsonObject obj, String target, Number default_value) {
        if (!obj.has(target)) {
            obj.addProperty(target, default_value);
            return default_value;
        }
        return obj.get(target).getAsNumber();
    }

    public static boolean getIfExists(JsonObject obj, String target, boolean default_value) {
        if (!obj.has(target)) {
            obj.addProperty(target, Boolean.valueOf(default_value));
            return default_value;
        }
        return obj.get(target).getAsBoolean();
    }

    public static boolean getIfExists(JsonObject obj, String[] targets, boolean default_value) {
        for (String str : targets) {
            if (!obj.has(str)) continue;
            return obj.get(str).getAsBoolean();
        }
        obj.addProperty(targets[0], Boolean.valueOf(default_value));
        return default_value;
    }

    public static JsonElement getIfExists(JsonObject obj, String target, JsonElement default_value) {
        if (!obj.has(target)) {
            obj.add(target, default_value);
            return default_value;
        }
        return obj.get(target);
    }

    public static String getStringIfExists(JsonObject obj, String target) {
        if (obj.has(target)) {
            return obj.get(target).getAsString();
        }
        return null;
    }

    public static Number getNumberIfExists(JsonObject obj, String target) {
        if (obj.has(target)) {
            return obj.get(target).getAsNumber();
        }
        return -1;
    }

    public static boolean getBooleanIfExists(JsonObject obj, String target) {
        if (obj.has(target)) {
            return obj.get(target).getAsBoolean();
        }
        return false;
    }

    public static JsonElement getIfExists(JsonObject obj, String target) {
        if (!obj.has(target)) {
            return obj.get(target);
        }
        return null;
    }

    public static JsonElement getElementIfExists(JsonObject obj, String target, boolean b) {
        JsonElement elm = JsonUtil.getIfExists(obj, target);
        if (elm == null && b) {
            return new JsonObject();
        }
        return elm;
    }

    public static JsonArray getArray(File file, String string) {
        JsonObject obj = JsonUtil.get(file);
        if (obj.get(string) != null) {
            JsonElement el = obj.get(string);
            if (el.isJsonArray()) {
                return obj.get(string).getAsJsonArray();
            }
            return new JsonArray();
        }
        return new JsonArray();
    }

    public static boolean contains(JsonArray array, String string) {
        boolean result = false;
        for (JsonElement e : array) {
            try {
                if (!e.getAsString().equals(string)) continue;
                result = true;
            }
            catch (ClassCastException ex) {
                ex.printStackTrace();
                result = false;
            }
        }
        return result;
    }

    public static void update(File file, String string, JsonArray value) {
        JsonObject obj = JsonUtil.get(file);
        obj.add(string, (JsonElement)value);
        JsonUtil.write(file, (JsonElement)obj);
    }

    public static boolean contains(JsonArray array, Number number) {
        boolean result = false;
        for (JsonElement e : array) {
            try {
                if (e.getAsNumber() != number) continue;
                result = true;
            }
            catch (ClassCastException ex) {
                ex.printStackTrace();
                result = false;
            }
        }
        return result;
    }

    public static ArrayList<String> jsonArrayToStringArray(JsonArray array) {
        ArrayList<String> list = new ArrayList<String>();
        if (array == null) {
            return list;
        }
        for (JsonElement e : array) {
            try {
                if (!e.isJsonPrimitive()) continue;
                String str = e.getAsString();
                list.add(str);
            }
            catch (ClassCastException ex) {}
        }
        return list;
    }

    public static ArrayList<UUID> jsonArrayToUUIDArray(JsonArray array) {
        ArrayList<UUID> list = new ArrayList<UUID>();
        ArrayList<String> json = JsonUtil.jsonArrayToStringArray(array);
        for (String string : json) {
            try {
                list.add(UUID.fromString(string));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static ArrayList<Class<?>> jsonArrayToClassArray(JsonArray array) {
        ArrayList list = new ArrayList();
        ArrayList<String> json = JsonUtil.jsonArrayToStringArray(array);
        for (String string : json) {
            try {
                list.add(Class.forName(string.replace(".class", "")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static ArrayList<Integer> jsonArrayToIntegerArray(JsonArray array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (JsonElement e : array) {
            try {
                if (!e.isJsonPrimitive()) continue;
                Integer num = e.getAsInt();
                list.add(num);
            }
            catch (ClassCastException ex) {}
        }
        return list;
    }

    public static void add(JsonArray array, String string) {
        array.add((JsonElement)new JsonPrimitive(string));
    }

    public static void add(JsonArray array, Number number) {
        array.add((JsonElement)new JsonPrimitive(number));
    }

    public static JsonArray getArrayFromStringList(ArrayList<String> array) {
        JsonArray ja = new JsonArray();
        for (String s : array) {
            JsonUtil.add(ja, s);
        }
        return ja;
    }

    public static JsonElement getArrayFromUUIDList(ArrayList<UUID> array) {
        JsonArray ja = new JsonArray();
        for (UUID s : array) {
            JsonUtil.add(ja, s.toString());
        }
        return ja;
    }

    public static JsonElement getArrayFromObjectList(ArrayList<?> array) {
        JsonArray ja = new JsonArray();
        for (Object obj : array) {
            JsonUtil.add(ja, obj.toString());
        }
        return ja;
    }

    public static JsonArray getArrayFromIntegerList(ArrayList<Integer> array) {
        JsonArray ja = new JsonArray();
        for (int i : array) {
            JsonUtil.add(ja, i);
        }
        return ja;
    }

    public static boolean isJsonFile(File file) {
        try {
            FileReader fr = new FileReader(file);
            parser.parse((Reader)fr);
            fr.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static JsonUtil getInstance() {
        return instance;
    }

    public static JsonObject getObjectFromInputStream(InputStream stream) {
        JsonElement elm = JsonUtil.getElementFromInputStream(stream);
        return elm == null || !elm.isJsonObject() ? null : elm.getAsJsonObject();
    }

    public static JsonElement getElementFromInputStream(InputStream stream) {
        try {
            String input;
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            StringBuffer response = new StringBuffer();
            while ((input = in.readLine()) != null) {
                response.append(input);
            }
            in.close();
            return JsonUtil.getFromString(response.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String setPrettyPrinting(JsonObject obj) {
        return gson.toJson((JsonElement)obj);
    }

    public static JsonArray toJsonArray(float[] numbers) {
        JsonArray array = new JsonArray();
        for (float number : numbers) {
            array.add((Number)Float.valueOf(number));
        }
        return array;
    }

    public static JsonArray toJsonArray(double[] numbers) {
        JsonArray array = new JsonArray();
        for (double number : numbers) {
            array.add((Number)number);
        }
        return array;
    }

    public static JsonArray toJsonArray(int[] numbers) {
        JsonArray array = new JsonArray();
        for (int number : numbers) {
            array.add((Number)number);
        }
        return array;
    }

    public static JsonArray toJsonArray(byte[] numbers) {
        JsonArray array = new JsonArray();
        for (byte number : numbers) {
            array.add((Number)number);
        }
        return array;
    }

    public static JsonArray toJsonArray(short[] numbers) {
        JsonArray array = new JsonArray();
        for (short number : numbers) {
            array.add((Number)number);
        }
        return array;
    }

    public static JsonArray toJsonArray(char[] numbers) {
        JsonArray array = new JsonArray();
        for (char number : numbers) {
            array.add(Character.valueOf(number));
        }
        return array;
    }

    public static JsonArray toJsonArray(long[] numbers) {
        JsonArray array = new JsonArray();
        for (long number : numbers) {
            array.add((Number)number);
        }
        return array;
    }

    public static JsonArray toJsonArray(Number[] numbers) {
        JsonArray array = new JsonArray();
        for (Number number : numbers) {
            array.add(number);
        }
        return array;
    }

    public static float[] getFloatArray(JsonArray array) {
        float[] numbers = new float[array.size()];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = array.get(i).getAsFloat();
        }
        return numbers;
    }

    public static double[] getDoubleArray(JsonArray array) {
        double[] numbers = new double[array.size()];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = array.get(i).getAsDouble();
        }
        return numbers;
    }

    public static int[] getIntegerArray(JsonArray array) {
        int[] numbers = new int[array.size()];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = array.get(i).getAsInt();
        }
        return numbers;
    }

    public static byte[] getByteArray(JsonArray array) {
        byte[] numbers = new byte[array.size()];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = array.get(i).getAsByte();
        }
        return numbers;
    }

    public static short[] getShortArray(JsonArray array) {
        short[] numbers = new short[array.size()];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = array.get(i).getAsShort();
        }
        return numbers;
    }

    public static char[] getCharArray(JsonArray array) {
        char[] numbers = new char[array.size()];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = array.get(i).getAsCharacter();
        }
        return numbers;
    }

    public static long[] getLongArray(JsonArray array) {
        long[] numbers = new long[array.size()];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = array.get(i).getAsLong();
        }
        return numbers;
    }

    public static Number[] getNumberArray(JsonArray array) {
        Number[] numbers = new Number[array.size()];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = array.get(i).getAsNumber();
        }
        return numbers;
    }
}

