/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.TexturedVertex;
import net.fexcraft.lib.common.math.Vec3f;

public class ObjParser {
    private boolean comments;
    private boolean uv = true;
    private boolean normals = true;
    private boolean flip_vert;
    private boolean flip_face;
    private boolean flip_u;
    private boolean flip_v;
    private boolean invert;
    private boolean model = true;
    private InputStream stream;

    public ObjParser(InputStream stream) {
        this.stream = stream;
    }

    public ObjParser readComments(boolean bool) {
        this.comments = bool;
        return this;
    }

    public ObjParser readModel(boolean bool) {
        this.model = bool;
        return this;
    }

    public ObjParser skipUV(boolean bool) {
        this.uv = !bool;
        return this;
    }

    public ObjParser noNormals(boolean bool) {
        this.normals = !bool;
        return this;
    }

    public ObjParser flipAxes(boolean bool) {
        this.flip_vert = bool;
        return this;
    }

    public ObjParser flipFaces(boolean bool) {
        this.flip_face = bool;
        return this;
    }

    public ObjParser flipUV(boolean f_u, boolean f_v) {
        this.flip_u = f_u;
        this.flip_v = f_v;
        return this;
    }

    public ObjParser invertNormals(boolean bool) {
        this.invert = !bool;
        return this;
    }

    public ObjModel parse() {
        ObjModel model = new ObjModel();
        ArrayList<TexturedVertex> raw_verts = new ArrayList<TexturedVertex>();
        ArrayList<float[]> raw_uvs = new ArrayList<float[]>();
        ArrayList<float[]> raw_normals = new ArrayList<float[]>();
        LinkedHashMap faces = new LinkedHashMap();
        String s = null;
        String group = null;
        float[] uva = null;
        boolean norm = false;
        boolean uvb = false;
        boolean com = false;
        int line = 0;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.stream, "UTF-8"));
            while ((s = in.readLine()) != null) {
                ++line;
                if ((s = s.trim()).length() == 0) continue;
                if (s.startsWith("#")) {
                    if (this.comments) {
                        model.comments.add(s.substring(s.indexOf("#") + 1).trim());
                        continue;
                    }
                    if (!com) continue;
                    break;
                }
                if (s.startsWith("o ") || s.startsWith("g ")) {
                    if (!this.model) break;
                    if (this.comments) {
                        this.comments = false;
                        boolean bl = com = !this.model;
                    }
                    if (!model.polygons.containsKey(group = s.substring(s.indexOf(" ") + 1).trim())) {
                        model.polygons.put(group, new ArrayList());
                    }
                    if (faces.containsKey(group)) continue;
                    faces.put(group, new ArrayList());
                    continue;
                }
                if (!this.model) continue;
                if (s.startsWith("v")) {
                    String[] ss = s.substring(s.indexOf(" ") + 1).trim().split(" ");
                    if (s.startsWith("v ")) {
                        if (ss.length < 3) continue;
                        if (!this.flip_vert) {
                            raw_verts.add(new TexturedVertex(this.p(ss[0]), this.p(ss[1]), this.p(ss[2]), 0.0f, 0.0f));
                            continue;
                        }
                        raw_verts.add(new TexturedVertex(this.p(ss[2]), -this.p(ss[1]), -this.p(ss[0]), 0.0f, 0.0f));
                        continue;
                    }
                    if (s.startsWith("vt ")) {
                        if (!this.uv || ss.length < 2) continue;
                        float u = this.p(ss[0]);
                        float v = this.p(ss[1]);
                        if (this.flip_u) {
                            u = -u + 1.0f;
                        }
                        if (this.flip_v) {
                            v = -v + 1.0f;
                        }
                        raw_uvs.add(new float[]{u, v});
                        continue;
                    }
                    if (!s.startsWith("vn ") || !this.normals || ss.length < 3) continue;
                    raw_normals.add(new float[]{this.p(ss[0]), this.p(ss[2]), this.p(ss[1])});
                    continue;
                }
                if (!s.startsWith("f ")) continue;
                ((ArrayList)faces.get(group)).add(s.substring(s.indexOf(" ") + 1).trim().split(" "));
            }
            in.close();
            for (Map.Entry entry : faces.entrySet()) {
                for (String[] as : (ArrayList)entry.getValue()) {
                    int i;
                    ArrayList<TexturedVertex> verts = new ArrayList<TexturedVertex>();
                    ArrayList<float[]> norms = new ArrayList<float[]>();
                    ArrayList<float[]> uvs = new ArrayList<float[]>();
                    for (i = 0; i < as.length; ++i) {
                        if (as[i].contains("/")) {
                            String[] fs;
                            if (as[i].contains("//")) {
                                if (i == 0) {
                                    uvb = false;
                                    norm = this.normals;
                                }
                                fs = as[i].split("//");
                                verts.add((TexturedVertex)raw_verts.get(this.pi(fs[0])));
                                if (!norm) continue;
                                norms.add((float[])raw_normals.get(this.pi(fs[1])));
                                continue;
                            }
                            fs = as[i].split("/");
                            if (i == 0) {
                                uvb = this.uv;
                                norm = this.normals && fs.length > 2;
                            }
                            verts.add((TexturedVertex)raw_verts.get(this.pi(fs[0])));
                            if (uvb) {
                                uvs.add((float[])raw_uvs.get(this.pi(fs[1])));
                            }
                            if (!norm) continue;
                            norms.add((float[])raw_normals.get(this.pi(fs[2])));
                            continue;
                        }
                        if (i == 0) {
                            uvb = false;
                            norm = false;
                        }
                        verts.add((TexturedVertex)raw_verts.get(this.pi(as[i])));
                    }
                    if (uvb) {
                        for (i = 0; i < uvs.size(); ++i) {
                            uva = (float[])uvs.get(i);
                            verts.set(i, new TexturedVertex(verts.get(i), uva[0], uva[1]));
                        }
                    }
                    TexturedPolygon poly = new TexturedPolygon(verts);
                    if (norm) {
                        for (float[] fl : norms) {
                            poly.getNormalVerts().add(new Vec3f(fl[0], fl[1], fl[2]));
                        }
                    }
                    if (this.invert) {
                        poly.setInvert(this.invert);
                    }
                    if (this.flip_face) {
                        poly.flipFace();
                    }
                    model.polygons.get(entry.getKey()).add(poly);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception on line " + line + "; " + s + " ; " + group + "; " + e.getMessage());
            model.errors = true;
        }
        return model;
    }

    private float p(String string) {
        try {
            return Float.parseFloat(string);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    private int pi(String string) {
        try {
            return Integer.parseInt(string) - 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getCommentValue(ObjModel model, String ... prefixes) {
        List<String> list = ObjParser.getCommentValues(model, prefixes, 1);
        return list.isEmpty() ? null : list.get(0);
    }

    public static String[] getCommentValue(ObjModel model, String[] prefixes, String divider) {
        List<String[]> list = ObjParser.getCommentValues(model, prefixes, divider, 1);
        return list.isEmpty() ? null : list.get(0);
    }

    public static List<String> getCommentValues(ObjModel model, String[] prefixes, Integer limit) {
        ArrayList<String> list = new ArrayList<String>();
        if (model.comments == null || model.comments.isEmpty() || prefixes == null || prefixes.length == 0) {
            return list;
        }
        for (String comment : model.comments) {
            for (String prefix : prefixes) {
                try {
                    if (!comment.startsWith(prefix)) continue;
                    list.add(comment.substring(comment.indexOf(prefix) + prefix.length()).trim());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    public static List<String[]> getCommentValues(ObjModel model, String[] prefixes, String divider, Integer limit) {
        List<String> results = ObjParser.getCommentValues(model, prefixes, 1);
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (divider == null) {
            divider = " ";
        }
        if (results.isEmpty()) {
            return list;
        }
        for (String str : results) {
            list.add(str.split(divider));
        }
        return list;
    }

    public static class ObjModel {
        public final ArrayList<String> comments = new ArrayList();
        public final Map<String, ArrayList<TexturedPolygon>> polygons = new LinkedHashMap<String, ArrayList<TexturedPolygon>>();
        public boolean errors;
    }
}

