/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.frl;

import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.frl.GLO;
import net.fexcraft.lib.frl.Material;
import net.fexcraft.lib.frl.Polygon;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.frl.Renderer;
import net.fexcraft.mod.fcl.FCL;
import net.fexcraft.mod.uni.IDL;
import org.lwjgl.opengl.GL11;

public class DefaultRenderer
extends Renderer<GLO> {
    public static RGB conv = RGB.WHITE.copy();
    private Material material;

    @Override
    public void render(Polyhedron<GLO> poly) {
        if (((GLO)poly.glObj).material != this.material) {
            this.material = ((GLO)poly.glObj).material;
            this.material.applyTexture();
        }
        if (poly.glId == null || poly.recompile) {
            DefaultRenderer.compile(poly);
        }
        if (poly.rotX != 0.0f || poly.rotY != 0.0f || poly.rotZ != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)poly.posX, (float)poly.posY, (float)poly.posZ);
            poly.rotOrder.rotate(poly);
            GL11.glCallList((int)poly.glId);
            if (poly.sub != null) {
                for (Polyhedron<GLO> polyhedron : poly.sub) {
                    this.render(polyhedron);
                }
            }
            GL11.glPopMatrix();
        } else if (poly.posX != 0.0f || poly.posY != 0.0f || poly.posZ != 0.0f) {
            GL11.glTranslatef((float)poly.posX, (float)poly.posY, (float)poly.posZ);
            GL11.glCallList((int)poly.glId);
            if (poly.sub != null) {
                for (Polyhedron<GLO> polyhedron : poly.sub) {
                    this.render(polyhedron);
                }
            }
            GL11.glTranslatef((float)(-poly.posX), (float)(-poly.posY), (float)(-poly.posZ));
        } else {
            GL11.glCallList((int)poly.glId);
            if (poly.sub != null) {
                for (Polyhedron<GLO> polyhedron : poly.sub) {
                    this.render(polyhedron);
                }
            }
        }
    }

    private static void compile(Polyhedron<GLO> poly) {
        poly.glId = GL11.glGenLists((int)1);
        GL11.glNewList((int)poly.glId, (int)4864);
        for (Polygon gon : poly.polygons) {
            if (gon.lines) {
                GL11.glBegin((int)3);
            } else {
                switch (gon.vertices.length) {
                    case 3: {
                        GL11.glBegin((int)4);
                        break;
                    }
                    case 4: {
                        GL11.glBegin((int)(TRIANGULATED_QUADS ? 4 : 7));
                        break;
                    }
                    default: {
                        GL11.glBegin((int)9);
                    }
                }
            }
            if (TRIANGULATED_QUADS && gon.vertices.length == 4) {
                if (gon.colored) {
                    DefaultRenderer.quadAsTriangleCol(gon, 0, 1, 2, 0);
                } else {
                    DefaultRenderer.quadAsTriangleTex(gon, 0, 1, 2, 0);
                }
                if (gon.colored) {
                    DefaultRenderer.quadAsTriangleCol(gon, 0, 2, 3, 3);
                } else {
                    DefaultRenderer.quadAsTriangleTex(gon, 0, 2, 3, 3);
                }
            } else {
                for (int i = 0; i < gon.vertices.length; ++i) {
                    GL11.glNormal3f((float)gon.vertices[i].norm.x, (float)gon.vertices[i].norm.y, (float)gon.vertices[i].norm.z);
                    if (gon.colored) {
                        GL11.glColor4f((float)gon.vertices[i].color().x, (float)gon.vertices[i].color().y, (float)gon.vertices[i].color().z, (float)1.0f);
                    } else {
                        GL11.glTexCoord2f((float)gon.vertices[i].u, (float)gon.vertices[i].v);
                    }
                    GL11.glVertex3f((float)gon.vertices[i].vector.x, (float)gon.vertices[i].vector.y, (float)gon.vertices[i].vector.z);
                }
            }
            GL11.glEnd();
        }
        GL11.glEndList();
        poly.recompile = false;
    }

    private static void quadAsTriangleCol(Polygon poly, int x, int y, int z, int o) {
        GL11.glColor4f((float)poly.vertices[x].color().x, (float)poly.vertices[x].color().y, (float)poly.vertices[x].color().z, (float)1.0f);
        GL11.glNormal3f((float)poly.vertices[x].norm.x, (float)poly.vertices[x].norm.y, (float)poly.vertices[x].norm.z);
        GL11.glTexCoord2f((float)poly.vertices[x].u, (float)poly.vertices[x].v);
        GL11.glVertex3f((float)poly.vertices[x].vector.x, (float)poly.vertices[x].vector.y, (float)poly.vertices[x].vector.z);
        GL11.glColor4f((float)poly.vertices[y].color().x, (float)poly.vertices[y].color().y, (float)poly.vertices[y].color().z, (float)1.0f);
        GL11.glNormal3f((float)poly.vertices[y].norm.x, (float)poly.vertices[y].norm.y, (float)poly.vertices[y].norm.z);
        GL11.glTexCoord2f((float)poly.vertices[y].u, (float)poly.vertices[y].v);
        GL11.glVertex3f((float)poly.vertices[y].vector.x, (float)poly.vertices[y].vector.y, (float)poly.vertices[y].vector.z);
        GL11.glColor4f((float)poly.vertices[z].color().x, (float)poly.vertices[z].color().y, (float)poly.vertices[z].color().z, (float)1.0f);
        GL11.glNormal3f((float)poly.vertices[z].norm.x, (float)poly.vertices[z].norm.y, (float)poly.vertices[z].norm.z);
        GL11.glTexCoord2f((float)poly.vertices[z].u, (float)poly.vertices[z].v);
        GL11.glVertex3f((float)poly.vertices[z].vector.x, (float)poly.vertices[z].vector.y, (float)poly.vertices[z].vector.z);
        RGB.glColorReset();
    }

    private static void quadAsTriangleTex(Polygon poly, int x, int y, int z, int o) {
        GL11.glNormal3f((float)poly.vertices[x].norm.x, (float)poly.vertices[x].norm.y, (float)poly.vertices[x].norm.z);
        GL11.glTexCoord2f((float)poly.vertices[x].u, (float)poly.vertices[x].v);
        GL11.glVertex3f((float)poly.vertices[x].vector.x, (float)poly.vertices[x].vector.y, (float)poly.vertices[x].vector.z);
        GL11.glNormal3f((float)poly.vertices[y].norm.x, (float)poly.vertices[y].norm.y, (float)poly.vertices[y].norm.z);
        GL11.glTexCoord2f((float)poly.vertices[y].u, (float)poly.vertices[y].v);
        GL11.glVertex3f((float)poly.vertices[y].vector.x, (float)poly.vertices[y].vector.y, (float)poly.vertices[y].vector.z);
        GL11.glNormal3f((float)poly.vertices[z].norm.x, (float)poly.vertices[z].norm.y, (float)poly.vertices[z].norm.z);
        GL11.glTexCoord2f((float)poly.vertices[z].u, (float)poly.vertices[z].v);
        GL11.glVertex3f((float)poly.vertices[z].vector.x, (float)poly.vertices[z].vector.y, (float)poly.vertices[z].vector.z);
    }

    @Override
    public void delete(Polyhedron<GLO> poly) {
        if (poly.glId == null) {
            return;
        }
        GL11.glDeleteLists((int)poly.glId, (int)1);
    }

    @Override
    public void push() {
        GL11.glPushMatrix();
    }

    @Override
    public void pop() {
        GL11.glPopMatrix();
    }

    @Override
    public void translate(double x, double y, double z) {
        GL11.glTranslated((double)x, (double)y, (double)z);
    }

    @Override
    public void rotate(float deg, int x, int y, int z) {
        GL11.glRotatef((float)deg, (float)x, (float)y, (float)z);
    }

    @Override
    public void rotate(double deg, int x, int y, int z) {
        GL11.glRotated((double)deg, (double)x, (double)y, (double)z);
    }

    @Override
    public void scale(double x, double y, double z) {
        GL11.glScaled((double)x, (double)y, (double)z);
    }

    @Override
    public void bind(IDL tex) {
        FCL.bindTex(tex);
    }

    @Override
    public void color(int rgb) {
        DefaultRenderer.conv.packed = rgb;
        conv.glColorApply();
    }

    @Override
    public void light(V3D pos) {
    }
}

