/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.frl;

import java.util.Collection;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.ColoredVertex;
import net.fexcraft.lib.frl.Vertex;

public class Polygon {
    public Vertex[] vertices;
    public boolean colored;
    public boolean lines;
    public boolean textured;

    public Polygon(int edges) {
        this.vertices = new Vertex[edges];
        for (int i = 0; i < edges; ++i) {
            this.vertices[i] = new Vertex(new Vec3f());
        }
    }

    public Polygon(Vertex[] verts) {
        this.vertices = verts;
    }

    public Polygon(Collection<Vertex> verts) {
        this.vertices = verts.toArray(new Vertex[0]);
    }

    public Polygon color(RGB color) {
        this.colored = color != null;
        if (this.colored) {
            Vec3f col = new Vec3f(color.toFloatArray(), 0);
            for (int i = 0; i < this.vertices.length; ++i) {
                if (!(this.vertices[i] instanceof ColoredVertex)) {
                    this.vertices[i] = new ColoredVertex(this.vertices[i]);
                }
                this.vertices[i].color(col);
            }
        }
        return this;
    }

    public Polygon lines(boolean bool) {
        this.lines = bool;
        return this;
    }

    public Polygon textured(boolean bool) {
        this.textured = bool;
        return this;
    }

    public Polygon colored(boolean bool) {
        this.colored = bool;
        if (this.colored) {
            for (int i = 0; i < this.vertices.length; ++i) {
                if (this.vertices[i] instanceof ColoredVertex) continue;
                this.vertices[i] = new ColoredVertex(this.vertices[i]);
            }
        }
        return this;
    }

    public void rescale(float scale) {
        for (Vertex vert : this.vertices) {
            vert.vector = vert.vector.scale(scale);
        }
    }

    public Polygon flip() {
        Vertex[] verts = new Vertex[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            verts[i] = this.vertices[this.vertices.length - i - 1];
        }
        this.vertices = verts;
        return this;
    }

    public Polygon copy(boolean full) {
        if (full) {
            Polygon poly = new Polygon(this.vertices.length);
            for (int i = 0; i < this.vertices.length; ++i) {
                poly.vertices[i] = this.vertices[i].copy();
            }
            return poly.lines(this.lines).textured(this.textured);
        }
        return new Polygon(this.vertices).lines(this.lines).textured(this.textured);
    }
}

