/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.tmt;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.TexturedVertex;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.common.utils.ObjParser;
import net.fexcraft.lib.tmt.BoxBuilder;
import net.fexcraft.lib.tmt.ColorIndexedVoxelBuilder;
import net.fexcraft.lib.tmt.Coord2D;
import net.fexcraft.lib.tmt.CylinderBuilder;
import net.fexcraft.lib.tmt.DefaultRenderer;
import net.fexcraft.lib.tmt.RotationOrder;
import net.fexcraft.lib.tmt.Shape2D;
import net.fexcraft.lib.tmt.Shape3D;
import net.fexcraft.lib.tmt.VoxelBuilder;

public class ModelRendererTurbo {
    public float textureWidth = 0.0f;
    public float textureHeight = 0.0f;
    public float rotationAngleX = 0.0f;
    public float rotationAngleY = 0.0f;
    public float rotationAngleZ = 0.0f;
    public float rotationPointX = 0.0f;
    public float rotationPointY = 0.0f;
    public float rotationPointZ = 0.0f;
    public RotationOrder rotationOrder = RotationOrder.YZX;
    public static final int MR_FRONT = 0;
    public static final int MR_BACK = 1;
    public static final int MR_LEFT = 2;
    public static final int MR_RIGHT = 3;
    public static final int MR_TOP = 4;
    public static final int MR_BOTTOM = 5;
    public boolean showModel = true;
    public boolean forcedRecompile = false;
    public boolean mirror = false;
    public boolean flip = false;
    public boolean isShape3D;
    public boolean textured = true;
    public RGB linesColor;
    public RGB polygonColor;
    private ArrayList<TexturedPolygon> faces = new ArrayList();
    protected Integer glId;
    protected Object glObj;
    public int texoffx;
    public int texoffy;
    public List<ModelRendererTurbo> childModels;
    public String boxName;
    public String texName;
    public static Renderer RENDERER = new DefaultRenderer();
    private static RGB red1 = new RGB(138, 65, 92);
    private static RGB gre1 = new RGB(92, 138, 65);
    private static RGB blu1 = new RGB(65, 92, 138);
    private static RGB red0 = new RGB(150, 0, 0);
    private static RGB gre0 = new RGB(0, 150, 0);
    private static RGB blu0 = new RGB(0, 0, 150);
    private static RGB gray = new RGB(89, 89, 89);

    public ModelRendererTurbo(Object modelbase, String s) {
        this.boxName = s;
    }

    public ModelRendererTurbo(Object modelbase) {
        this(modelbase, null);
    }

    public ModelRendererTurbo(Object modelbase, int textureX, int textureY) {
        this(modelbase, textureX, textureY, 64, 32);
    }

    public ModelRendererTurbo(Object modelbase, int textureX, int textureY, int textureU, int textureV) {
        this(modelbase);
        this.texoffx = textureX;
        this.texoffy = textureY;
        this.textureWidth = textureU;
        this.textureHeight = textureV;
    }

    public ModelRendererTurbo setRotationPoint(float x, float y, float z) {
        this.rotationPointX = x;
        this.rotationPointY = y;
        this.rotationPointZ = z;
        return this;
    }

    public ModelRendererTurbo setRotationAngle(float x, float y, float z) {
        this.rotationAngleX = x;
        this.rotationAngleY = y;
        this.rotationAngleZ = z;
        return this;
    }

    public ModelRendererTurbo setRotationOrder(RotationOrder rotor) {
        this.rotationOrder = rotor;
        return this;
    }

    public ModelRendererTurbo setTextured(boolean bool) {
        this.textured = bool;
        return this;
    }

    public ModelRendererTurbo setTexture(String tex) {
        this.texName = tex;
        if (tex != null) {
            this.textured = true;
        }
        return this;
    }

    public ModelRendererTurbo setLines(boolean bool) {
        this.linesColor = bool ? RGB.BLACK : null;
        return this;
    }

    public ModelRendererTurbo setLines(RGB color) {
        this.linesColor = color;
        return this;
    }

    public ModelRendererTurbo setColor(RGB color) {
        this.polygonColor = color;
        return this;
    }

    public ModelRendererTurbo setVisible(boolean bool) {
        this.showModel = bool;
        return this;
    }

    public ModelRendererTurbo setInvisible(boolean bool) {
        this.showModel = !bool;
        return this;
    }

    public ModelRendererTurbo setName(String name) {
        this.boxName = name;
        return this;
    }

    public ModelRendererTurbo addPolygon(TexturedVertex[] verts) {
        return this.copyTo(new TexturedPolygon(verts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPolygon(TexturedVertex[] verts, int[][] uv) {
        try {
            for (int i = 0; i < verts.length; ++i) {
                verts[i] = verts[i].setTexturePosition((float)uv[i][0] / this.textureWidth, (float)uv[i][1] / this.textureHeight);
            }
        }
        finally {
            this.addPolygon(verts);
        }
    }

    public void addPolygon(TexturedVertex[] verts, int u1, int v1, int u2, int v2) {
        this.copyTo(this.addPolygonReturn(verts, u1, v1, u2, v2));
    }

    private TexturedPolygon addPolygonReturn(TexturedVertex[] verts, float x0, float y0, float x1, float y1) {
        if (verts.length < 3) {
            return null;
        }
        float uOffs = 0.0f;
        float vOffs = 0.0f;
        if (verts.length < 4) {
            float xMin = -1.0f;
            float yMin = -1.0f;
            float xMax = 0.0f;
            float yMax = 0.0f;
            for (int i = 0; i < verts.length; ++i) {
                float xPos = verts[i].textureX;
                float yPos = verts[i].textureY;
                xMax = Math.max(xMax, xPos);
                xMin = xMin < -1.0f ? xPos : Math.min(xMin, xPos);
                yMax = Math.max(yMax, yPos);
                yMin = yMin < -1.0f ? yPos : Math.min(yMin, yPos);
            }
            float uMin = x0 / this.textureWidth + uOffs;
            float vMin = y0 / this.textureHeight + vOffs;
            float uSize = (x1 - x0) / this.textureWidth - uOffs * 2.0f;
            float vSize = (y1 - y0) / this.textureHeight - vOffs * 2.0f;
            float xSize = xMax - xMin;
            float ySize = yMax - yMin;
            for (int i = 0; i < verts.length; ++i) {
                float xPos = verts[i].textureX;
                float yPos = verts[i].textureY;
                xPos = (xPos - xMin) / xSize;
                yPos = (yPos - yMin) / ySize;
                verts[i] = verts[i].setTexturePosition(uMin + xPos * uSize, vMin + yPos * vSize);
            }
        } else {
            verts[0] = verts[0].setTexturePosition(x1 / this.textureWidth - uOffs, y0 / this.textureHeight + vOffs);
            verts[1] = verts[1].setTexturePosition(x0 / this.textureWidth + uOffs, y0 / this.textureHeight + vOffs);
            verts[2] = verts[2].setTexturePosition(x0 / this.textureWidth + uOffs, y1 / this.textureHeight - vOffs);
            verts[3] = verts[3].setTexturePosition(x1 / this.textureWidth - uOffs, y1 / this.textureHeight - vOffs);
        }
        return new TexturedPolygon(verts);
    }

    private TexturedPolygon addPolygonReturn(TexturedVertex[] verts, float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        if (verts.length < 3) {
            return null;
        }
        float uOffs = 0.0f;
        float vOffs = 0.0f;
        verts[0] = verts[0].setTexturePosition(x0 / this.textureWidth - uOffs, y0 / this.textureHeight + vOffs);
        verts[1] = verts[1].setTexturePosition(x1 / this.textureWidth + uOffs, y1 / this.textureHeight + vOffs);
        verts[2] = verts[2].setTexturePosition(x2 / this.textureWidth + uOffs, y2 / this.textureHeight - vOffs);
        verts[3] = verts[3].setTexturePosition(x3 / this.textureWidth - uOffs, y3 / this.textureHeight - vOffs);
        return new TexturedPolygon(verts);
    }

    public ModelRendererTurbo addRectShape(float[] v0, float[] v1, float[] v2, float[] v3, float[] v4, float[] v5, float[] v6, float[] v7, float w, float h, float d) {
        return this.addRectShape(v0, v1, v2, v3, v4, v5, v6, v7, w, h, d, null);
    }

    public ModelRendererTurbo addRectShape(float[] v0, float[] v1, float[] v2, float[] v3, float[] v4, float[] v5, float[] v6, float[] v7, float w, float h, float d, boolean[] sides) {
        TexturedPolygon[] poly = new TexturedPolygon[6];
        TexturedVertex tv0 = new TexturedVertex(v0[0], v0[1], v0[2], 0.0f, 0.0f);
        TexturedVertex tv1 = new TexturedVertex(v1[0], v1[1], v1[2], 0.0f, 8.0f);
        TexturedVertex tv2 = new TexturedVertex(v2[0], v2[1], v2[2], 8.0f, 8.0f);
        TexturedVertex tv3 = new TexturedVertex(v3[0], v3[1], v3[2], 8.0f, 0.0f);
        TexturedVertex tv4 = new TexturedVertex(v4[0], v4[1], v4[2], 0.0f, 0.0f);
        TexturedVertex tv5 = new TexturedVertex(v5[0], v5[1], v5[2], 0.0f, 8.0f);
        TexturedVertex tv6 = new TexturedVertex(v6[0], v6[1], v6[2], 8.0f, 8.0f);
        TexturedVertex tv7 = new TexturedVertex(v7[0], v7[1], v7[2], 8.0f, 0.0f);
        if (w % 1.0f != 0.0f) {
            float f = w < 1.0f ? 1.0f : (w = (float)((int)w + (w % 1.0f > 0.5f ? 1 : 0)));
        }
        if (h % 1.0f != 0.0f) {
            float f = h < 1.0f ? 1.0f : (h = (float)((int)h + (h % 1.0f > 0.5f ? 1 : 0)));
        }
        if (d % 1.0f != 0.0f) {
            float f = d < 1.0f ? 1.0f : (d = (float)((int)d + (d % 1.0f > 0.5f ? 1 : 0)));
        }
        if (sides == null) {
            poly[0] = this.addPolygonReturn(new TexturedVertex[]{tv5, tv1, tv2, tv6}, (float)this.texoffx + d + w, (float)this.texoffy + d, (float)this.texoffx + d + w + d, (float)this.texoffy + d + h);
            poly[1] = this.addPolygonReturn(new TexturedVertex[]{tv0, tv4, tv7, tv3}, this.texoffx + 0, (float)this.texoffy + d, (float)this.texoffx + d, (float)this.texoffy + d + h);
            poly[2] = this.addPolygonReturn(new TexturedVertex[]{tv5, tv4, tv0, tv1}, (float)this.texoffx + d, this.texoffy + 0, (float)this.texoffx + d + w, (float)this.texoffy + d);
            poly[3] = this.addPolygonReturn(new TexturedVertex[]{tv2, tv3, tv7, tv6}, (float)this.texoffx + d + w, this.texoffy + 0, (float)this.texoffx + d + w + w, (float)this.texoffy + d);
            poly[4] = this.addPolygonReturn(new TexturedVertex[]{tv1, tv0, tv3, tv2}, (float)this.texoffx + d, (float)this.texoffy + d, (float)this.texoffx + d + w, (float)this.texoffy + d + h);
            poly[5] = this.addPolygonReturn(new TexturedVertex[]{tv4, tv5, tv6, tv7}, (float)this.texoffx + d + w + d, (float)this.texoffy + d, (float)this.texoffx + d + w + d + w, (float)this.texoffy + d + h);
        } else {
            float x3;
            float yp = sides[2] && sides[3] ? 0.0f : d;
            float x0 = sides[1] ? 0.0f : d;
            float x1 = sides[2] ? 0.0f : w;
            float x2 = sides[4] ? 0.0f : w;
            float f = x3 = sides[0] ? 0.0f : d;
            if (sides.length > 0 && !sides[0]) {
                poly[0] = this.addPolygonReturn(new TexturedVertex[]{tv5, tv1, tv2, tv6}, (float)this.texoffx + x0 + x2, (float)this.texoffy + yp, (float)this.texoffx + x0 + x2 + d, (float)this.texoffy + yp + h);
            }
            if (sides.length > 1 && !sides[1]) {
                poly[1] = this.addPolygonReturn(new TexturedVertex[]{tv0, tv4, tv7, tv3}, this.texoffx + 0, (float)this.texoffy + yp, (float)this.texoffx + d, (float)this.texoffy + yp + h);
            }
            if (sides.length > 2 && !sides[2]) {
                poly[2] = this.addPolygonReturn(new TexturedVertex[]{tv5, tv4, tv0, tv1}, (float)this.texoffx + x0, this.texoffy + 0, (float)this.texoffx + x0 + w, (float)this.texoffy + d);
            }
            if (sides.length > 3 && !sides[3]) {
                poly[3] = this.addPolygonReturn(new TexturedVertex[]{tv2, tv3, tv7, tv6}, (float)this.texoffx + x0 + x1, this.texoffy + 0, (float)this.texoffx + x0 + x1 + w, (float)this.texoffy + d);
            }
            if (sides.length > 4 && !sides[4]) {
                poly[4] = this.addPolygonReturn(new TexturedVertex[]{tv1, tv0, tv3, tv2}, (float)this.texoffx + x0, (float)this.texoffy + yp, (float)this.texoffx + x0 + w, (float)this.texoffy + yp + h);
            }
            if (sides.length > 5 && !sides[5]) {
                poly[5] = this.addPolygonReturn(new TexturedVertex[]{tv4, tv5, tv6, tv7}, (float)this.texoffx + x0 + x2 + x3, (float)this.texoffy + yp, (float)this.texoffx + x0 + x2 + x3 + w, (float)this.texoffy + yp + h);
            }
        }
        if (this.mirror ^ this.flip) {
            for (int l = 0; l < poly.length; ++l) {
                poly[l].flipFace();
            }
        }
        if (sides != null) {
            int polis = 0;
            int processed = 0;
            for (int i = 0; i < poly.length; ++i) {
                if (poly[i] == null) continue;
                ++polis;
            }
            TexturedPolygon[] polygons = new TexturedPolygon[polis];
            for (int i = 0; i < poly.length; ++i) {
                if (poly[i] == null) continue;
                polygons[processed] = poly[i];
                ++processed;
            }
            poly = polygons;
        }
        return this.copyTo(poly);
    }

    public ModelRendererTurbo addBox(float x, float y, float z, float w, float h, float d) {
        return this.addBox(x, y, z, w, h, d, 0.0f);
    }

    public ModelRendererTurbo addBox(float x, float y, float z, float w, float h, float d, float expansion) {
        return this.addBox(x, y, z, w, h, d, expansion, 1.0f);
    }

    public ModelRendererTurbo addBox(float x, float y, float z, float w, float h, float d, float expansion, float scale) {
        return this.addBox(x, y, z, w, h, d, expansion, scale, null);
    }

    public ModelRendererTurbo addBox(float x, float y, float z, float w, float h, float d, float expansion, float scale, boolean[] sides) {
        if (w == 0.0f) {
            w = 0.01f;
        }
        if (h == 0.0f) {
            h = 0.01f;
        }
        if (d == 0.0f) {
            d = 0.01f;
        }
        float scaleX = w * scale;
        float scaleY = h * scale;
        float scaleZ = d * scale;
        float x1 = x + scaleX;
        float y1 = y + scaleY;
        float z1 = z + scaleZ;
        float expX = expansion + scaleX - w;
        float expY = expansion + scaleY - h;
        float expZ = expansion + scaleZ - d;
        x -= expX;
        y -= expY;
        z -= expZ;
        x1 += expansion;
        y1 += expansion;
        z1 += expansion;
        if (this.mirror) {
            float xTemp = x1;
            x1 = x;
            x = xTemp;
        }
        float[] v0 = new float[]{x, y, z};
        float[] v1 = new float[]{x1, y, z};
        float[] v2 = new float[]{x1, y1, z};
        float[] v3 = new float[]{x, y1, z};
        float[] v4 = new float[]{x, y, z1};
        float[] v5 = new float[]{x1, y, z1};
        float[] v6 = new float[]{x1, y1, z1};
        float[] v7 = new float[]{x, y1, z1};
        return this.addRectShape(v0, v1, v2, v3, v4, v5, v6, v7, w, h, d, sides);
    }

    public ModelRendererTurbo addTrapezoid(float x, float y, float z, int w, int h, int d, float scale, float bottomScale, int dir) {
        int m;
        float f4 = x + (float)w;
        float f5 = y + (float)h;
        float f6 = z + (float)d;
        x -= scale;
        y -= scale;
        z -= scale;
        f4 += scale;
        f5 += scale;
        f6 += scale;
        int n = m = this.mirror ? -1 : 1;
        if (this.mirror) {
            float f7 = f4;
            f4 = x;
            x = f7;
        }
        float[] v0 = new float[]{x, y, z};
        float[] v1 = new float[]{f4, y, z};
        float[] v2 = new float[]{f4, f5, z};
        float[] v3 = new float[]{x, f5, z};
        float[] v4 = new float[]{x, y, f6};
        float[] v5 = new float[]{f4, y, f6};
        float[] v6 = new float[]{f4, f5, f6};
        float[] v7 = new float[]{x, f5, f6};
        switch (dir) {
            case 3: {
                v0[1] = v0[1] - bottomScale;
                v0[2] = v0[2] - bottomScale;
                v3[1] = v3[1] + bottomScale;
                v3[2] = v3[2] - bottomScale;
                v4[1] = v4[1] - bottomScale;
                v4[2] = v4[2] + bottomScale;
                v7[1] = v7[1] + bottomScale;
                v7[2] = v7[2] + bottomScale;
                break;
            }
            case 2: {
                v1[1] = v1[1] - bottomScale;
                v1[2] = v1[2] - bottomScale;
                v2[1] = v2[1] + bottomScale;
                v2[2] = v2[2] - bottomScale;
                v5[1] = v5[1] - bottomScale;
                v5[2] = v5[2] + bottomScale;
                v6[1] = v6[1] + bottomScale;
                v6[2] = v6[2] + bottomScale;
                break;
            }
            case 0: {
                v0[0] = v0[0] - (float)m * bottomScale;
                v0[1] = v0[1] - bottomScale;
                v1[0] = v1[0] + (float)m * bottomScale;
                v1[1] = v1[1] - bottomScale;
                v2[0] = v2[0] + (float)m * bottomScale;
                v2[1] = v2[1] + bottomScale;
                v3[0] = v3[0] - (float)m * bottomScale;
                v3[1] = v3[1] + bottomScale;
                break;
            }
            case 1: {
                v4[0] = v4[0] - (float)m * bottomScale;
                v4[1] = v4[1] - bottomScale;
                v5[0] = v5[0] + (float)m * bottomScale;
                v5[1] = v5[1] - bottomScale;
                v6[0] = v6[0] + (float)m * bottomScale;
                v6[1] = v6[1] + bottomScale;
                v7[0] = v7[0] - (float)m * bottomScale;
                v7[1] = v7[1] + bottomScale;
                break;
            }
            case 4: {
                v0[0] = v0[0] - (float)m * bottomScale;
                v0[2] = v0[2] - bottomScale;
                v1[0] = v1[0] + (float)m * bottomScale;
                v1[2] = v1[2] - bottomScale;
                v4[0] = v4[0] - (float)m * bottomScale;
                v4[2] = v4[2] + bottomScale;
                v5[0] = v5[0] + (float)m * bottomScale;
                v5[2] = v5[2] + bottomScale;
                break;
            }
            case 5: {
                v2[0] = v2[0] + (float)m * bottomScale;
                v2[2] = v2[2] - bottomScale;
                v3[0] = v3[0] - (float)m * bottomScale;
                v3[2] = v3[2] - bottomScale;
                v6[0] = v6[0] + (float)m * bottomScale;
                v6[2] = v6[2] + bottomScale;
                v7[0] = v7[0] - (float)m * bottomScale;
                v7[2] = v7[2] + bottomScale;
            }
        }
        return this.addRectShape(v0, v1, v2, v3, v4, v5, v6, v7, w, h, d);
    }

    public ModelRendererTurbo addShape3D(float x, float y, float z, Coord2D[] coordinates, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction) {
        return this.addShape3D(x, y, z, coordinates, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, null);
    }

    public ModelRendererTurbo addShape3D(float x, float y, float z, Coord2D[] coordinates, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction, float[] faceLengths) {
        return this.addShape3D(x, y, z, new Shape2D(coordinates), depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, faceLengths);
    }

    public ModelRendererTurbo addShape3D(float x, float y, float z, ArrayList<Coord2D> coordinates, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction) {
        return this.addShape3D(x, y, z, coordinates, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, null);
    }

    public ModelRendererTurbo addShape3D(float x, float y, float z, ArrayList<Coord2D> coordinates, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction, float[] faceLengths) {
        return this.addShape3D(x, y, z, new Shape2D(coordinates), depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, faceLengths);
    }

    public ModelRendererTurbo addShape3D(float x, float y, float z, Shape2D shape, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction) {
        return this.addShape3D(x, y, z, shape, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, direction, null);
    }

    public ModelRendererTurbo addShape3D(float x, float y, float z, Shape2D shape, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, int direction, float[] faceLengths) {
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        switch (direction) {
            case 2: {
                rotY = 1.5707964f;
                break;
            }
            case 3: {
                rotY = -1.5707964f;
                break;
            }
            case 4: {
                rotX = 1.5707964f;
                break;
            }
            case 5: {
                rotX = -1.5707964f;
                break;
            }
            case 0: {
                rotY = (float)Math.PI;
                break;
            }
        }
        return this.addShape3D(x, y, z, shape, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, rotX, rotY, rotZ, faceLengths);
    }

    public ModelRendererTurbo addShape3D(float x, float y, float z, Shape2D shape, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, float rotX, float rotY, float rotZ) {
        return this.addShape3D(x, y, z, shape, depth, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, rotX, rotY, rotZ, null);
    }

    public ModelRendererTurbo addShape3D(float x, float y, float z, Shape2D shape, float depth, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, float rotX, float rotY, float rotZ, float[] faceLengths) {
        Shape3D shape3D = shape.extrude(-x, y, -z, rotX, rotY, rotZ, depth, this.texoffx, this.texoffy, this.textureWidth, this.textureHeight, shapeTextureWidth, shapeTextureHeight, sideTextureWidth, sideTextureHeight, faceLengths);
        if (this.flip) {
            for (int idx = 0; idx < shape3D.faces.length; ++idx) {
                shape3D.faces[idx].flipFace();
            }
        }
        this.isShape3D = true;
        return this.copyTo(shape3D.faces);
    }

    public ModelRendererTurbo addPixel(float x, float y, float z, float width, float height, float length) {
        return this.addPixel(x, y, z, new float[]{width, height, length}, this.texoffx, this.texoffy);
    }

    public ModelRendererTurbo addPixel(float x, float y, float z, float[] scale, int w, int h) {
        TexturedVertex[] verts = new TexturedVertex[8];
        TexturedPolygon[] poly = new TexturedPolygon[6];
        float x1 = x + scale[0];
        float y1 = y + scale[1];
        float z1 = z + scale[2];
        float[] f0 = new float[]{x, y, z};
        float[] f1 = new float[]{x1, y, z};
        float[] f2 = new float[]{x1, y1, z};
        float[] f3 = new float[]{x, y1, z};
        float[] f4 = new float[]{x, y, z1};
        float[] f5 = new float[]{x1, y, z1};
        float[] f6 = new float[]{x1, y1, z1};
        float[] f7 = new float[]{x, y1, z1};
        TexturedVertex TexturedVertex0 = new TexturedVertex(f0[0], f0[1], f0[2], 0.0f, 0.0f);
        TexturedVertex TexturedVertex1 = new TexturedVertex(f1[0], f1[1], f1[2], 0.0f, 8.0f);
        TexturedVertex TexturedVertex2 = new TexturedVertex(f2[0], f2[1], f2[2], 8.0f, 8.0f);
        TexturedVertex TexturedVertex3 = new TexturedVertex(f3[0], f3[1], f3[2], 8.0f, 0.0f);
        TexturedVertex TexturedVertex4 = new TexturedVertex(f4[0], f4[1], f4[2], 0.0f, 0.0f);
        TexturedVertex TexturedVertex5 = new TexturedVertex(f5[0], f5[1], f5[2], 0.0f, 8.0f);
        TexturedVertex TexturedVertex6 = new TexturedVertex(f6[0], f6[1], f6[2], 8.0f, 8.0f);
        TexturedVertex TexturedVertex7 = new TexturedVertex(f7[0], f7[1], f7[2], 8.0f, 0.0f);
        verts[0] = TexturedVertex0;
        verts[1] = TexturedVertex1;
        verts[2] = TexturedVertex2;
        verts[3] = TexturedVertex3;
        verts[4] = TexturedVertex4;
        verts[5] = TexturedVertex5;
        verts[6] = TexturedVertex6;
        verts[7] = TexturedVertex7;
        poly[0] = this.addPolygonReturn(new TexturedVertex[]{TexturedVertex5, TexturedVertex1, TexturedVertex2, TexturedVertex6}, w, h, w + 1, h + 1);
        poly[1] = this.addPolygonReturn(new TexturedVertex[]{TexturedVertex0, TexturedVertex4, TexturedVertex7, TexturedVertex3}, w, h, w + 1, h + 1);
        poly[2] = this.addPolygonReturn(new TexturedVertex[]{TexturedVertex5, TexturedVertex4, TexturedVertex0, TexturedVertex1}, w, h, w + 1, h + 1);
        poly[3] = this.addPolygonReturn(new TexturedVertex[]{TexturedVertex2, TexturedVertex3, TexturedVertex7, TexturedVertex6}, w, h, w + 1, h + 1);
        poly[4] = this.addPolygonReturn(new TexturedVertex[]{TexturedVertex1, TexturedVertex0, TexturedVertex3, TexturedVertex2}, w, h, w + 1, h + 1);
        poly[5] = this.addPolygonReturn(new TexturedVertex[]{TexturedVertex4, TexturedVertex5, TexturedVertex6, TexturedVertex7}, w, h, w + 1, h + 1);
        return this.copyTo(poly);
    }

    public ModelRendererTurbo addSprite(float x, float y, float z, int w, int h, float expansion) {
        return this.addSprite(x, y, z, w, h, 1, false, false, false, false, false, expansion);
    }

    public ModelRendererTurbo addSprite(float x, float y, float z, int w, int h, boolean rotX, boolean rotY, boolean rotZ, boolean mirrorX, boolean mirrorY, float expansion) {
        return this.addSprite(x, y, z, w, h, 1, rotX, rotY, rotZ, mirrorX, mirrorY, expansion);
    }

    public ModelRendererTurbo addSprite(float x, float y, float z, int w, int h, int d, boolean rotX, boolean rotY, boolean rotZ, boolean mirrorX, boolean mirrorY, float expansion) {
        return this.addSprite(x, y, z, w, h, d, 1.0f, rotX, rotY, rotZ, mirrorX, mirrorY, expansion);
    }

    public ModelRendererTurbo addSprite(float x, float y, float z, int w, int h, int d, float pixelScale, boolean rotX, boolean rotY, boolean rotZ, boolean mirrorX, boolean mirrorY, float expansion) {
        Object[] mask = new String[h];
        char[] str = new char[w];
        Arrays.fill(str, '1');
        Arrays.fill(mask, new String(str));
        return this.addSprite(x, y, z, (String[])mask, d, pixelScale, rotX, rotY, rotZ, mirrorX, mirrorY, expansion);
    }

    public ModelRendererTurbo addSprite(float x, float y, float z, String[] mask, int d, float pixelScale, boolean rotX, boolean rotY, boolean rotZ, boolean mirrorX, boolean mirrorY, float expansion) {
        int w = mask[0].length();
        int h = mask.length;
        int wDir = 0;
        int hDir = 0;
        int dDir = 0;
        float x1 = x - expansion;
        float y1 = y - expansion;
        float z1 = z - expansion;
        float wScale = 1.0f + expansion / ((float)w * pixelScale);
        float hScale = 1.0f + expansion / ((float)h * pixelScale);
        if (!rotX) {
            if (!rotY) {
                if (!rotZ) {
                    wDir = 0;
                    hDir = 1;
                    dDir = 2;
                } else {
                    wDir = 1;
                    hDir = 0;
                    dDir = 2;
                }
            } else if (!rotZ) {
                wDir = 2;
                hDir = 1;
                dDir = 0;
            } else {
                wDir = 2;
                hDir = 0;
                dDir = 1;
            }
        } else if (!rotY) {
            if (!rotZ) {
                wDir = 0;
                hDir = 2;
                dDir = 1;
            } else {
                wDir = 1;
                hDir = 2;
                dDir = 0;
            }
        } else if (!rotZ) {
            wDir = 2;
            hDir = 0;
            dDir = 1;
        } else {
            wDir = 2;
            hDir = 1;
            dDir = 0;
        }
        int texStartX = this.texoffx + (mirrorX ? w * 1 - 1 : 0);
        int texStartY = this.texoffy + (mirrorY ? h * 1 - 1 : 0);
        int texDirX = mirrorX ? -1 : 1;
        int texDirY = mirrorY ? -1 : 1;
        float wVoxSize = this.getPixelSize(wScale, hScale, (float)d * pixelScale + expansion * 2.0f, 0, 1, wDir, 1, 1);
        float hVoxSize = this.getPixelSize(wScale, hScale, (float)d * pixelScale + expansion * 2.0f, 0, 1, hDir, 1, 1);
        float dVoxSize = this.getPixelSize(wScale, hScale, (float)d * pixelScale + expansion * 2.0f, 0, 1, dDir, 1, 1);
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                if (mask[j].charAt(i) != '1') continue;
                this.addPixel(x1 + this.getPixelSize(wScale, hScale, 0.0f, wDir, hDir, 0, i, j), y1 + this.getPixelSize(wScale, hScale, 0.0f, wDir, hDir, 1, i, j), z1 + this.getPixelSize(wScale, hScale, 0.0f, wDir, hDir, 2, i, j), new float[]{wVoxSize, hVoxSize, dVoxSize}, texStartX + texDirX * i, texStartY + texDirY * j);
            }
        }
        return this;
    }

    private float getPixelSize(float wScale, float hScale, float dScale, int wDir, int hDir, int checkDir, int texPosX, int texPosY) {
        return wDir == checkDir ? wScale * (float)texPosX : (hDir == checkDir ? hScale * (float)texPosY : dScale);
    }

    public ModelRendererTurbo addSphere(float x, float y, float z, float r, int segs, int rings, int textureW, int textureH) {
        TexturedVertex[] verts;
        if (segs < 3) {
            segs = 3;
        }
        TexturedVertex[] tempVerts = new TexturedVertex[segs * (++rings - 1) + 2];
        TexturedPolygon[] poly = new TexturedPolygon[segs * rings];
        tempVerts[0] = new TexturedVertex(x, y - r, z, 0.0f, 0.0f);
        tempVerts[tempVerts.length - 1] = new TexturedVertex(x, y + r, z, 0.0f, 0.0f);
        float uOffs = 1.0f / (this.textureWidth * 10.0f);
        float vOffs = 1.0f / (this.textureHeight * 10.0f);
        float texW = (float)textureW / this.textureWidth - 2.0f * uOffs;
        float texH = (float)textureH / this.textureHeight - 2.0f * vOffs;
        float segW = texW / (float)segs;
        float segH = texH / (float)rings;
        float startU = (float)this.texoffx / this.textureWidth;
        float startV = (float)this.texoffy / this.textureHeight;
        int currentFace = 0;
        for (int j = 1; j < rings; ++j) {
            for (int i = 0; i < segs; ++i) {
                float yWidth = (float)Math.cos(-1.5707964f + (float)Math.PI / (float)rings * (float)j);
                float yHeight = (float)Math.sin(-1.5707964f + (float)Math.PI / (float)rings * (float)j);
                float xSize = (float)(Math.sin((float)Math.PI / (float)segs * (float)i * 2.0f + (float)Math.PI) * (double)yWidth);
                float zSize = (float)(-Math.cos((float)Math.PI / (float)segs * (float)i * 2.0f + (float)Math.PI) * (double)yWidth);
                int curVert = 1 + i + segs * (j - 1);
                tempVerts[curVert] = new TexturedVertex(x + xSize * r, y + yHeight * r, z + zSize * r, 0.0f, 0.0f);
                if (i <= 0) continue;
                TexturedVertex[] verts2 = j == 1 ? new TexturedVertex[]{tempVerts[curVert].setTexturePosition(startU + segW * (float)i, startV + segH * (float)j), tempVerts[curVert - 1].setTexturePosition(startU + segW * (float)(i - 1), startV + segH * (float)j), tempVerts[0].setTexturePosition(startU + segW * (float)(i - 1), startV), tempVerts[0].setTexturePosition(startU + segW + segW * (float)i, startV)} : new TexturedVertex[]{tempVerts[curVert].setTexturePosition(startU + segW * (float)i, startV + segH * (float)j), tempVerts[curVert - 1].setTexturePosition(startU + segW * (float)(i - 1), startV + segH * (float)j), tempVerts[curVert - 1 - segs].setTexturePosition(startU + segW * (float)(i - 1), startV + segH * (float)(j - 1)), tempVerts[curVert - segs].setTexturePosition(startU + segW * (float)i, startV + segH * (float)(j - 1))};
                poly[currentFace] = new TexturedPolygon(verts2);
                ++currentFace;
            }
            verts = j == 1 ? new TexturedVertex[]{tempVerts[1].setTexturePosition(startU + segW * (float)segs, startV + segH * (float)j), tempVerts[segs].setTexturePosition(startU + segW * (float)(segs - 1), startV + segH * (float)j), tempVerts[0].setTexturePosition(startU + segW * (float)(segs - 1), startV), tempVerts[0].setTexturePosition(startU + segW * (float)segs, startV)} : new TexturedVertex[]{tempVerts[1 + segs * (j - 1)].setTexturePosition(startU + texW, startV + segH * (float)j), tempVerts[segs * (j - 1) + segs].setTexturePosition(startU + texW - segW, startV + segH * (float)j), tempVerts[segs * (j - 1)].setTexturePosition(startU + texW - segW, startV + segH * (float)(j - 1)), tempVerts[1 + segs * (j - 1) - segs].setTexturePosition(startU + texW, startV + segH * (float)(j - 1))};
            poly[currentFace] = new TexturedPolygon(verts);
            ++currentFace;
        }
        for (int i = 0; i < segs; ++i) {
            verts = new TexturedVertex[3];
            int curVert = tempVerts.length - (segs + 1);
            verts[0] = tempVerts[tempVerts.length - 1].setTexturePosition(startU + segW * ((float)i + 0.5f), startV + texH);
            verts[1] = tempVerts[curVert + i].setTexturePosition(startU + segW * (float)i, startV + texH - segH);
            verts[2] = tempVerts[curVert + (i + 1) % segs].setTexturePosition(startU + segW * (float)(i + 1), startV + texH - segH);
            poly[currentFace] = new TexturedPolygon(verts);
            ++currentFace;
        }
        if (!this.flip && !this.mirror) {
            for (TexturedPolygon poli : poly) {
                poli.flipFace();
            }
        }
        return this.copyTo(poly);
    }

    public ModelRendererTurbo addCone(float x, float y, float z, float radius, float length, int segments) {
        return this.addCone(x, y, z, radius, length, segments, 1.0f);
    }

    public ModelRendererTurbo addCone(float x, float y, float z, float radius, float length, int segments, float baseScale) {
        return this.addCone(x, y, z, radius, length, segments, baseScale, 4);
    }

    public ModelRendererTurbo addCone(float x, float y, float z, float radius, float length, int segments, float baseScale, int baseDirection) {
        return this.addCone(x, y, z, radius, length, segments, baseScale, baseDirection, (int)Math.floor(radius * 2.0f), (int)Math.floor(radius * 2.0f));
    }

    public ModelRendererTurbo addCone(float x, float y, float z, float radius, float length, int segments, float baseScale, int baseDirection, int textureCircleDiameterW, int textureCircleDiameterH) {
        return this.addCylinder(x, y, z, radius, length, segments, baseScale, 0.0f, baseDirection, textureCircleDiameterW, textureCircleDiameterH, 1, null);
    }

    public ModelRendererTurbo addCylinder(float x, float y, float z, float radius, float length, int segments) {
        return this.addCylinder(x, y, z, radius, length, segments, 1.0f, 1.0f);
    }

    public ModelRendererTurbo addCylinder(float x, float y, float z, float radius, float length, int segments, float baseScale, float topScale) {
        return this.addCylinder(x, y, z, radius, length, segments, baseScale, topScale, 4);
    }

    public ModelRendererTurbo addCylinder(float x, float y, float z, float radius, float length, int segments, float baseScale, float topScale, int baseDirection) {
        return this.addCylinder(x, y, z, radius, length, segments, baseScale, topScale, baseDirection, (int)Math.floor(radius * 2.0f), (int)Math.floor(radius * 2.0f), (int)Math.floor(length), null);
    }

    public ModelRendererTurbo addCylinder(float x, float y, float z, float radius, float length, int segments, float baseScale, float topScale, int baseDirection, Vec3f topoff) {
        return this.addCylinder(x, y, z, radius, length, segments, baseScale, topScale, baseDirection, (int)Math.floor(radius * 2.0f), (int)Math.floor(radius * 2.0f), (int)Math.floor(length), topoff);
    }

    public ModelRendererTurbo addCylinder(float x, float y, float z, float radius, float length, int segments, float baseScale, float topScale, int baseDirection, int textureCircleDiameterW, int textureCircleDiameterH, int textureH, Vec3f topoff) {
        boolean coneTop;
        if (radius < 1.0f) {
            int rad;
            int n = rad = (double)radius < 0.5 ? 1 : 2;
            if (textureCircleDiameterW < rad) {
                textureCircleDiameterW = rad;
            }
            if (textureCircleDiameterH < rad) {
                textureCircleDiameterH = rad;
            }
        }
        if (length < 1.0f) {
            textureH = 1;
        } else if (length % 1.0f != 0.0f) {
            textureH = (int)length + (length % 1.0f > 0.5f ? 1 : 0);
        }
        boolean dirTop = baseDirection == 4 || baseDirection == 5;
        boolean dirSide = baseDirection == 3 || baseDirection == 2;
        boolean dirFront = baseDirection == 0 || baseDirection == 1;
        boolean dirMirror = baseDirection == 2 || baseDirection == 5 || baseDirection == 1;
        boolean coneBase = baseScale == 0.0f;
        boolean bl = coneTop = topScale == 0.0f;
        if (coneBase && coneTop) {
            baseScale = 1.0f;
            coneBase = false;
        }
        TexturedVertex[] tempVerts = new TexturedVertex[segments * (coneBase || coneTop ? 1 : 2) + 2];
        TexturedPolygon[] poly = new TexturedPolygon[segments * (coneBase || coneTop ? 2 : 3)];
        float xLength = dirSide ? length : 0.0f;
        float yLength = dirTop ? length : 0.0f;
        float zLength = dirFront ? length : 0.0f;
        float xStart = dirMirror ? x + xLength : x;
        float yStart = dirMirror ? y + yLength : y;
        float zStart = dirMirror ? z + zLength : z;
        float xEnd = (!dirMirror ? x + xLength : x) + (topoff == null ? 0.0f : topoff.x);
        float yEnd = (!dirMirror ? y + yLength : y) + (topoff == null ? 0.0f : topoff.y);
        float zEnd = (!dirMirror ? z + zLength : z) + (topoff == null ? 0.0f : topoff.z);
        tempVerts[0] = new TexturedVertex(xStart, yStart, zStart, 0.0f, 0.0f);
        tempVerts[tempVerts.length - 1] = new TexturedVertex(xEnd, yEnd, zEnd, 0.0f, 0.0f);
        float xCur = xStart;
        float yCur = yStart;
        float zCur = zStart;
        float sCur = coneBase ? topScale : baseScale;
        for (int repeat = 0; repeat < (coneBase || coneTop ? 1 : 2); ++repeat) {
            for (int index = 0; index < segments; ++index) {
                float xSize = (float)((double)(this.mirror ^ dirMirror ? -1 : 1) * Math.sin((float)Math.PI / (float)segments * (float)index * 2.0f + (float)Math.PI) * (double)radius * (double)sCur);
                float zSize = (float)(-Math.cos((float)Math.PI / (float)segments * (float)index * 2.0f + (float)Math.PI) * (double)radius * (double)sCur);
                float xPlace = xCur + (!dirSide ? xSize : 0.0f);
                float yPlace = yCur + (!dirTop ? zSize : 0.0f);
                float zPlace = zCur + (dirSide ? xSize : (dirTop ? zSize : 0.0f));
                tempVerts[1 + index + repeat * segments] = new TexturedVertex(xPlace, yPlace, zPlace, 0.0f, 0.0f);
            }
            xCur = xEnd;
            yCur = yEnd;
            zCur = zEnd;
            sCur = topScale;
        }
        float uScale = 1.0f / this.textureWidth;
        float vScale = 1.0f / this.textureHeight;
        float uOffset = 0.0f;
        float vOffset = 0.0f;
        float uCircle = (float)textureCircleDiameterW * uScale;
        float vCircle = (float)textureCircleDiameterH * vScale;
        float uWidth = (uCircle * 2.0f - uOffset * 2.0f) / (float)segments;
        float vHeight = (float)textureH * vScale - uOffset * 2.0f;
        float uStart = (float)this.texoffx * uScale;
        float vStart = (float)this.texoffy * vScale;
        for (int index = 0; index < segments; ++index) {
            int index2 = (index + 1) % segments;
            float uSize = (float)(Math.sin((float)Math.PI / (float)segments * (float)index * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle - 2.0f * uOffset));
            float vSize = (float)(Math.cos((float)Math.PI / (float)segments * (float)index * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle - 2.0f * vOffset));
            float uSize1 = (float)(Math.sin((float)Math.PI / (float)segments * (float)index2 * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle - 2.0f * uOffset));
            float vSize1 = (float)(Math.cos((float)Math.PI / (float)segments * (float)index2 * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle - 2.0f * vOffset));
            TexturedVertex[] vert = new TexturedVertex[]{tempVerts[0].setTexturePosition(uStart + 0.5f * uCircle, vStart + 0.5f * vCircle), tempVerts[1 + index2].setTexturePosition(uStart + 0.5f * uCircle + uSize1, vStart + 0.5f * vCircle + vSize1), tempVerts[1 + index].setTexturePosition(uStart + 0.5f * uCircle + uSize, vStart + 0.5f * vCircle + vSize)};
            poly[index] = new TexturedPolygon(vert);
            if (!dirFront || this.mirror || this.flip) {
                poly[index].flipFace();
            }
            if (!coneBase && !coneTop) {
                vert = new TexturedVertex[]{tempVerts[1 + index].setTexturePosition(uStart + uOffset + uWidth * (float)index, vStart + vOffset + vCircle), tempVerts[1 + index2].setTexturePosition(uStart + uOffset + uWidth * (float)(index + 1), vStart + vOffset + vCircle), tempVerts[1 + segments + index2].setTexturePosition(uStart + uOffset + uWidth * (float)(index + 1), vStart + vOffset + vCircle + vHeight), tempVerts[1 + segments + index].setTexturePosition(uStart + uOffset + uWidth * (float)index, vStart + vOffset + vCircle + vHeight)};
                poly[index + segments] = new TexturedPolygon(vert);
                if (!dirFront || this.mirror || this.flip) {
                    poly[index + segments].flipFace();
                }
            }
            vert = new TexturedVertex[]{tempVerts[tempVerts.length - 1].setTexturePosition(uStart + 1.5f * uCircle, vStart + 0.5f * vCircle), tempVerts[tempVerts.length - 2 - index].setTexturePosition(uStart + 1.5f * uCircle + uSize1, vStart + 0.5f * vCircle + vSize1), tempVerts[tempVerts.length - (1 + segments) + (segments - index) % segments].setTexturePosition(uStart + 1.5f * uCircle + uSize, vStart + 0.5f * vCircle + vSize)};
            poly[poly.length - segments + index] = new TexturedPolygon(vert);
            if (dirFront && !this.mirror && !this.flip) continue;
            poly[poly.length - segments + index].flipFace();
        }
        return this.copyTo(poly);
    }

    public ModelRendererTurbo addHollowCylinder(float x, float y, float z, float radius, float radius2, float length, int segments, int seglimit, float baseScale, float topScale, int baseDirection) {
        return this.addHollowCylinder(x, y, z, radius, radius2, length, segments, seglimit, baseScale, topScale, baseDirection, null);
    }

    public ModelRendererTurbo addHollowCylinder(float x, float y, float z, float radius, float radius2, float length, int segments, int seglimit, float baseScale, float topScale, int baseDirection, Vec3f topoff) {
        return this.addHollowCylinder(x, y, z, radius, radius2, length, segments, seglimit, baseScale, topScale, baseDirection, (int)Math.floor(radius * 2.0f), (int)Math.floor(radius * 2.0f), (int)Math.floor(length), topoff, new boolean[4]);
    }

    public ModelRendererTurbo addHollowCylinder(float x, float y, float z, float radius, float radius2, float length, int segments, int seglimit, float baseScale, float topScale, int baseDirection, Vec3f topoff, boolean[] bools) {
        return this.addHollowCylinder(x, y, z, radius, radius2, length, segments, seglimit, baseScale, topScale, baseDirection, (int)Math.floor(radius * 2.0f), (int)Math.floor(radius * 2.0f), (int)Math.floor(length), topoff, bools);
    }

    public CylinderBuilder newCylinderBuilder() {
        return new CylinderBuilder(this);
    }

    public BoxBuilder newBoxBuilder() {
        return new BoxBuilder(this);
    }

    public ModelRendererTurbo addHollowCylinder(float x, float y, float z, float radius, float radius2, float length, int segments, int seglimit, float baseScale, float topScale, int baseDirection, int textureCircleDiameterW, int textureCircleDiameterH, int textureH, Vec3f topoff, boolean[] bools) {
        boolean dirMirror;
        if (radius < 1.0f) {
            int rad;
            int n = rad = (double)radius < 0.5 ? 1 : 2;
            if (textureCircleDiameterW < rad) {
                textureCircleDiameterW = rad;
            }
            if (textureCircleDiameterH < rad) {
                textureCircleDiameterH = rad;
            }
        }
        if (length < 1.0f) {
            textureH = 1;
        } else if (length % 1.0f != 0.0f) {
            textureH = (int)length + (length % 1.0f > 0.5f ? 1 : 0);
        }
        boolean dirTop = baseDirection == 4 || baseDirection == 5;
        boolean dirSide = baseDirection == 3 || baseDirection == 2;
        boolean dirFront = baseDirection == 0 || baseDirection == 1;
        boolean bl = dirMirror = baseDirection == 2 || baseDirection == 5 || baseDirection == 1;
        if (baseScale == 0.0f) {
            baseScale = 1.0f;
        }
        if (topScale == 0.0f) {
            topScale = 1.0f;
        }
        if (segments < 3) {
            segments = 3;
        }
        if (seglimit <= 0) {
            seglimit = segments;
        }
        boolean segl = seglimit < segments;
        ArrayList verts = new ArrayList();
        ArrayList<TexturedPolygon> polis = new ArrayList<TexturedPolygon>();
        float xLength = dirSide ? length : 0.0f;
        float yLength = dirTop ? length : 0.0f;
        float zLength = dirFront ? length : 0.0f;
        float xStart = dirMirror ? x + xLength : x;
        float yStart = dirMirror ? y + yLength : y;
        float zStart = dirMirror ? z + zLength : z;
        float xEnd = (!dirMirror ? x + xLength : x) + (topoff == null ? 0.0f : topoff.x);
        float yEnd = (!dirMirror ? y + yLength : y) + (topoff == null ? 0.0f : topoff.y);
        float zEnd = (!dirMirror ? z + zLength : z) + (topoff == null ? 0.0f : topoff.z);
        float xCur = xStart;
        float yCur = yStart;
        float zCur = zStart;
        float sCur = baseScale;
        float uScale = 1.0f / this.textureWidth;
        float vScale = 1.0f / this.textureHeight;
        float uOffset = uScale;
        float vOffset = vScale;
        float uCircle = (float)textureCircleDiameterW * uScale;
        float vCircle = (float)textureCircleDiameterH * vScale;
        float uCircle2 = (float)((int)Math.floor(radius2 * 2.0f)) * uScale;
        float vCircle2 = (float)((int)Math.floor(radius2 * 2.0f)) * vScale;
        float uWidth = (uCircle * 2.0f - uOffset * 2.0f) / (float)segments;
        float vHeight = (float)textureH * vScale - uOffset * 2.0f;
        float uStart = (float)this.texoffx * uScale;
        float vStart = (float)this.texoffy * vScale;
        ArrayList<TexturedVertex> verts0 = new ArrayList<TexturedVertex>();
        ArrayList<TexturedVertex> verts1 = new ArrayList<TexturedVertex>();
        ArrayList<TexturedVertex> verts2 = new ArrayList<TexturedVertex>();
        ArrayList<TexturedVertex> verts3 = new ArrayList<TexturedVertex>();
        for (int repeat = 0; repeat < 2; ++repeat) {
            boolean bool;
            float mul;
            for (int index = 0; index < segments; ++index) {
                float xSize = (float)((double)(this.mirror ^ dirMirror ? -1 : 1) * Math.sin((float)Math.PI / (float)segments * (float)index * 2.0f + (float)Math.PI) * (double)radius * (double)sCur);
                float zSize = (float)(-Math.cos((float)Math.PI / (float)segments * (float)index * 2.0f + (float)Math.PI) * (double)radius * (double)sCur);
                float xPlace = xCur + (!dirSide ? xSize : 0.0f);
                float yPlace = yCur + (!dirTop ? zSize : 0.0f);
                float zPlace = zCur + (dirSide ? xSize : (dirTop ? zSize : 0.0f));
                verts0.add(new TexturedVertex(xPlace, yPlace, zPlace, 0.0f, 0.0f));
                if (index == segments - 1) {
                    TexturedVertex copy = new TexturedVertex((TexturedVertex)verts0.get(0));
                    verts0.add(copy);
                }
                float xSize2 = (float)((double)(this.mirror ^ dirMirror ? -1 : 1) * Math.sin((float)Math.PI / (float)segments * (float)index * 2.0f + (float)Math.PI) * (double)radius2 * (double)sCur);
                float zSize2 = (float)(-Math.cos((float)Math.PI / (float)segments * (float)index * 2.0f + (float)Math.PI) * (double)radius2 * (double)sCur);
                xPlace = xCur + (!dirSide ? xSize2 : 0.0f);
                yPlace = yCur + (!dirTop ? zSize2 : 0.0f);
                zPlace = zCur + (dirSide ? xSize2 : (dirTop ? zSize2 : 0.0f));
                verts1.add(new TexturedVertex(xPlace, yPlace, zPlace, 0.0f, 0.0f));
                if (index != segments - 1) continue;
                TexturedVertex copy = new TexturedVertex((TexturedVertex)verts1.get(0));
                verts1.add(copy);
            }
            verts.addAll(verts0);
            verts.addAll(verts1);
            if (repeat == 0) {
                verts2.addAll(verts0);
                verts2.addAll(verts1);
            } else {
                verts3.addAll(verts0);
                verts3.addAll(verts1);
            }
            float f = mul = repeat == 0 ? 0.5f : 1.5f;
            boolean bl2 = repeat == 0 ? !dirFront : (bool = dirFront);
            if (repeat == 0 && !bools[0] || repeat == 1 && !bools[1]) {
                for (int i = 0; i < verts0.size() && i < verts0.size() - 1 && i < seglimit; ++i) {
                    TexturedVertex[] arr = new TexturedVertex[4];
                    float xSize = (float)(Math.sin((float)Math.PI / (float)segments * (float)i * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle - 2.0f * uOffset));
                    float ySize = (float)(Math.cos((float)Math.PI / (float)segments * (float)i * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle - 2.0f * vOffset));
                    arr[0] = ((TexturedVertex)verts0.get(i)).setTexturePosition(uStart + mul * uCircle + xSize, vStart + 0.5f * vCircle + ySize);
                    xSize = (float)(Math.sin((float)Math.PI / (float)segments * (float)i * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle2 - 2.0f * uOffset));
                    ySize = (float)(Math.cos((float)Math.PI / (float)segments * (float)i * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle2 - 2.0f * vOffset));
                    arr[1] = ((TexturedVertex)verts1.get(i)).setTexturePosition(uStart + mul * uCircle + xSize, vStart + 0.5f * vCircle + ySize);
                    xSize = (float)(Math.sin((float)Math.PI / (float)segments * (float)(i + 1) * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle2 - 2.0f * uOffset));
                    ySize = (float)(Math.cos((float)Math.PI / (float)segments * (float)(i + 1) * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle2 - 2.0f * vOffset));
                    arr[2] = ((TexturedVertex)verts1.get(i + 1)).setTexturePosition(uStart + mul * uCircle + xSize, vStart + 0.5f * vCircle + ySize);
                    xSize = (float)(Math.sin((float)Math.PI / (float)segments * (float)(i + 1) * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle - 2.0f * uOffset));
                    ySize = (float)(Math.cos((float)Math.PI / (float)segments * (float)(i + 1) * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle - 2.0f * vOffset));
                    arr[3] = ((TexturedVertex)verts0.get(i + 1)).setTexturePosition(uStart + mul * uCircle + xSize, vStart + 0.5f * vCircle + ySize);
                    polis.add(new TexturedPolygon(arr));
                    if (!bool) continue;
                    polis.get(polis.size() - 1).flipFace();
                }
            }
            verts0.clear();
            verts1.clear();
            xCur = xEnd;
            yCur = yEnd;
            zCur = zEnd;
            sCur = topScale;
        }
        int halfv2 = verts2.size() / 2;
        for (int i = 0; i < halfv2; ++i) {
            if (i >= seglimit && segl) {
                TexturedVertex[] arr = new TexturedVertex[4];
                float xpos = uStart + uOffset + uCircle * 2.0f;
                arr[0] = ((TexturedVertex)verts2.get(0)).setTexturePosition(xpos, vStart + vOffset + vCircle);
                arr[1] = ((TexturedVertex)verts3.get(0)).setTexturePosition(xpos, vStart + vOffset + vCircle + vHeight);
                arr[2] = ((TexturedVertex)verts3.get(halfv2)).setTexturePosition(xpos + (radius - radius2) * uScale, vStart + vOffset + vCircle + vHeight);
                arr[3] = ((TexturedVertex)verts2.get(halfv2)).setTexturePosition(xpos + (radius - radius2) * uScale, vStart + vOffset + vCircle);
                polis.add(new TexturedPolygon(arr));
                if (!dirFront) {
                    polis.get(polis.size() - 1).flipFace();
                }
                arr = new TexturedVertex[]{((TexturedVertex)verts2.get(seglimit)).setTexturePosition(xpos, vStart + vOffset + vCircle + vHeight), ((TexturedVertex)verts3.get(seglimit)).setTexturePosition(xpos, vStart + vOffset + vCircle + vHeight + vHeight), ((TexturedVertex)verts3.get(seglimit + halfv2)).setTexturePosition(xpos + (radius - radius2) * uScale, vStart + vOffset + vCircle + vHeight + vHeight), ((TexturedVertex)verts2.get(seglimit + halfv2)).setTexturePosition(xpos + (radius - radius2) * uScale, vStart + vOffset + vCircle + vHeight)};
                polis.add(new TexturedPolygon(arr));
                if (!dirFront) break;
                polis.get(polis.size() - 1).flipFace();
                break;
            }
            if (i >= halfv2 - 1) break;
            TexturedVertex[] arr = new TexturedVertex[4];
            if (!bools[2]) {
                arr[0] = ((TexturedVertex)verts2.get(i + 0)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 0), vStart + vOffset + vCircle);
                arr[1] = ((TexturedVertex)verts3.get(i + 0)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 0), vStart + vOffset + vCircle + vHeight);
                arr[2] = ((TexturedVertex)verts3.get(i + 1)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 1), vStart + vOffset + vCircle + vHeight);
                arr[3] = ((TexturedVertex)verts2.get(i + 1)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 1), vStart + vOffset + vCircle);
                polis.add(new TexturedPolygon(arr));
                if (dirFront) {
                    polis.get(polis.size() - 1).flipFace();
                }
            }
            if (bools[3]) continue;
            arr = new TexturedVertex[]{((TexturedVertex)verts2.get(i + halfv2 + 0)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 0), vStart + vOffset + vCircle + vHeight), ((TexturedVertex)verts3.get(i + halfv2 + 0)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 0), vStart + vOffset + vCircle + vHeight + vHeight), ((TexturedVertex)verts3.get(i + halfv2 + 1)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 1), vStart + vOffset + vCircle + vHeight + vHeight), ((TexturedVertex)verts2.get(i + halfv2 + 1)).setTexturePosition(uStart + uOffset + uWidth * (float)(i + 1), vStart + vOffset + vCircle + vHeight)};
            polis.add(new TexturedPolygon(arr));
            if (dirFront) continue;
            polis.get(polis.size() - 1).flipFace();
        }
        return this.copyTo(polis);
    }

    public ModelRendererTurbo addObj(InputStream stream) {
        ObjParser.ObjModel model = new ObjParser(stream).readComments(false).readModel(true).skipUV(!this.textured).parse();
        model.polygons.forEach((key, val) -> this.copyTo((Collection<TexturedPolygon>)val));
        return this;
    }

    public ModelRendererTurbo setTextureOffset(int x, int y) {
        this.texoffx = x;
        this.texoffy = y;
        return this;
    }

    public ModelRendererTurbo setPosition(float x, float y, float z) {
        this.rotationPointX = x;
        this.rotationPointY = y;
        this.rotationPointZ = z;
        return this;
    }

    public ModelRendererTurbo doMirror(boolean x, boolean y, boolean z) {
        for (TexturedPolygon face : this.faces) {
            TexturedVertex[] verts;
            for (TexturedVertex vert : verts = face.getVertices()) {
                vert.vector.add(vert.vector.x * (float)(x ? -1 : 1), vert.vector.y * (float)(y ? -1 : 1), vert.vector.z * (float)(z ? -1 : 1));
            }
            if (!(x ^ y ^ z)) continue;
            face.flipFace();
        }
        return this;
    }

    public ModelRendererTurbo setMirrored(boolean isMirrored) {
        this.mirror = isMirrored;
        return this;
    }

    public ModelRendererTurbo setFlipped(boolean isFlipped) {
        this.flip = isFlipped;
        return this;
    }

    public ModelRendererTurbo clear() {
        if (this.childModels != null) {
            this.childModels.clear();
        }
        this.faces.clear();
        return this;
    }

    public ModelRendererTurbo copyTo(TexturedPolygon ... poly) {
        this.faces.addAll(Arrays.asList(poly));
        return this;
    }

    public ModelRendererTurbo copyTo(Collection<TexturedPolygon> coll) {
        this.faces.addAll(coll);
        return this;
    }

    public void render() {
        this.render(0.0625f);
    }

    public void render(float scale) {
        if (!this.showModel) {
            return;
        }
        RENDERER.render(this, scale);
    }

    public RGB getColor(int face) {
        return ModelRendererTurbo.getColor(this, face);
    }

    public static RGB getColor(ModelRendererTurbo turbo, int face) {
        if (turbo.polygonColor != null) {
            return turbo.polygonColor;
        }
        switch (face) {
            case 0: {
                return blu0;
            }
            case 1: {
                return blu1;
            }
            case 2: {
                return red1;
            }
            case 3: {
                return red0;
            }
            case 4: {
                return gre1;
            }
            case 5: {
                return gre0;
            }
        }
        if (face > 32) {
            face %= 32;
        }
        if (face < 32) {
            if (face % 3 == 0) {
                return new RGB(138, 92, 192 - face * 4);
            }
            if (face % 3 == 1) {
                return new RGB(192 - face * 4, 138, 92);
            }
            if (face % 3 == 2) {
                return new RGB(92, 192 - face * 4, 138);
            }
        }
        return gray;
    }

    public RGB getColor() {
        return this.polygonColor;
    }

    public String getTexture() {
        return this.texName;
    }

    public ModelRendererTurbo addShapeBox(float x, float y, float z, int w, int h, int d, float scale, float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float x5, float y5, float z5, float x6, float y6, float z6, float x7, float y7, float z7) {
        return this.addShapeBox(x, y, z, (float)w, (float)h, (float)d, scale, x0, y0, z0, x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, x7, y7, z7);
    }

    public ModelRendererTurbo addShapeBox(float x, float y, float z, float w, float h, float d, float scale, float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float x5, float y5, float z5, float x6, float y6, float z6, float x7, float y7, float z7) {
        return this.addShapeBox(x, y, z, w, h, d, scale, x0, y0, z0, x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, x7, y7, z7, null);
    }

    public ModelRendererTurbo addShapeBox(float x, float y, float z, float w, float h, float d, float scale, float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float x5, float y5, float z5, float x6, float y6, float z6, float x7, float y7, float z7, boolean[] sides) {
        float xw = x + w;
        float yh = y + h;
        float zd = z + d;
        x -= scale;
        y -= scale;
        z -= scale;
        xw += scale;
        yh += scale;
        zd += scale;
        if (this.mirror) {
            float fl = xw;
            xw = x;
            x = fl;
        }
        float[] v0 = new float[]{x - x0, y - y0, z - z0};
        float[] v1 = new float[]{xw + x1, y - y1, z - z1};
        float[] v2 = new float[]{xw + x5, yh + y5, z - z5};
        float[] v3 = new float[]{x - x4, yh + y4, z - z4};
        float[] v4 = new float[]{x - x3, y - y3, zd + z3};
        float[] v5 = new float[]{xw + x2, y - y2, zd + z2};
        float[] v6 = new float[]{xw + x6, yh + y6, zd + z6};
        float[] v7 = new float[]{x - x7, yh + y7, zd + z7};
        return this.addRectShape(v0, v1, v2, v3, v4, v5, v6, v7, w, h, d, sides);
    }

    public String toString(String alt) {
        String str = this.toString();
        return str == null || str.equals("") ? alt : str;
    }

    public String toString() {
        return this.boxName;
    }

    public ArrayList<TexturedPolygon> getFaces() {
        return this.faces;
    }

    public Integer displaylist() {
        return this.glId;
    }

    public Integer glId() {
        return this.glId;
    }

    public Integer glId(Integer newId) {
        this.glId = newId;
        return this.glId;
    }

    public <T> T glObject() {
        return (T)this.glObj;
    }

    public <T> T glObject(T obj) {
        this.glObj = obj;
        return (T)this.glObj;
    }

    public ModelRendererTurbo createChildList() {
        this.childModels = new ArrayList<ModelRendererTurbo>();
        return this;
    }

    public ModelRendererTurbo addChild(ModelRendererTurbo model) {
        if (this.childModels == null) {
            this.createChildList();
        }
        this.childModels.add(model);
        return this;
    }

    public void integrateChildren(boolean removelist) {
        for (ModelRendererTurbo turbo : this.childModels) {
            this.copyTo(turbo.getFaces());
        }
        if (removelist) {
            this.childModels = null;
        } else {
            this.childModels.clear();
        }
    }

    public ModelRendererTurbo addVoxelShape(int segmentation, boolean[][][] content) {
        return new VoxelBuilder(this, segmentation).setVoxels(content).build();
    }

    public ModelRendererTurbo addVoxelShape(int x, int y, int z, boolean[][][] content) {
        return new VoxelBuilder(this, x, y, z).setVoxels(content).build();
    }

    public ModelRendererTurbo addColorIndexedVoxelShape(int sx, int sy, int sz, int[][][] content, Map<Integer, RGB> colours) {
        return new ColorIndexedVoxelBuilder(this, sx, sy, sz).setColors(colours).setVoxels(content).build();
    }

    public static abstract class Renderer {
        public abstract void render(ModelRendererTurbo var1, float var2);
    }
}

